/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.asf;

import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.jms.asf.ServerSessionPoolFactory;
import org.jboss.jms.asf.ServerSessionPoolLoaderMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.util.naming.NonSerializableFactory;

public class ServerSessionPoolLoader
extends ServiceMBeanSupport
implements ServerSessionPoolLoaderMBean {
    private ServerSessionPoolFactory poolFactory;
    private String name;
    private String poolFactoryClass;
    private ObjectName xidFactory;

    public void setPoolName(String name) {
        this.name = name;
    }

    public String getPoolName() {
        return this.name;
    }

    public void setPoolFactoryClass(String classname) {
        this.poolFactoryClass = classname;
    }

    public String getPoolFactoryClass() {
        return this.poolFactoryClass;
    }

    public ObjectName getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(ObjectName xidFactory) {
        this.xidFactory = xidFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        XidFactoryMBean xidFactoryObj = (XidFactoryMBean)this.getServer().getAttribute(this.xidFactory, "Instance");
        Class<?> cls = Class.forName(this.poolFactoryClass);
        this.poolFactory = (ServerSessionPoolFactory)cls.newInstance();
        this.poolFactory.setName(this.name);
        this.poolFactory.setXidFactory(xidFactoryObj);
        this.log.debug((Object)("initialized with pool factory: " + this.poolFactory));
        InitialContext ctx = new InitialContext();
        String name = this.poolFactory.getName();
        String jndiname = "java:/" + name;
        try {
            NonSerializableFactory.rebind((Context)ctx, (String)jndiname, (Object)this.poolFactory);
            this.log.debug((Object)("pool factory " + name + " bound to " + jndiname));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void stopService() {
        InitialContext ctx = null;
        ctx = new InitialContext();
        String name = this.poolFactory.getName();
        String jndiname = "java:/" + name;
        ctx.unbind(jndiname);
        NonSerializableFactory.unbind((String)jndiname);
        this.log.debug((Object)("pool factory " + name + " unbound from " + jndiname));
        Object var5_5 = null;
        if (ctx == null) return;
        try {
            ctx.close();
            return;
        }
        catch (NamingException ignore) {}
        return;
        {
            catch (NamingException namingException) {
                Object var5_6 = null;
                if (ctx == null) return;
                try {
                    ctx.close();
                    return;
                }
                catch (NamingException ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

