/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.asf;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.transaction.TransactionManager;
import org.jboss.jms.asf.StdServerSession;
import org.jboss.logging.Logger;
import org.jboss.tm.XidFactoryMBean;

public class StdServerSessionPool
implements ServerSessionPool {
    private static ThreadGroup threadGroup = new ThreadGroup("ASF Session Pool Threads");
    private final Logger log = Logger.getLogger(this.getClass());
    private int minSize;
    protected int poolSize;
    protected int ack;
    protected boolean useLocalTX;
    protected boolean transacted;
    protected Destination destination;
    protected Connection con;
    protected MessageListener listener;
    protected List sessionPool;
    private PooledExecutor executor;
    private boolean closing = false;
    private boolean forceClear = false;
    private long forceClearInterval = 30000L;
    private int forceClearAttempts = 5;
    protected int numServerSessions = 0;
    protected XidFactoryMBean xidFactory;
    protected TransactionManager tm;

    public StdServerSessionPool(Destination destination, Connection con, boolean transacted, int ack, boolean useLocalTX, MessageListener listener, int minSession, int maxSession, long keepAlive, boolean forceClear, long forceClearInterval, int forceClearAttempts, XidFactoryMBean xidFactory, TransactionManager tm) throws JMSException {
        this.destination = destination;
        this.con = con;
        this.ack = ack;
        this.listener = listener;
        this.transacted = transacted;
        this.minSize = minSession;
        this.poolSize = maxSession;
        this.sessionPool = new ArrayList(maxSession);
        this.forceClear = forceClear;
        this.forceClearInterval = forceClearInterval;
        this.forceClearAttempts = forceClearAttempts;
        this.useLocalTX = useLocalTX;
        this.xidFactory = xidFactory;
        this.tm = tm;
        this.executor = new MyPooledExecutor(this.poolSize);
        this.executor.setMinimumPoolSize(this.minSize);
        this.executor.setKeepAliveTime(keepAlive);
        this.executor.waitWhenBlocked();
        this.executor.setThreadFactory((ThreadFactory)new DefaultThreadFactory());
        this.create();
        this.log.debug((Object)"Server Session pool set up");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerSession getServerSession() throws JMSException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"getting a server session");
        }
        ServerSession session = null;
        try {
            while (true) {
                List list = this.sessionPool;
                synchronized (list) {
                    if (this.closing) {
                        throw new JMSException("Cannot get session after pool has been closed down.");
                    }
                    if (this.sessionPool.size() > 0) {
                        session = (ServerSession)this.sessionPool.remove(0);
                        break;
                    }
                    try {
                        this.sessionPool.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            throw new JMSException("Failed to get a server session: " + e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("using server session: " + session));
        }
        return session;
    }

    public int getNumActiveSessions() {
        return this.numServerSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List list = this.sessionPool;
        synchronized (list) {
            this.closing = true;
            this.log.debug((Object)("Clearing " + this.sessionPool.size() + " from ServerSessionPool"));
            for (StdServerSession ses : this.sessionPool) {
                ses.close();
                --this.numServerSessions;
            }
            this.sessionPool.clear();
            this.sessionPool.notifyAll();
        }
        this.executor.shutdownAfterProcessingCurrentlyQueuedTasks();
        int attempts = 0;
        if (this.forceClear) {
            this.log.info((Object)("Force clear behavior in effect. Waiting for " + this.forceClearInterval + " milliseconds for " + this.forceClearAttempts + " attempts."));
            while (this.numServerSessions > 0 && attempts < this.forceClearAttempts) {
                try {
                    this.sessionPool.wait(this.forceClearInterval);
                    this.log.trace((Object)("Clear attempt " + attempts));
                    ++attempts;
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            List list2 = this.sessionPool;
            synchronized (list2) {
                while (this.numServerSessions > 0) {
                    try {
                        this.sessionPool.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    Executor getExecutor() {
        return this.executor;
    }

    boolean isTransacted() {
        return this.transacted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycle(StdServerSession session) {
        List list = this.sessionPool;
        synchronized (list) {
            if (this.closing) {
                session.close();
                --this.numServerSessions;
                if (this.numServerSessions == 0) {
                    this.sessionPool.notifyAll();
                }
            } else {
                this.sessionPool.add(session);
                this.sessionPool.notifyAll();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("recycled server session: " + session));
                }
            }
        }
    }

    protected void create() throws JMSException {
        for (int index = 0; index < this.poolSize; ++index) {
            TopicSession ses = null;
            XATopicSession xaSes = null;
            this.log.debug((Object)("initializing with connection: " + this.con));
            if (this.destination instanceof Topic && this.con instanceof XATopicConnection) {
                xaSes = ((XATopicConnection)this.con).createXATopicSession();
                ses = xaSes.getTopicSession();
            } else if (this.destination instanceof Queue && this.con instanceof XAQueueConnection) {
                xaSes = ((XAQueueConnection)this.con).createXAQueueSession();
                ses = ((XAQueueSession)xaSes).getQueueSession();
            } else if (this.destination instanceof Topic && this.con instanceof TopicConnection) {
                ses = ((TopicConnection)this.con).createTopicSession(this.transacted, this.ack);
                this.log.warn((Object)"Using a non-XA TopicConnection.  It will not be able to participate in a Global UOW");
            } else if (this.destination instanceof Queue && this.con instanceof QueueConnection) {
                ses = ((QueueConnection)this.con).createQueueSession(this.transacted, this.ack);
                this.log.warn((Object)"Using a non-XA QueueConnection.  It will not be able to participate in a Global UOW");
            } else {
                throw new JMSException("Connection was not reconizable: " + this.con + " for destination " + this.destination);
            }
            StdServerSession serverSession = new StdServerSession(this, (Session)ses, (XASession)xaSes, this.listener, this.useLocalTX, this.xidFactory, this.tm);
            this.sessionPool.add(serverSession);
            ++this.numServerSessions;
            this.log.debug((Object)("added server session to the pool: " + serverSession));
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static int count = 0;

        private DefaultThreadFactory() {
        }

        private static synchronized int nextCount() {
            return count++;
        }

        public Thread newThread(Runnable command) {
            String name = "JMS SessionPool Worker-" + DefaultThreadFactory.nextCount();
            Thread thread = new Thread(threadGroup, command, name);
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class MyPooledExecutor
    extends PooledExecutor {
        public MyPooledExecutor(int poolSize) {
            super(poolSize);
        }

        protected Runnable getTask() throws InterruptedException {
            Runnable task = null;
            while ((task = super.getTask()) == null && this.keepRunning()) {
            }
            return task;
        }

        protected synchronized boolean keepRunning() {
            if (this.shutdown_) {
                return false;
            }
            return this.poolSize_ <= this.minimumPoolSize_;
        }
    }
}

