/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.PoFiller;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.X_AD_FieldGroup;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FieldGroupElementHandler
extends AbstractElementHandler {
    private List<Integer> processedFieldGroups = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        String Object_Status = null;
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Name"));
        String entitytype = atts.getValue("EntityType");
        String name = atts.getValue("Name");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        int id = this.get_IDWithColumn(ctx, "AD_FieldGroup", "Name", name);
        X_AD_FieldGroup fieldGroup = new X_AD_FieldGroup(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_FieldGroup_ID") != null && Integer.parseInt(atts.getValue("AD_FieldGroup_ID")) <= 999999) {
            fieldGroup.setAD_FieldGroup_ID(Integer.parseInt(atts.getValue("AD_FieldGroup_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_FieldGroup", fieldGroup);
            Object_Status = "Update";
            if (this.processedFieldGroups.contains(id)) {
                element.skip = true;
                return;
            }
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        PoFiller pf = new PoFiller(fieldGroup, atts);
        pf.setBoolean("IsActive");
        pf.setString("Name");
        pf.setString("EntityType");
        pf.setString("FieldGroupType");
        pf.setBoolean("IsCollapsedByDefault");
        if (fieldGroup.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, fieldGroup.getName(), "FieldGroup", fieldGroup.get_ID(), AD_Backup_ID, Object_Status, "AD_FieldGroup", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_FieldGroup"));
            element.recordId = fieldGroup.getAD_FieldGroup_ID();
            this.processedFieldGroups.add(fieldGroup.getAD_FieldGroup_ID());
            return;
        }
        this.record_log(ctx, 0, fieldGroup.getName(), "FieldGroup", fieldGroup.get_ID(), AD_Backup_ID, Object_Status, "AD_FieldGroup", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_FieldGroup"));
        throw new POSaveFailedException("Reference");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int fieldGroup_id = Env.getContextAsInt(ctx, "AD_FieldGroup_ID");
        if (this.processedFieldGroups.contains(fieldGroup_id)) {
            return;
        }
        this.processedFieldGroups.add(fieldGroup_id);
        X_AD_FieldGroup fieldGroup = new X_AD_FieldGroup(ctx, fieldGroup_id, null);
        AttributesImpl atts = new AttributesImpl();
        this.createFieldGroupBinding(atts, fieldGroup);
        document.startElement("", "", "fieldgroup", atts);
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        packOut.createTranslations("AD_FieldGroup", fieldGroup.get_ID(), document);
        document.endElement("", "", "fieldgroup");
    }

    private AttributesImpl createFieldGroupBinding(AttributesImpl atts, X_AD_FieldGroup fieldGroup) {
        AttributeFiller filler = new AttributeFiller(atts, fieldGroup);
        if (fieldGroup.getAD_FieldGroup_ID() <= 999999) {
            filler.add("AD_FieldGroup_ID");
        }
        filler.add("IsActive");
        filler.add("Name");
        filler.add("EntityType");
        filler.add("FieldGroupType");
        filler.add("IsCollapsedByDefault");
        return atts;
    }
}

