/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class DBA_PrepareRelease
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        this.deleteNonSystemRecords();
        return "Done";
    }

    private void deleteNonSystemRecords() {
        int maxAllowedError = 5;
        List tables = new Query(this.getCtx(), "AD_Table", null, null).list();
        ArrayList<String> tableCleaned = new ArrayList<String>();
        HashMap<String, Integer> tableFails = new HashMap<String, Integer>();
        boolean changed = false;
        do {
            for (MTable mTable : tables) {
                String tableName = mTable.getTableName();
                if (tableCleaned.contains(tableName)) continue;
                Integer errCount = (Integer)tableFails.get(tableName);
                if (errCount == null) {
                    errCount = 0;
                }
                if (errCount >= 5) continue;
                String[] keyColumns = mTable.getKeyColumns();
                if (keyColumns == null || keyColumns.length == 0) {
                    tableCleaned.add(tableName);
                    tableFails.remove(tableName);
                    this.addLog("Cleanup: " + tableName + " ignored because there is no primary key");
                    continue;
                }
                if (keyColumns.length > 1) {
                    tableCleaned.add(tableName);
                    tableFails.remove(tableName);
                    this.addLog("Cleanup: " + tableName + " ignored because there are more then one key");
                    continue;
                }
                String sql = "DELETE FROM " + tableName + " WHERE " + keyColumns[0] + ">=1000000";
                int no = DB.executeUpdate(sql, null);
                changed = true;
                if (no == -1) {
                    Integer n = errCount;
                    Integer n2 = errCount = Integer.valueOf(errCount + 1);
                    tableFails.put(tableName, errCount);
                    continue;
                }
                tableCleaned.add(tableName);
                tableFails.remove(tableName);
                this.addLog("Cleanup: successful cleaned " + tableName + " (in " + (errCount + 1) + " attempts)");
            }
        } while (changed);
        if (tableFails.isEmpty()) {
            this.addLog("Cleanup: SUCCESS!");
        } else {
            for (Map.Entry entry : tableFails.entrySet()) {
                this.addLog("Cleanup: Failed cleaning " + (String)entry.getKey() + " (" + entry.getValue() + " attempts)");
            }
        }
    }
}

