/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Allocation;
import org.compiere.acct.Doc_AllocationTax;
import org.compiere.acct.Doc_Invoice;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MCashLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_Invoice;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_AllocationHdr
extends Doc {
    private static final BigDecimal TOLERANCE = new BigDecimal(0.02);
    private ArrayList<Fact> m_facts = null;

    public Doc_AllocationHdr(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MAllocationHdr.class, rs, "CMA", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MAllocationHdr alloc = (MAllocationHdr)this.getPO();
        this.setDateDoc(alloc.getDateTrx());
        this.p_lines = this.loadLines(alloc);
        return null;
    }

    private DocLine[] loadLines(MAllocationHdr alloc) {
        ArrayList<DocLine_Allocation> list = new ArrayList<DocLine_Allocation>();
        MAllocationLine[] lines = alloc.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MAllocationLine line = lines[i];
            DocLine_Allocation docLine = new DocLine_Allocation(line, (Doc)this);
            if (line.getC_Payment_ID() != 0) {
                MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                int C_ConversionType_ID = payment.getC_ConversionType_ID();
                docLine.setC_ConversionType_ID(C_ConversionType_ID);
            }
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        this.m_facts = new ArrayList();
        Fact fact = new Fact(this, as, "A");
        Fact factForRGL = new Fact(this, as, "A");
        boolean isInterOrg = this.isInterOrg(as);
        for (int i = 0; i < this.p_lines.length; ++i) {
            X_C_Invoice invoice;
            MAccount bpAcct;
            BigDecimal allocationAccounted;
            BigDecimal allocationSource;
            DocLine_Allocation line;
            block49: {
                MPayment payment;
                FactLine flForRGL;
                FactLine fl;
                BigDecimal allocationAccountedForRGL;
                BigDecimal allocationSourceForRGL;
                block50: {
                    block48: {
                        line = (DocLine_Allocation)this.p_lines[i];
                        this.setC_BPartner_ID(line.getC_BPartner_ID());
                        if (line.getC_Payment_ID() != 0 && line.getC_Invoice_ID() == 0 && line.getC_Order_ID() == 0 && line.getC_CashLine_ID() == 0 && line.getC_BPartner_ID() == 0 && Env.ZERO.compareTo(line.getDiscountAmt()) == 0 && Env.ZERO.compareTo(line.getWriteOffAmt()) == 0) continue;
                        allocationSourceForRGL = allocationSource = line.getAmtSource().add(line.getDiscountAmt()).add(line.getWriteOffAmt());
                        allocationAccounted = Env.ZERO;
                        allocationAccountedForRGL = Env.ZERO;
                        fl = null;
                        flForRGL = null;
                        bpAcct = null;
                        payment = null;
                        if (line.getC_Payment_ID() != 0) {
                            payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                        }
                        invoice = null;
                        if (line.getC_Invoice_ID() != 0) {
                            invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                        }
                        if (invoice != null) break block48;
                        if (line.getC_Invoice_ID() == 0 && line.getC_Payment_ID() != 0) {
                            fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                            if (fl != null && payment != null) {
                                fl.setAD_Org_ID(payment.getAD_Org_ID());
                            }
                            break block49;
                        } else {
                            this.p_Error = "Cannot determine SO/PO";
                            this.log.log(Level.SEVERE, this.p_Error);
                            return null;
                        }
                    }
                    if (!invoice.isSOTrx()) break block50;
                    MAccount acct_unallocated_cash = null;
                    if (line.getC_Payment_ID() != 0) {
                        acct_unallocated_cash = this.getPaymentAcct(as, line.getC_Payment_ID());
                    } else if (line.getC_CashLine_ID() != 0) {
                        acct_unallocated_cash = this.getCashAcct(as, line.getC_CashLine_ID());
                    }
                    MAccount acct_receivable = this.getAccount(1, as);
                    if (!as.isPostIfClearingEqual() && acct_unallocated_cash != null && acct_unallocated_cash.equals(acct_receivable) && !isInterOrg) {
                        allocationSource = line.getDiscountAmt().add(line.getWriteOffAmt());
                    } else if (line.getC_Payment_ID() != 0) {
                        fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                        if (fl != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                    } else if (line.getC_CashLine_ID() != 0) {
                        fl = fact.createLine((DocLine)line, this.getCashAcct(as, line.getC_CashLine_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                        MCashLine cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                        if (fl != null && cashLine.get_ID() != 0) {
                            fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                        }
                    }
                    if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(30, as), this.getC_Currency_ID(), line.getDiscountAmt(), null)) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), line.getWriteOffAmt(), null)) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (as.isAccrual()) {
                        bpAcct = this.getAccount(1, as);
                        fl = fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), null, allocationSource);
                        if (fl != null) {
                            allocationAccounted = fl.getAcctBalance().negate();
                        }
                        if (fl != null && invoice != null) {
                            fl.setAD_Org_ID(invoice.getAD_Org_ID());
                        }
                        if ((flForRGL = factForRGL.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), null, allocationSourceForRGL)) != null) {
                            allocationAccountedForRGL = flForRGL.getAcctBalance().negate();
                        }
                        break block49;
                    } else {
                        allocationAccountedForRGL = allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                    }
                    break block49;
                }
                MAccount acct_payment_select = null;
                if (line.getC_Payment_ID() != 0) {
                    acct_payment_select = this.getPaymentAcct(as, line.getC_Payment_ID());
                } else if (line.getC_CashLine_ID() != 0) {
                    acct_payment_select = this.getCashAcct(as, line.getC_CashLine_ID());
                }
                MAccount acct_liability = this.getAccount(2, as);
                boolean isUsingClearing = true;
                allocationSourceForRGL = allocationSourceForRGL.negate();
                if (!as.isPostIfClearingEqual() && acct_payment_select != null && acct_payment_select.equals(acct_liability) && !isInterOrg) {
                    allocationSource = line.getDiscountAmt().add(line.getWriteOffAmt());
                    isUsingClearing = false;
                }
                allocationSource = allocationSource.negate();
                if (as.isAccrual()) {
                    bpAcct = this.getAccount(2, as);
                    fl = fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), allocationSource, null);
                    if (fl != null) {
                        allocationAccounted = fl.getAcctBalance();
                    }
                    if (fl != null && invoice != null) {
                        fl.setAD_Org_ID(invoice.getAD_Org_ID());
                    }
                    if ((flForRGL = factForRGL.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), allocationSourceForRGL, null)) != null) {
                        allocationAccountedForRGL = flForRGL.getAcctBalance();
                    }
                } else {
                    allocationAccountedForRGL = allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                }
                if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(31, as), this.getC_Currency_ID(), null, line.getDiscountAmt().negate())) != null && payment != null) {
                    fl.setAD_Org_ID(payment.getAD_Org_ID());
                }
                if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), null, line.getWriteOffAmt().negate())) != null && payment != null) {
                    fl.setAD_Org_ID(payment.getAD_Org_ID());
                }
                if (isUsingClearing && line.getC_Payment_ID() != 0) {
                    fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), null, line.getAmtSource().negate());
                    if (fl != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                } else if (isUsingClearing && line.getC_CashLine_ID() != 0) {
                    fl = fact.createLine((DocLine)line, this.getCashAcct(as, line.getC_CashLine_ID()), this.getC_Currency_ID(), null, line.getAmtSource().negate());
                    MCashLine cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                    if (fl != null && cashLine.get_ID() != 0) {
                        fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                    }
                }
            }
            if (invoice != null && as.isTaxCorrection()) {
                BigDecimal taxCorrectionAmt = Env.ZERO;
                if (as.isTaxCorrectionDiscount()) {
                    taxCorrectionAmt = line.getDiscountAmt();
                }
                if (as.isTaxCorrectionWriteOff()) {
                    taxCorrectionAmt = taxCorrectionAmt.add(line.getWriteOffAmt());
                }
                if (taxCorrectionAmt.signum() != 0 && !this.createTaxCorrection(as, fact, line, this.getAccount(invoice.isSOTrx() ? 30 : 31, as), this.getAccount(32, as), invoice.isSOTrx())) {
                    this.p_Error = "Cannot create Tax correction";
                    return null;
                }
            }
            if (invoice == null || this.getC_Currency_ID() == as.getC_Currency_ID() && this.getC_Currency_ID() == line.getInvoiceC_Currency_ID()) continue;
            this.p_Error = this.createRealizedGainLoss(line, as, fact, bpAcct, (MInvoice)invoice, allocationSource, allocationAccounted);
            if (this.p_Error == null) continue;
            return null;
        }
        if (!as.isPostIfClearingEqual() && this.p_lines.length > 0 && !isInterOrg) {
            boolean allEquals = true;
            FactLine[] factlines = fact.getLines();
            BigDecimal netBalance = Env.ZERO;
            FactLine prevFactLine = null;
            for (FactLine factLine : factlines) {
                netBalance = netBalance.add(factLine.getAmtSourceDr()).subtract(factLine.getAmtSourceCr());
                if (prevFactLine != null && !this.equalFactLineIDs(prevFactLine, factLine)) {
                    allEquals = false;
                    break;
                }
                prevFactLine = factLine;
            }
            if (netBalance.compareTo(Env.ZERO) == 0 && allEquals) {
                for (FactLine factline : factlines) {
                    fact.remove(factline);
                }
            }
        }
        this.setC_BPartner_ID(0);
        this.m_facts.add(fact);
        return this.m_facts;
    }

    private boolean isInterOrg(MAcctSchema as) {
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            return false;
        }
        if (this.p_lines.length <= 0) {
            return false;
        }
        int startorg = this.p_lines[0].getAD_Org_ID();
        for (int i = 0; i < this.p_lines.length; ++i) {
            DocLine_Allocation line = (DocLine_Allocation)this.p_lines[i];
            int orgpayment = startorg;
            MPayment payment = null;
            if (line.getC_Payment_ID() != 0) {
                payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                orgpayment = payment.getAD_Org_ID();
            }
            int orginvoice = startorg;
            MInvoice invoice = null;
            if (line.getC_Invoice_ID() != 0) {
                invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                orginvoice = invoice.getAD_Org_ID();
            }
            int orgcashline = startorg;
            MCashLine cashline = null;
            if (line.getC_CashLine_ID() != 0) {
                cashline = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                orgcashline = cashline.getAD_Org_ID();
            }
            int orgorder = startorg;
            MOrder order = null;
            if (line.getC_Order_ID() != 0) {
                order = new MOrder(this.getCtx(), line.getC_Order_ID(), this.getTrxName());
                orgorder = order.getAD_Org_ID();
            }
            if (line.getAD_Org_ID() == startorg && orgpayment == startorg && orginvoice == startorg && orgcashline == startorg && orgorder == startorg) continue;
            return true;
        }
        return false;
    }

    private boolean equalFactLineIDs(FactLine prevFactLine, FactLine factLine) {
        return factLine.getA_Asset_ID() == prevFactLine.getA_Asset_ID() && factLine.getAccount_ID() == prevFactLine.getAccount_ID() && factLine.getAD_Client_ID() == prevFactLine.getAD_Client_ID() && factLine.getAD_Org_ID() == prevFactLine.getAD_Org_ID() && factLine.getAD_OrgTrx_ID() == prevFactLine.getAD_OrgTrx_ID() && factLine.getC_AcctSchema_ID() == prevFactLine.getC_AcctSchema_ID() && factLine.getC_Activity_ID() == prevFactLine.getC_Activity_ID() && factLine.getC_BPartner_ID() == prevFactLine.getC_BPartner_ID() && factLine.getC_Campaign_ID() == prevFactLine.getC_Campaign_ID() && factLine.getC_Currency_ID() == prevFactLine.getC_Currency_ID() && factLine.getC_LocFrom_ID() == prevFactLine.getC_LocFrom_ID() && factLine.getC_LocTo_ID() == prevFactLine.getC_LocTo_ID() && factLine.getC_Period_ID() == prevFactLine.getC_Period_ID() && factLine.getC_Project_ID() == prevFactLine.getC_Project_ID() && factLine.getC_ProjectPhase_ID() == prevFactLine.getC_ProjectPhase_ID() && factLine.getC_ProjectTask_ID() == prevFactLine.getC_ProjectTask_ID() && factLine.getC_SalesRegion_ID() == prevFactLine.getC_SalesRegion_ID() && factLine.getC_SubAcct_ID() == prevFactLine.getC_SubAcct_ID() && factLine.getC_Tax_ID() == prevFactLine.getC_Tax_ID() && factLine.getC_UOM_ID() == prevFactLine.getC_UOM_ID() && factLine.getGL_Budget_ID() == prevFactLine.getGL_Budget_ID() && factLine.getGL_Category_ID() == prevFactLine.getGL_Category_ID() && factLine.getM_Locator_ID() == prevFactLine.getM_Locator_ID() && factLine.getM_Product_ID() == prevFactLine.getM_Product_ID() && factLine.getUserElement1_ID() == prevFactLine.getUserElement1_ID() && factLine.getUserElement2_ID() == prevFactLine.getUserElement2_ID() && factLine.getUser1_ID() == prevFactLine.getUser1_ID() && factLine.getUser2_ID() == prevFactLine.getUser2_ID();
    }

    private BigDecimal createCashBasedAcct(MAcctSchema as, Fact fact, MInvoice invoice, BigDecimal allocationSource) {
        BigDecimal allocationAccounted = Env.ZERO;
        double percent = invoice.getGrandTotal().doubleValue() / allocationSource.doubleValue();
        if (percent > 0.99 && percent < 1.01) {
            percent = 1.0;
        }
        this.log.config("Multiplier=" + percent + " - GrandTotal=" + invoice.getGrandTotal() + " - Allocation Source=" + allocationSource);
        Doc_Invoice docInvoice = (Doc_Invoice)Doc.get(new MAcctSchema[]{as}, MInvoice.Table_ID, invoice.getC_Invoice_ID(), this.getTrxName());
        docInvoice.loadDocumentDetails();
        allocationAccounted = docInvoice.createFactCash(as, fact, new BigDecimal(percent));
        this.log.config("Allocation Accounted=" + allocationAccounted);
        if (as.isCreatePOCommitment() && !invoice.isSOTrx()) {
            MInvoiceLine[] lines = invoice.getLines();
            for (int i = 0; i < lines.length; ++i) {
                Fact factC = Doc_Order.getCommitmentRelease(as, this, lines[i].getQtyInvoiced(), lines[i].getC_InvoiceLine_ID(), new BigDecimal(percent));
                if (factC == null) {
                    return null;
                }
                this.m_facts.add(factC);
            }
        }
        return allocationAccounted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MAccount getPaymentAcct(MAcctSchema as, int C_Payment_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        int accountType;
        block6: {
            this.setC_BankAccount_ID(0);
            accountType = 10;
            String sql = "SELECT p.C_BankAccount_ID, d.DocBaseType, p.IsReceipt, p.IsPrepayment FROM C_Payment p INNER JOIN C_DocType d ON (p.C_DocType_ID=d.C_DocType_ID) WHERE C_Payment_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.getTrxName());
                pstmt.setInt(1, C_Payment_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                this.setC_BankAccount_ID(rs.getInt(1));
                if ("APP".equals(rs.getString(2))) {
                    accountType = 12;
                }
                if (!"Y".equals(rs.getString(4))) break block6;
                accountType = "Y".equals(rs.getString(3)) ? 13 : 14;
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (this.getC_BankAccount_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_Payment_ID=" + C_Payment_ID);
            return null;
        }
        return this.getAccount(accountType, as);
    }

    private MAccount getCashAcct(MAcctSchema as, int C_CashLine_ID) {
        String sql = "SELECT c.C_CashBook_ID FROM C_Cash c, C_CashLine cl WHERE c.C_Cash_ID=cl.C_Cash_ID AND cl.C_CashLine_ID=?";
        this.setC_CashBook_ID(DB.getSQLValue(null, sql, C_CashLine_ID));
        if (this.getC_CashBook_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_CashLine_ID=" + C_CashLine_ID);
            return null;
        }
        return this.getAccount(21, as);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createRealizedGainLoss(DocLine line, MAcctSchema as, Fact fact, MAccount acct, MInvoice invoice, BigDecimal allocationSource, BigDecimal allocationAccounted) {
        String d2;
        BigDecimal invoiceSource = null;
        BigDecimal invoiceAccounted = null;
        String sql = "SELECT " + (invoice.isSOTrx() ? "SUM(AmtSourceDr), SUM(AmtAcctDr)" : "SUM(AmtSourceCr), SUM(AmtAcctCr)") + " FROM Fact_Acct " + "WHERE AD_Table_ID=318 AND Record_ID=?" + " AND C_AcctSchema_ID=?" + " AND PostingType='A'";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, invoice.getC_Invoice_ID());
            pstmt.setInt(2, as.getC_AcctSchema_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                invoiceSource = rs.getBigDecimal(1);
                invoiceAccounted = rs.getBigDecimal(2);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (invoiceSource == null || invoiceAccounted == null) {
            return "Gain/Loss - Invoice not posted yet";
        }
        String description = "Invoice=(" + invoice.getC_Currency_ID() + ")" + invoiceSource + "/" + invoiceAccounted + " - Allocation=(" + this.getC_Currency_ID() + ")" + allocationSource + "/" + allocationAccounted;
        this.log.fine(description);
        if (this.getC_Currency_ID() != invoice.getC_Currency_ID()) {
            BigDecimal allocationSourceNew = MConversionRate.convert(this.getCtx(), allocationSource, this.getC_Currency_ID(), invoice.getC_Currency_ID(), this.getDateAcct(), invoice.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
            if (allocationSourceNew == null) {
                return "Gain/Loss - No Conversion from Allocation->Invoice";
            }
            d2 = "Allocation=(" + this.getC_Currency_ID() + ")" + allocationSource + "->(" + invoice.getC_Currency_ID() + ")" + allocationSourceNew;
            this.log.fine(d2);
            description = description + " - " + d2;
            allocationSource = allocationSourceNew;
        }
        BigDecimal acctDifference = null;
        if (allocationSource.compareTo(invoiceSource) == 0) {
            acctDifference = invoiceAccounted.subtract(allocationAccounted);
            d2 = "(full) = " + acctDifference;
            this.log.fine(d2);
            description = description + " - " + d2;
        } else {
            double multiplier = allocationSource.doubleValue() / invoiceSource.doubleValue();
            acctDifference = (invoiceAccounted = invoiceAccounted.multiply(new BigDecimal(multiplier))).subtract(allocationAccounted);
            if (acctDifference.abs().compareTo(TOLERANCE) < 0) {
                acctDifference = Env.ZERO;
            }
            int precision = as.getStdPrecision();
            if (acctDifference.scale() > precision) {
                acctDifference = acctDifference.setScale(precision, 4);
            }
            String d22 = "(partial) = " + acctDifference + " - Multiplier=" + multiplier;
            this.log.fine(d22);
            description = description + " - " + d22;
        }
        if (acctDifference.signum() == 0) {
            this.log.fine("No Difference");
            return null;
        }
        MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
        if (invoice.isSOTrx()) {
            FactLine fl = fact.createLine(line, loss, gain, as.getC_Currency_ID(), acctDifference);
            fl.setDescription(description);
            fact.createLine(line, acct, as.getC_Currency_ID(), acctDifference.negate());
            fl.setDescription(description);
        } else {
            fact.createLine(line, acct, as.getC_Currency_ID(), acctDifference);
            FactLine fl = fact.createLine(line, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTaxCorrection(MAcctSchema as, Fact fact, DocLine_Allocation line, MAccount DiscountAccount, MAccount WriteOffAccoint, boolean isSOTrx) {
        this.log.info(line.toString());
        BigDecimal discount = Env.ZERO;
        if (as.isTaxCorrectionDiscount()) {
            discount = line.getDiscountAmt();
        }
        BigDecimal writeOff = Env.ZERO;
        if (as.isTaxCorrectionWriteOff()) {
            writeOff = line.getWriteOffAmt();
        }
        Doc_AllocationTax tax = new Doc_AllocationTax(DiscountAccount, discount, WriteOffAccoint, writeOff, isSOTrx);
        String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=318 AND Record_ID=? AND C_AcctSchema_ID=? AND Line_ID IS NULL";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, line.getC_Invoice_ID());
            pstmt.setInt(2, as.getC_AcctSchema_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                tax.addInvoiceFact(new MFactAcct(this.getCtx(), rs, fact.get_TrxName()));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (tax.getLineCount() == 0) {
            this.log.warning("Invoice not posted yet - " + line);
            return false;
        }
        if (tax.getLineCount() < 2) {
            return true;
        }
        return tax.createEntries(as, fact, line);
    }
}

