/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_InOut
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";

    public Doc_InOut(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MInOut.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MInOut inout = (MInOut)this.getPO();
        this.setDateDoc(inout.getMovementDate());
        this.m_Reversal_ID = inout.getReversal_ID();
        this.m_DocStatus = inout.getDocStatus();
        this.p_lines = this.loadLines(inout);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MInOut inout) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInOutLine[] lines = inout.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MInOutLine line = lines[i];
            if (line.isDescription() || line.getM_Product_ID() == 0 || line.getMovementQty().signum() == 0) {
                this.log.finer("Ignored: " + line);
                continue;
            }
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getMovementQty();
            docLine.setReversalLine_ID(line.getReversalLine_ID());
            docLine.setQty(Qty, this.getDocumentType().equals("MMS"));
            String sql = "SELECT PP_Cost_Collector_ID  FROM C_OrderLine WHERE C_OrderLine_ID=? AND PP_Cost_Collector_ID IS NOT NULL";
            int PP_Cost_Collector_ID = DB.getSQLValueEx(this.getTrxName(), sql, line.getC_OrderLine_ID());
            docLine.setPP_Cost_Collector_ID(PP_Cost_Collector_ID);
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine dr = null;
        FactLine cr = null;
        if (this.getDocumentType().equals("MMS") && this.isSOTrx()) {
            DocLine line;
            int i;
            for (i = 0; i < this.p_lines.length; ++i) {
                line = this.p_lines[i];
                BigDecimal costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                if (costs == null || costs.signum() == 0) {
                    MProduct product = line.getProduct();
                    if (!product.isStocked()) continue;
                    this.p_Error = "No Costs for " + line.getProduct().getName();
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                dr = fact.createLine(line, line.getAccount(4, as), as.getC_Currency_ID(), costs, null);
                if (dr == null) {
                    this.p_Error = "FactLine DR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                dr.setAD_Org_ID(line.getOrder_Org_ID());
                dr.setQty(line.getQty().negate());
                if (this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !dr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                    this.p_Error = "Original Shipment/Receipt not posted yet";
                    return null;
                }
                cr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), null, costs);
                if (cr == null) {
                    this.p_Error = "FactLine CR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                cr.setM_Locator_ID(line.getM_Locator_ID());
                cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                if (this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0) {
                    if (!cr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                        this.p_Error = "Original Shipment/Receipt not posted yet";
                        return null;
                    }
                    costs = cr.getAcctBalance();
                }
                if (line.getM_Product_ID() == 0) continue;
                MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), line.getDescription(), true, this.getTrxName());
            }
            this.updateProductInfo(as.getC_AcctSchema_ID());
            if (as.isAccrual() && as.isCreateSOCommitment()) {
                for (i = 0; i < this.p_lines.length; ++i) {
                    line = this.p_lines[i];
                    Fact factcomm = Doc_Order.getCommitmentSalesRelease(as, this, line.getQty(), line.get_ID(), Env.ONE);
                    if (factcomm == null) continue;
                    facts.add(factcomm);
                }
            }
        } else if (this.getDocumentType().equals("MMR") && this.isSOTrx()) {
            for (int i = 0; i < this.p_lines.length; ++i) {
                DocLine line = this.p_lines[i];
                BigDecimal costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                if (costs == null || costs.signum() == 0) {
                    MProduct product = line.getProduct();
                    if (!product.isStocked()) continue;
                    this.p_Error = "No Costs for " + line.getProduct().getName();
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs, null);
                if (dr == null) {
                    this.p_Error = "FactLine DR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                if (this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0) {
                    if (!dr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                        this.p_Error = "Original Shipment/Receipt not posted yet";
                        return null;
                    }
                    costs = dr.getAcctBalance();
                }
                if (line.getM_Product_ID() != 0) {
                    MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), line.getDescription(), true, this.getTrxName());
                }
                if ((cr = fact.createLine(line, line.getAccount(4, as), as.getC_Currency_ID(), null, costs)) == null) {
                    this.p_Error = "FactLine CR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                cr.setM_Locator_ID(line.getM_Locator_ID());
                cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                cr.setAD_Org_ID(line.getOrder_Org_ID());
                cr.setQty(line.getQty().negate());
                if (!this.m_DocStatus.equals("RE") || this.m_Reversal_ID == 0 || line.getReversalLine_ID() == 0 || cr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) continue;
                this.p_Error = "Original Shipment/Receipt not posted yet";
                return null;
            }
            this.updateProductInfo(as.getC_AcctSchema_ID());
        } else if (this.getDocumentType().equals("MMR") && !this.isSOTrx()) {
            for (int i = 0; i < this.p_lines.length; ++i) {
                int C_Currency_ID = as.getC_Currency_ID();
                DocLine line = this.p_lines[i];
                BigDecimal costs = null;
                MProduct product = line.getProduct();
                String costingMethod = product.getCostingMethod(as);
                if ("A".equals(costingMethod) || "p".equals(costingMethod)) {
                    int C_OrderLine_ID = line.getC_OrderLine_ID();
                    if (C_OrderLine_ID > 0) {
                        MOrderLine orderLine = new MOrderLine(this.getCtx(), C_OrderLine_ID, this.getTrxName());
                        C_Currency_ID = orderLine.getC_Currency_ID();
                        costs = orderLine.getPriceCost();
                        if (costs == null || costs.signum() == 0) {
                            MTax tax;
                            costs = orderLine.getPriceActual();
                            int C_Tax_ID = orderLine.getC_Tax_ID();
                            if (orderLine.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get(this.getCtx(), C_Tax_ID)).isZeroTax()) {
                                int stdPrecision = MCurrency.getStdPrecision(this.getCtx(), C_Currency_ID);
                                BigDecimal costTax = tax.calculateTax(costs, true, stdPrecision);
                                this.log.fine("Costs=" + costs + " - Tax=" + costTax);
                                costs = costs.subtract(costTax);
                            }
                        }
                        costs = costs.multiply(line.getQty());
                    } else {
                        costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
                    }
                } else {
                    costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
                }
                if (costs == null || costs.signum() == 0) {
                    this.p_Error = "Resubmit - No Costs for " + product.getName();
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                MAccount assets = line.getAccount(3, as);
                if (product.isService()) {
                    assets = line.getPP_Cost_Collector_ID() > 0 ? line.getAccount(11, as) : line.getAccount(2, as);
                }
                if ((dr = fact.createLine(line, assets, C_Currency_ID, costs, null)) == null) {
                    this.p_Error = "DR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                dr.setLocationFromLocator(line.getM_Locator_ID(), false);
                if (this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !dr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                    this.p_Error = "Original Receipt not posted yet";
                    return null;
                }
                cr = fact.createLine(line, this.getAccount(51, as), C_Currency_ID, null, costs);
                if (cr == null) {
                    this.p_Error = "CR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                cr.setM_Locator_ID(line.getM_Locator_ID());
                cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                cr.setQty(line.getQty().negate());
                if (!this.m_DocStatus.equals("RE") || this.m_Reversal_ID == 0 || line.getReversalLine_ID() == 0 || cr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) continue;
                this.p_Error = "Original Receipt not posted yet";
                return null;
            }
        } else if (this.getDocumentType().equals("MMS") && !this.isSOTrx()) {
            for (int i = 0; i < this.p_lines.length; ++i) {
                int C_Currency_ID = as.getC_Currency_ID();
                DocLine line = this.p_lines[i];
                BigDecimal costs = null;
                MProduct product = line.getProduct();
                costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
                if (costs == null || costs.signum() == 0) {
                    this.p_Error = "Resubmit - No Costs for " + product.getName();
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                dr = fact.createLine(line, this.getAccount(51, as), C_Currency_ID, costs, null);
                if (dr == null) {
                    this.p_Error = "CR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                dr.setLocationFromLocator(line.getM_Locator_ID(), false);
                dr.setQty(line.getQty().negate());
                if (this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !dr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                    this.p_Error = "Original Receipt not posted yet";
                    return null;
                }
                MAccount assets = line.getAccount(3, as);
                if (product.isService()) {
                    assets = line.getAccount(2, as);
                }
                if ((cr = fact.createLine(line, assets, C_Currency_ID, null, costs)) == null) {
                    this.p_Error = "DR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                cr.setM_Locator_ID(line.getM_Locator_ID());
                cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                if (!this.m_DocStatus.equals("RE") || this.m_Reversal_ID == 0 || line.getReversalLine_ID() == 0 || cr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) continue;
                this.p_Error = "Original Receipt not posted yet";
                return null;
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            return null;
        }
        facts.add(fact);
        return facts;
    }

    private void updateProductInfo(int C_AcctSchema_ID) {
        this.log.fine("M_InOut_ID=" + this.get_ID());
        StringBuffer sql = new StringBuffer("UPDATE M_Product_Costing pc SET (CostAverageCumQty, CostAverageCumAmt)=(SELECT pc.CostAverageCumQty - SUM(il.MovementQty), pc.CostAverageCumAmt - SUM(il.MovementQty*pc.CurrentCostPrice) FROM M_InOutLine il WHERE pc.M_Product_ID=il.M_Product_ID AND il.M_InOut_ID=").append(this.get_ID()).append(") ").append("WHERE EXISTS (SELECT * FROM M_InOutLine il WHERE pc.M_Product_ID=il.M_Product_ID AND il.M_InOut_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        this.log.fine("M_Product_Costing - Updated=" + no);
    }
}

