/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.VTable;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.MChangeLog;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextArea;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;

public class RecordInfo
extends CDialog {
    private static final long serialVersionUID = 8984246906639442417L;
    private CPanel mainPanel = new CPanel(new BorderLayout(0, 0));
    private CPanel northPanel = new CPanel();
    private CScrollPane scrollPane = new CScrollPane();
    private VTable table = new VTable();
    private ConfirmPanel confirmPanel = new ConfirmPanel(false);
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private Vector<Vector<String>> m_data = new Vector();
    private StringBuffer m_info = new StringBuffer();
    private SimpleDateFormat m_dateTimeFormat = DisplayType.getDateFormat(16, Env.getLanguage(Env.getCtx()));
    private SimpleDateFormat m_dateFormat = DisplayType.getDateFormat(16, Env.getLanguage(Env.getCtx()));
    private DecimalFormat m_numberFormat = DisplayType.getNumberFormat(22, Env.getLanguage(Env.getCtx()));
    private DecimalFormat m_amtFormat = DisplayType.getNumberFormat(12, Env.getLanguage(Env.getCtx()));
    private DecimalFormat m_intFormat = DisplayType.getNumberFormat(11, Env.getLanguage(Env.getCtx()));

    public RecordInfo(Frame owner, String title, DataStatusEvent dse) {
        super(owner, title, true);
        try {
            this.jbInit(this.dynInit(dse, title));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        AEnv.positionCenterWindow(owner, this);
    }

    private void jbInit(boolean showTable) throws Exception {
        this.getContentPane().add(this.mainPanel);
        CTextArea info = new CTextArea(this.m_info.toString());
        info.setReadWrite(false);
        info.setOpaque(false);
        info.setForeground(Color.blue);
        info.setBorder(null);
        if (showTable) {
            this.mainPanel.add((Component)info, "North");
            this.mainPanel.add((Component)this.scrollPane, "Center");
            this.scrollPane.getViewport().add(this.table);
            this.scrollPane.setPreferredSize(new Dimension(500, 100));
        } else {
            info.setPreferredSize(new Dimension(400, 75));
            this.mainPanel.add((Component)info, "Center");
        }
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
    }

    private boolean dynInit(DataStatusEvent dse, String title) {
        if (dse.CreatedBy == null) {
            return false;
        }
        MUser user = MUser.get(Env.getCtx(), dse.CreatedBy);
        this.m_info.append(" ").append(Msg.translate(Env.getCtx(), "CreatedBy")).append(": ").append(user.getName()).append(" - ").append(this.m_dateTimeFormat.format(dse.Created)).append("\n");
        if (!dse.Created.equals(dse.Updated) || !dse.CreatedBy.equals(dse.UpdatedBy)) {
            if (!dse.CreatedBy.equals(dse.UpdatedBy)) {
                user = MUser.get(Env.getCtx(), dse.UpdatedBy);
            }
            this.m_info.append(" ").append(Msg.translate(Env.getCtx(), "UpdatedBy")).append(": ").append(user.getName()).append(" - ").append(this.m_dateTimeFormat.format(dse.Updated)).append("\n");
        }
        if (dse.Info != null && dse.Info.length() > 0) {
            this.m_info.append("\n (").append(dse.Info).append(")");
        }
        if (dse.AD_Table_ID != 0) {
            MTable table1 = MTable.get(Env.getCtx(), dse.AD_Table_ID);
            this.setTitle(title + " - " + table1.getName());
        }
        if (!"C".equals(MRole.getDefault().getPreferenceType())) {
            return false;
        }
        int Record_ID = 0;
        if (dse.Record_ID instanceof Integer) {
            Record_ID = (Integer)dse.Record_ID;
        } else {
            this.log.info("dynInit - Invalid Record_ID=" + dse.Record_ID);
        }
        if (Record_ID == 0) {
            return false;
        }
        String sql = "SELECT AD_Column_ID, Updated, UpdatedBy, OldValue, NewValue FROM AD_ChangeLog WHERE AD_Table_ID=? AND Record_ID=? ORDER BY Updated DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, dse.AD_Table_ID);
            pstmt.setInt(2, Record_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.addLine(rs.getInt(1), rs.getTimestamp(2), rs.getInt(3), rs.getString(4), rs.getString(5));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate(Env.getCtx(), "Name"));
        columnNames.add(Msg.translate(Env.getCtx(), "NewValue"));
        columnNames.add(Msg.translate(Env.getCtx(), "OldValue"));
        columnNames.add(Msg.translate(Env.getCtx(), "UpdatedBy"));
        columnNames.add(Msg.translate(Env.getCtx(), "Updated"));
        columnNames.add(Msg.translate(Env.getCtx(), "AD_Column_ID"));
        DefaultTableModel model = new DefaultTableModel(this.m_data, columnNames);
        this.table.setModel(model);
        this.table.autoSize(false);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addLine(int AD_Column_ID, Timestamp Updated, int UpdatedBy, String OldValue, String NewValue) {
        String showNewValue;
        String showOldValue;
        MColumn column;
        Vector<String> line;
        block26: {
            line = new Vector<String>();
            column = MColumn.get(Env.getCtx(), AD_Column_ID);
            line.add(Msg.translate(Env.getCtx(), column.getColumnName()));
            if (OldValue != null && OldValue.equals(MChangeLog.NULL)) {
                OldValue = null;
            }
            showOldValue = OldValue;
            if (NewValue != null && NewValue.equals(MChangeLog.NULL)) {
                NewValue = null;
            }
            showNewValue = NewValue;
            try {
                if (DisplayType.isText(column.getAD_Reference_ID())) break block26;
                if (column.getAD_Reference_ID() == 20) {
                    boolean yes;
                    if (OldValue != null) {
                        yes = OldValue.equals("true") || OldValue.equals("Y");
                        showOldValue = Msg.getMsg(Env.getCtx(), yes ? "Y" : "N");
                    }
                    if (NewValue != null) {
                        yes = NewValue.equals("true") || NewValue.equals("Y");
                        showNewValue = Msg.getMsg(Env.getCtx(), yes ? "Y" : "N");
                    }
                    break block26;
                }
                if (column.getAD_Reference_ID() == 12) {
                    if (OldValue != null) {
                        showOldValue = this.m_amtFormat.format(new BigDecimal(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_amtFormat.format(new BigDecimal(NewValue));
                    }
                    break block26;
                }
                if (column.getAD_Reference_ID() == 11) {
                    if (OldValue != null) {
                        showOldValue = this.m_intFormat.format(new Integer(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_intFormat.format(new Integer(NewValue));
                    }
                    break block26;
                }
                if (DisplayType.isNumeric(column.getAD_Reference_ID())) {
                    if (OldValue != null) {
                        showOldValue = this.m_numberFormat.format(new BigDecimal(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_numberFormat.format(new BigDecimal(NewValue));
                    }
                    break block26;
                }
                if (column.getAD_Reference_ID() == 15) {
                    if (OldValue != null) {
                        showOldValue = this.m_dateFormat.format(Timestamp.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_dateFormat.format(Timestamp.valueOf(NewValue));
                    }
                    break block26;
                }
                if (column.getAD_Reference_ID() == 16) {
                    if (OldValue != null) {
                        showOldValue = this.m_dateTimeFormat.format(Timestamp.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_dateTimeFormat.format(Timestamp.valueOf(NewValue));
                    }
                    break block26;
                }
                if (DisplayType.isLookup(column.getAD_Reference_ID())) {
                    String key;
                    NamePair pp;
                    MLookup lookup = MLookupFactory.get(Env.getCtx(), 0, AD_Column_ID, column.getAD_Reference_ID(), Env.getLanguage(Env.getCtx()), column.getColumnName(), column.getAD_Reference_Value_ID(), column.isParent(), null);
                    if (OldValue != null && (pp = lookup.get(key = OldValue)) != null) {
                        showOldValue = pp.getName();
                    }
                    if (NewValue != null && (pp = lookup.get(key = NewValue)) != null) {
                        showNewValue = pp.getName();
                    }
                    break block26;
                }
                if (!DisplayType.isLOB(column.getAD_Reference_ID())) {
                    // empty if block
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, OldValue + "->" + NewValue, e);
            }
        }
        line.add(showNewValue);
        line.add(showOldValue);
        MUser user = MUser.get(Env.getCtx(), UpdatedBy);
        line.add(user.getName());
        line.add(this.m_dateFormat.format(Updated));
        line.add(column.getColumnName());
        this.m_data.add(line);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

