/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.util.ArrayList;
import java.util.List;
import org.compiere.apps.AWindow;
import org.compiere.apps.WindowEventListener;
import org.compiere.apps.form.FormFrame;
import org.compiere.swing.CFrame;

public class WindowManager {
    private List<CFrame> windows = new ArrayList<CFrame>();
    private WindowEventListener eventListener = new WindowEventListener(this);

    public void add(CFrame window) {
        this.windows.add(window);
        window.addComponentListener(this.eventListener);
        window.addWindowListener(this.eventListener);
    }

    public void close() {
        for (CFrame w : this.windows) {
            w.removeComponentListener(this.eventListener);
            w.removeWindowListener(this.eventListener);
            w.dispose();
        }
        this.windows = new ArrayList<CFrame>();
    }

    public void closeOthers(CFrame window) {
        for (CFrame w : this.windows) {
            w.removeComponentListener(this.eventListener);
            w.removeWindowListener(this.eventListener);
            if (w.equals(window)) continue;
            w.dispose();
        }
        this.windows = new ArrayList<CFrame>();
        this.add(window);
    }

    public void remove(CFrame window) {
        if (this.windows.remove(window)) {
            window.removeComponentListener(this.eventListener);
            window.removeWindowListener(this.eventListener);
        }
    }

    public CFrame[] getWindows() {
        CFrame[] a = new CFrame[this.windows.size()];
        return this.windows.toArray(a);
    }

    public int getWindowCount() {
        return this.windows.size();
    }

    public AWindow find(int AD_Window_ID) {
        for (CFrame w : this.windows) {
            AWindow a;
            if (!(w instanceof AWindow) || (a = (AWindow)w).getAD_Window_ID() != AD_Window_ID) continue;
            return a;
        }
        return null;
    }

    public FormFrame findForm(int AD_FORM_ID) {
        for (CFrame w : this.windows) {
            FormFrame ff;
            if (!(w instanceof FormFrame) || (ff = (FormFrame)w).getAD_Form_ID() != AD_FORM_ID) continue;
            return ff;
        }
        return null;
    }
}

