/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.RowSet;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_MySQL;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;

public class DB_MySQL
implements AdempiereDatabase {
    private org.gjt.mm.mysql.Driver s_driver = null;
    public static final String DRIVER = "org.gjt.mm.mysql.Driver";
    public static final int DEFAULT_PORT = 3306;
    private ComboPooledDataSource m_ds = null;
    private Convert_MySQL m_convert = new Convert_MySQL();
    private String m_connection;
    private String m_dbName = null;
    private String m_userName = null;
    private String m_connectionURL;
    private boolean m_supportAlias = false;
    private static CLogger log = CLogger.getCLogger(DB_MySQL.class);
    private static int m_maxbusyconnections = 0;

    @Override
    public Convert getConvert() {
        return this.m_convert;
    }

    @Override
    public String getName() {
        return Database.DB_MYSQL;
    }

    @Override
    public String getDescription() {
        try {
            if (this.s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.s_driver != null) {
            return this.s_driver.toString();
        }
        return "No Driver for MySQL";
    }

    @Override
    public int getStandardPort() {
        return 3306;
    }

    @Override
    public Driver getDriver() throws SQLException {
        if (this.s_driver == null) {
            this.s_driver = new org.gjt.mm.mysql.Driver();
            DriverManager.registerDriver((Driver)this.s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return this.s_driver;
    }

    @Override
    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = new StringBuffer("jdbc:mysql:");
        sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName()).append("?encoding=UNICODE");
        this.m_connection = sb.toString();
        return this.m_connection;
    }

    @Override
    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        return "jdbc:mysql://" + dbHost + ":" + dbPort + "/" + dbName;
    }

    @Override
    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    @Override
    public String getCatalog() {
        if (this.m_dbName != null) {
            return this.m_dbName;
        }
        return null;
    }

    @Override
    public String getSchema() {
        return "adempiere";
    }

    @Override
    public boolean supportsBLOB() {
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("DB_MySQL[");
        sb.append(this.m_connectionURL);
        try {
            StringBuffer logBuffer = new StringBuffer(50);
            logBuffer.append("# Connections: ").append(this.m_ds.getNumConnections());
            logBuffer.append(" , # Busy Connections: ").append(this.m_ds.getNumBusyConnections());
            logBuffer.append(" , # Idle Connections: ").append(this.m_ds.getNumIdleConnections());
            logBuffer.append(" , # Orphaned Connections: ").append(this.m_ds.getNumUnclosedOrphanedConnections());
        }
        catch (Exception e) {
            sb.append("=").append(e.getLocalizedMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getStatus() {
        if (this.m_ds == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("# Connections: ").append(this.m_ds.getNumConnections());
            sb.append(" , # Busy Connections: ").append(this.m_ds.getNumBusyConnections());
            sb.append(" , # Idle Connections: ").append(this.m_ds.getNumIdleConnections());
            sb.append(" , # Orphaned Connections: ").append(this.m_ds.getNumUnclosedOrphanedConnections());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public String convertStatement(String oraStatement) {
        String[] retValue = this.m_convert.convert(oraStatement);
        if (retValue.length == 0) {
            return oraStatement;
        }
        if (retValue == null) {
            log.log(Level.SEVERE, "DB_MySQL.convertStatement - Not Converted (" + oraStatement + ") - " + this.m_convert.getConversionError());
            throw new IllegalArgumentException("DB_MySQL.convertStatement - Not Converted (" + oraStatement + ") - " + this.m_convert.getConversionError());
        }
        if (retValue.length != 1) {
            log.log(Level.SEVERE, "DB_MySQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
            throw new IllegalArgumentException("DB_MySQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
        }
        if (!oraStatement.equals(retValue[0]) && retValue[0].indexOf("AD_Error") == -1) {
            log.log(Level.ALL, "MySQL =>" + retValue[0] + "<= <" + oraStatement + ">");
        }
        Convert.logMigrationScript(oraStatement, null, retValue[0]);
        return retValue[0];
    }

    @Override
    public String getSystemUser() {
        return "root";
    }

    @Override
    public String getSystemDatabase(String databaseName) {
        return "adempiere";
    }

    @Override
    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "current_date()";
            }
            return "now()";
        }
        StringBuffer dateString = new StringBuffer("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(46)));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    @Override
    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuffer retValue = new StringBuffer("CAST (");
        retValue.append(columnName);
        retValue.append(" AS Char)");
        return retValue.toString();
    }

    @Override
    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision(displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, 4);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result.toString();
    }

    @Override
    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[]{"CREATE USER adempiere;"};
        }
        if (1 == cmdType) {
            return new String[]{"CREATE DATABASE adempiere OWNER adempiere;", "GRANT ALL PRIVILEGES ON adempiere TO adempiere;", "CREATE SCHEMA adempiere;", "SET search_path TO adempiere;"};
        }
        if (2 == cmdType) {
            return new String[]{"DROP DATABASE adempiere;"};
        }
        return null;
    }

    public RowSet getRowSet(ResultSet rs) throws SQLException {
        throw new UnsupportedOperationException("MySQL does not support RowSets");
    }

    @Override
    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn;
        if (this.m_ds == null) {
            this.getDataSource(connection);
        }
        if ((conn = this.m_ds.getConnection()) != null) {
            conn.setAutoCommit(autoCommit);
            conn.setTransactionIsolation(transactionIsolation);
            try {
                int numConnections = this.m_ds.getNumBusyConnections();
                if (numConnections >= m_maxbusyconnections && m_maxbusyconnections > 0) {
                    log.warning(this.getStatus());
                    Runtime.getRuntime().runFinalization();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return conn;
    }

    @Override
    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds != null) {
            return this.m_ds;
        }
        try {
            System.setProperty("com.mchange.v2.log.MLog", "com.mchange.v2.log.FallbackMLog");
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            cpds.setDataSourceName("AdempiereDS");
            cpds.setDriverClass(DRIVER);
            cpds.setJdbcUrl(this.getConnectionURL(connection));
            cpds.setUser(connection.getDbUid());
            cpds.setPassword(connection.getDbPwd());
            cpds.setPreferredTestQuery("SELECT Version FROM AD_System");
            cpds.setIdleConnectionTestPeriod(1200);
            cpds.setAcquireRetryAttempts(2);
            if (Ini.isClient()) {
                cpds.setInitialPoolSize(1);
                cpds.setMinPoolSize(1);
                cpds.setMaxPoolSize(15);
                cpds.setMaxIdleTimeExcessConnections(1200);
                cpds.setMaxIdleTime(900);
                m_maxbusyconnections = 10;
            } else {
                cpds.setInitialPoolSize(10);
                cpds.setMinPoolSize(5);
                cpds.setMaxPoolSize(150);
                cpds.setMaxIdleTimeExcessConnections(1200);
                cpds.setMaxIdleTime(1200);
                m_maxbusyconnections = 120;
            }
            this.m_ds = cpds;
        }
        catch (Exception ex) {
            this.m_ds = null;
            log.log(Level.SEVERE, "Could not initialise C3P0 Datasource", ex);
        }
        return this.m_ds;
    }

    public ConnectionPoolDataSource createPoolDataSource(CConnection connection) {
        throw new UnsupportedOperationException("Not supported/implemented");
    }

    @Override
    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    @Override
    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    @Override
    public void close() {
        log.config(this.toString());
        if (this.m_ds != null) {
            try {
                this.m_ds.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_ds = null;
    }

    @Override
    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    @Override
    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.toUpperCase().endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    @Override
    public boolean isSupported(String sql) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpLocks(Connection conn) {
        Statement stmt = null;
        try {
            String sql = "select pg_class.relname,pg_locks.* from pg_class,pg_locks where pg_class.relfilenode=pg_locks.relation order by 1";
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int cnt = rs.getMetaData().getColumnCount();
            System.out.println();
            while (rs.next()) {
                for (int i = 0; i < cnt; ++i) {
                    Object value = rs.getObject(i + 1);
                    if (i > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(value != null ? value.toString() : "");
                }
                System.out.println();
            }
            System.out.println();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void main(String[] args) {
        DB_MySQL mysql = new DB_MySQL();
        String databaseName = "adempiere";
        String uid = "adempiere";
        String pwd = "adempiere";
        String jdbcURL = mysql.getConnectionURL("localhost", 3306, databaseName, uid);
        System.out.println(jdbcURL);
        try {
            mysql.getDriver();
            System.out.println(mysql.getDriver());
            Connection conn = DriverManager.getConnection(jdbcURL, uid, pwd);
            conn.close();
            conn = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int getNextID(String name) {
        int m_sequence_id = DB.getSQLValue(null, "SELECT nextval('" + name.toLowerCase() + "')");
        return m_sequence_id;
    }

    @Override
    public boolean createSequence(String name, int increment, int minvalue, int maxvalue, int start, String trxName) {
        int no = DB.executeUpdate("CREATE SEQUENCE " + name.toUpperCase() + " INCREMENT " + increment + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " START " + start, trxName);
        return no != -1;
    }

    @Override
    public String addPagingSQL(String sql, int start, int end) {
        return null;
    }

    @Override
    public boolean isPagingSupported() {
        return false;
    }

    @Override
    public boolean isQueryTimeoutSupported() {
        return false;
    }
}

