/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.grid.ICreateFrom;
import org.compiere.grid.VCreateFromInvoiceUI;
import org.compiere.grid.VCreateFromRMAUI;
import org.compiere.grid.VCreateFromShipmentUI;
import org.compiere.grid.VCreateFromStatementUI;
import org.compiere.model.GridTab;
import org.compiere.model.I_C_BankStatement;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_M_InOut;
import org.compiere.model.I_M_RMA;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class VCreateFromFactory {
    private static CLogger s_log = CLogger.getCLogger(VCreateFromFactory.class);
    private static HashMap<Integer, Class<? extends ICreateFrom>> s_registeredClasses = null;

    public static final void registerClass(int ad_table_id, Class<? extends ICreateFrom> cl) {
        s_registeredClasses.put(ad_table_id, cl);
        s_log.info("Registered AD_Table_ID=" + ad_table_id + ", Class=" + cl);
    }

    public static ICreateFrom create(GridTab mTab) {
        int AD_Table_ID = Env.getContextAsInt(Env.getCtx(), mTab.getWindowNo(), "BaseTable_ID");
        ICreateFrom retValue = null;
        Class<? extends ICreateFrom> cl = s_registeredClasses.get(AD_Table_ID);
        if (cl != null) {
            try {
                Constructor<? extends ICreateFrom> ctor = cl.getConstructor(GridTab.class);
                retValue = ctor.newInstance(mTab);
            }
            catch (Throwable e) {
                s_log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                return null;
            }
        }
        if (retValue == null) {
            s_log.info("Unsupported AD_Table_ID=" + AD_Table_ID);
            return null;
        }
        return retValue;
    }

    static {
        s_registeredClasses = new HashMap();
        s_registeredClasses.put(I_C_Invoice.Table_ID, VCreateFromInvoiceUI.class);
        s_registeredClasses.put(I_C_BankStatement.Table_ID, VCreateFromStatementUI.class);
        s_registeredClasses.put(I_M_InOut.Table_ID, VCreateFromShipmentUI.class);
        s_registeredClasses.put(I_M_RMA.Table_ID, VCreateFromRMAUI.class);
    }
}

