/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

public abstract class AutoCompleter
implements MouseListener {
    private static final long serialVersionUID = -5135462631871597277L;
    private static final String AUTOCOMPLETER = "AUTOCOMPLETER";
    private static final int PopupDelayMillis = 500;
    protected final CLogger log = CLogger.getCLogger(this.getClass());
    final JList listBox = new JList();
    final JTextComponent textBox;
    private final JPopupMenu popup = new JPopupMenu();
    private boolean m_empty = false;
    private final Timer timer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoCompleter.this.showPopup();
        }
    });
    private static final Action acceptAction = new AbstractAction(){
        private static final long serialVersionUID = -3950389799318995148L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            AutoCompleter completer = (AutoCompleter)tf.getClientProperty(AutoCompleter.AUTOCOMPLETER);
            completer.popup.setVisible(false);
            if (completer.listBox.getSelectedValue() == null) {
                String txt = completer.textBox.getText();
                ListModel lm = completer.listBox.getModel();
                for (int index = 0; index < lm.getSize(); ++index) {
                    if (!AutoCompleter.startsWithIgnoreCase(lm.getElementAt(index).toString(), txt)) continue;
                    completer.acceptedListItem(lm.getElementAt(index));
                    break;
                }
            } else {
                completer.acceptedListItem(completer.listBox.getSelectedValue());
            }
        }
    };
    private final DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            AutoCompleter.this.showPopupDelayed();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AutoCompleter.this.showPopupDelayed();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    };
    static Action showAction = new AbstractAction(){
        private static final long serialVersionUID = 8868536979000734628L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            AutoCompleter completer = (AutoCompleter)tf.getClientProperty(AutoCompleter.AUTOCOMPLETER);
            if (tf.isEnabled()) {
                if (completer.popup.isVisible()) {
                    completer.selectNextPossibleValue();
                } else {
                    completer.showPopup();
                }
            }
        }
    };
    private static final Action upAction = new AbstractAction(){
        private static final long serialVersionUID = 2200136359410394434L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            AutoCompleter completer = (AutoCompleter)tf.getClientProperty(AutoCompleter.AUTOCOMPLETER);
            if (tf.isEnabled() && completer.popup.isVisible()) {
                completer.selectPreviousPossibleValue();
            }
        }
    };
    private static final Action hidePopupAction = new AbstractAction(){
        private static final long serialVersionUID = -5683983067872135654L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            AutoCompleter completer = (AutoCompleter)tf.getClientProperty(AutoCompleter.AUTOCOMPLETER);
            if (tf.isEnabled()) {
                completer.popup.setVisible(false);
            }
        }
    };

    public AutoCompleter(JTextComponent comp) {
        this.textBox = comp;
        this.textBox.putClientProperty(AUTOCOMPLETER, this);
        JScrollPane scroll = new JScrollPane(this.listBox);
        scroll.setBorder(null);
        this.listBox.setFocusable(false);
        this.listBox.addMouseListener(this);
        scroll.getVerticalScrollBar().setFocusable(false);
        scroll.getHorizontalScrollBar().setFocusable(false);
        this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
        this.popup.add(scroll);
        if (this.textBox instanceof JTextField) {
            this.textBox.registerKeyboardAction(showAction, KeyStroke.getKeyStroke(40, 0), 0);
            this.textBox.getDocument().addDocumentListener(this.documentListener);
        }
        this.textBox.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 0);
        this.textBox.registerKeyboardAction(hidePopupAction, KeyStroke.getKeyStroke(27, 0), 0);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AutoCompleter.this.textBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.listBox.setRequestFocusEnabled(false);
    }

    public boolean isEmpty() {
        return this.m_empty;
    }

    public void setEmpty(boolean empty) {
        this.m_empty = empty;
    }

    private void showPopupDelayed() {
        this.log.finest("showPopupDelayed..");
        this.timer.setRepeats(false);
        this.timer.start();
    }

    private void showPopup() {
        this.log.finest("showPopup");
        this.popup.setVisible(false);
        if (this.textBox.isEnabled() && this.updateListData() && this.listBox.getModel().getSize() != 0) {
            this.setEmpty(false);
            if (!(this.textBox instanceof JTextField)) {
                this.textBox.getDocument().addDocumentListener(this.documentListener);
            }
            this.textBox.registerKeyboardAction(acceptAction, KeyStroke.getKeyStroke(10, 0), 0);
            int size = this.listBox.getModel().getSize();
            this.listBox.setVisibleRowCount(size < 10 ? size : 10);
            int x = 0;
            try {
                int pos = Math.min(this.textBox.getCaret().getDot(), this.textBox.getCaret().getMark());
                x = this.textBox.getUI().modelToView((JTextComponent)this.textBox, (int)pos).x;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.popup.show(this.textBox, x, this.textBox.getHeight());
        } else {
            this.popup.setVisible(false);
            this.setEmpty(true);
        }
        this.textBox.requestFocus();
    }

    protected void selectNextPossibleValue() {
        int si = this.listBox.getSelectedIndex();
        if (si < this.listBox.getModel().getSize() - 1) {
            this.listBox.setSelectedIndex(si + 1);
            this.listBox.ensureIndexIsVisible(si + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int si = this.listBox.getSelectedIndex();
        if (si > 0) {
            this.listBox.setSelectedIndex(si - 1);
            this.listBox.ensureIndexIsVisible(si - 1);
        }
    }

    protected static boolean startsWithIgnoreCase(String str1, String str2) {
        String s1 = Util.stripDiacritics(str1.toUpperCase()).trim();
        String s2 = Util.stripDiacritics(str2.toUpperCase()).trim();
        return s1.startsWith(s2);
    }

    protected abstract boolean updateListData();

    protected abstract void acceptedListItem(Object var1);
}

