/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.compiere.apps.ADialog;
import org.compiere.grid.ed.VDate;
import org.compiere.util.CLogger;

public final class MDocDate
extends PlainDocument
implements CaretListener {
    private static final long serialVersionUID = 8453168098223574265L;
    private JTextComponent m_tc;
    private SimpleDateFormat m_format;
    private String m_mask;
    private static final char DELIMITER = '^';
    private String m_title;
    private int m_displayType;
    private int m_lastDot = 0;
    private static CLogger log = CLogger.getCLogger(MDocDate.class);

    public MDocDate(int displayType, SimpleDateFormat format, JTextComponent tc, String title) {
        this.m_displayType = displayType;
        this.m_tc = tc;
        this.m_tc.addCaretListener(this);
        this.m_format = format;
        if (this.m_format == null) {
            this.m_format = new SimpleDateFormat();
        }
        this.m_format.setLenient(false);
        char[] pattern = this.m_format.toPattern().toCharArray();
        for (int i = 0; i < pattern.length; ++i) {
            if ("Mdy".indexOf(pattern[i]) != -1) continue;
            pattern[i] = 94;
        }
        this.m_mask = new String(pattern);
        this.m_title = title;
        if (this.m_title == null) {
            this.m_title = "";
        }
    }

    @Override
    public void insertString(int offset, String string, AttributeSet attr) throws BadLocationException {
        log.finest("Offset=" + offset + ",String=" + string + ",Attr=" + attr + ",OldText=" + this.getText() + ",OldLength=" + this.getText().length());
        if (string != null && string.length() == 1) {
            if (offset >= this.m_mask.length()) {
                return;
            }
            int length = this.getText().length();
            if (offset == 0 && length == 0) {
                Date today = new Date(System.currentTimeMillis());
                String dateStr = this.m_format.format(today);
                super.insertString(0, string + dateStr.substring(1), attr);
                this.m_tc.setCaretPosition(1);
                return;
            }
            try {
                Integer.parseInt(string);
            }
            catch (Exception pe) {
                ADialog.beep();
                return;
            }
            if (offset != this.m_mask.length() - 1 && this.m_mask.charAt(offset + 1) == '^') {
                this.m_tc.setCaretPosition(offset + 2);
            }
            if (this.m_mask.charAt(offset) == '^') {
                this.m_tc.setCaretPosition(++offset + 1);
            }
            super.remove(offset, 1);
        }
        super.insertString(offset, string, attr);
        if (offset == 0 && string != null && string.length() > 1) {
            this.m_tc.setCaretPosition(0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void remove(int offset, int length) throws BadLocationException {
        log.finest("Offset=" + offset + ",Length=" + length);
        if (offset == 0 || length == 0) {
            if (length < this.m_mask.length() && length != 0) return;
            super.remove(offset, length);
            return;
        }
        if (offset - 1 >= 0 && offset - 1 < this.m_mask.length() && this.m_mask.charAt(offset - 1) == '^') {
            if (offset - 2 < 0) return;
            this.m_tc.setCaretPosition(offset - 2);
            return;
        } else {
            this.m_tc.setCaretPosition(offset - 1);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        log.finest("Dot=" + e.getDot() + ",Last=" + this.m_lastDot + ", Mark=" + e.getMark());
        if (e.getDot() != e.getMark()) {
            this.m_lastDot = e.getDot();
            return;
        }
        if (e.getDot() + 1 > this.m_mask.length() || this.m_mask.charAt(e.getDot()) != '^') {
            this.m_lastDot = e.getDot();
            return;
        }
        int newDot = -1;
        newDot = this.m_lastDot > e.getDot() ? e.getDot() - 1 : e.getDot() + 1;
        if (e.getDot() == 0) {
            newDot = 1;
        } else if (e.getDot() == this.m_mask.length() - 1) {
            newDot = e.getDot() - 1;
        }
        log.fine("OnFixedChar=" + this.m_mask.charAt(e.getDot()) + ", newDot=" + newDot + ", last=" + this.m_lastDot);
        this.m_lastDot = e.getDot();
        if (newDot >= 0 && newDot < this.getText().length()) {
            this.m_tc.setCaretPosition(newDot);
        }
    }

    private String getText() {
        String str = "";
        try {
            str = this.getContent().getString(0, this.getContent().length() - 1);
        }
        catch (Exception e) {
            str = "";
        }
        return str;
    }

    private void startDateDialog() {
        log.config("");
        String result = this.getText();
        Timestamp ts = null;
        try {
            ts = new Timestamp(this.m_format.parse(result).getTime());
        }
        catch (Exception pe) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        ts = VDate.startCalendar(this.m_tc, ts, this.m_format, this.m_displayType, this.m_title);
        result = this.m_format.format(ts);
        try {
            super.remove(0, this.getText().length());
            super.insertString(0, result, null);
        }
        catch (BadLocationException ble) {
            log.log(Level.SEVERE, "", ble);
        }
    }
}

