/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.grid.ed.Editor;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.ValuePreference;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VURL
extends JComponent
implements VEditor,
ActionListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = -3023749380845372419L;
    private static CLogger log = CLogger.getCLogger(VURL.class);
    private String m_columnName;
    private CTextField m_text = new CTextField();
    private boolean m_readWrite;
    private boolean m_mandatory;
    private CButton m_button = new CButton();
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mEditor;
    private GridField m_mField = null;
    private String m_oldText;
    private String m_initialText;
    private volatile boolean m_setting = false;
    private volatile boolean m_infocus = false;
    private int m_fieldLength;

    public VURL() {
        this("URL", false, false, true, 20, 60);
    }

    public VURL(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayLength, int fieldLength) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.m_fieldLength = fieldLength;
        this.m_mandatory = mandatory;
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.m_text.getPreferredSize());
        int height = this.m_text.getPreferredSize().height;
        this.m_text = new CTextField(displayLength > 60 ? 60 : displayLength);
        this.m_text.setEditable(isReadOnly);
        this.m_text.setFocusable(true);
        this.m_text.setBorder(null);
        this.m_text.setHorizontalAlignment(10);
        this.setMandatory(mandatory);
        this.add((Component)this.m_text, "Center");
        this.m_button.setIcon(Env.getImageIcon("Online10.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setPreferredSize(new Dimension(height, height));
        this.m_button.addActionListener(this);
        this.m_button.setFocusable(false);
        this.add((Component)this.m_button, "East");
        this.setPreferredSize(this.getPreferredSize());
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.m_text.addKeyListener(this);
        this.m_text.addFocusListener(this);
        this.m_text.addActionListener(this);
        this.m_text.addMouseListener(new VURL_mouseAdapter(this));
        if (fieldLength > displayLength) {
            this.mEditor = new CMenuItem(Msg.getMsg(Env.getCtx(), "Editor"), Env.getImageIcon("Editor16.gif"));
            this.mEditor.addActionListener(this);
            this.popupMenu.add(this.mEditor);
        }
        this.setForeground(AdempierePLAF.getTextColor_Normal());
        this.setBackground(AdempierePLAF.getFieldBackground_Normal());
    }

    @Override
    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_mField = null;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.m_text.setMandatory(mandatory);
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        this.m_readWrite = rw;
        this.m_text.setReadWrite(rw);
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    @Override
    public void setForeground(Color color) {
        this.m_text.setForeground(color);
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.m_readWrite) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setBackground(Color color) {
        this.m_text.setBackground(color);
    }

    @Override
    public void setValue(Object value) {
        this.m_oldText = value == null ? "" : value.toString();
        if (this.m_setting) {
            return;
        }
        this.setText(this.m_oldText);
        this.m_initialText = this.m_oldText;
        if (!this.m_text.isEditable() || !this.isEnabled()) {
            this.m_text.setCaretPosition(0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public String getDisplay() {
        return this.m_text.getText();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        log.finest("Key=" + e.getKeyCode() + " - " + e.getKeyChar() + " -> " + this.getText());
        if (e.getKeyCode() == 27) {
            this.setText(this.m_initialText);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.m_text.addActionListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ValuePreference")) {
            if (MRole.getDefault().isShowPreference()) {
                ValuePreference.start(this.m_mField, this.getValue());
            }
            return;
        }
        if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start(this.m_mField);
            return;
        }
        if (e.getSource() == this.mEditor) {
            String s = Editor.startEditor(this, Msg.translate(Env.getCtx(), this.m_columnName), this.getText(), this.m_text.isEditable(), this.m_fieldLength);
            this.setText(s);
        } else if (e.getSource() == this.m_button) {
            this.action_button();
            return;
        }
        try {
            this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getText());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void action_button() {
        String urlString = this.m_text.getText();
        String message = null;
        if (urlString != null && urlString.length() > 0) {
            try {
                URL url = new URL(urlString);
                Env.startBrowser(urlString);
                return;
            }
            catch (Exception e) {
                message = e.getMessage();
            }
        }
        ADialog.warn(0, this, "URLnotValid", message);
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null && MRole.getDefault().isShowPreference()) {
            ValuePreference.addMenu(this, this.popupMenu);
        }
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    public void setText(String text) {
        this.m_text.setText(text);
    }

    public String getText() {
        String text = this.m_text.getText();
        return text;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.m_infocus = true;
        this.setText(this.getText());
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.m_setting = true;
        try {
            String clear = this.getText();
            if (clear.length() > this.m_fieldLength) {
                clear = clear.substring(0, this.m_fieldLength);
            }
            this.fireVetoableChange(this.m_columnName, this.m_oldText, clear);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
        this.m_infocus = false;
        this.setText(this.getText());
    }

    final class VURL_mouseAdapter
    extends MouseAdapter {
        private VURL m_adaptee;

        VURL_mouseAdapter(VURL adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

