/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.tree;

import de.schaeffer.compiere.tools.DocumentSearch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.adempiere.exceptions.DBException;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.plaf.AdempiereTaskPaneUI;
import org.compiere.apps.ADialog;
import org.compiere.grid.tree.AdempiereTreeModel;
import org.compiere.grid.tree.VTreeCellRenderer;
import org.compiere.grid.tree.VTreeTransferHandler;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.swing.ShadowBorder;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public final class VTreePanel
extends CPanel
implements ActionListener {
    private static final long serialVersionUID = -6798614427038652192L;
    private static final String PREFIX_DOCUMENT_SEARCH = "/";
    protected boolean m_lookAndFeelChanged = false;
    private VTreeTransferHandler handler = new VTreeTransferHandler();
    private static CLogger log = CLogger.getCLogger(VTreePanel.class);
    private BorderLayout mainLayout = new BorderLayout();
    private JTree tree = new JTree();
    private AdempiereTreeModel treeModel;
    private DefaultTreeSelectionModel treeSelect = new DefaultTreeSelectionModel();
    private CPanel southPanel = new CPanel();
    private CCheckBox treeExpand = new CCheckBox();
    private CTextField treeSearch = new CTextField(10);
    private CLabel treeSearchLabel = new CLabel();
    private JPopupMenu popMenuTree = new JPopupMenu();
    private JPopupMenu popMenuBar = new JPopupMenu();
    private CMenuItem mFrom = new CMenuItem();
    private CMenuItem mTo = new CMenuItem();
    private JXTaskPaneContainer bar = new JXTaskPaneContainer();
    private List<JToolBar> toolbar;
    private HashMap<Integer, JToolBar> toolbarMap;
    private int toolBarCols = 3;
    private CMenuItem mBarAdd = new CMenuItem();
    private CMenuItem mBarRemove = new CMenuItem();
    private BorderLayout southLayout = new BorderLayout();
    private JSplitPane centerSplitPane = new JSplitPane();
    private JScrollPane treePane = new JScrollPane();
    private MouseListener mouseListener = new VTreePanel_mouseAdapter(this);
    private KeyListener keyListener = new VTreePanel_keyAdapter(this);
    private int m_WindowNo;
    private int m_AD_Tree_ID = 0;
    private String m_nodeTableName = null;
    private boolean m_editable;
    private boolean m_hasBar;
    private MTreeNode m_root = null;
    private String m_search = "";
    private Enumeration<?> m_nodeEn;
    private MTreeNode m_selectedNode;
    private CButton m_buttonSelected;
    private JScrollPane barScrollPane;
    public static final String NODE_SELECTION = "NodeSelected";

    public VTreePanel(int WindowNo, boolean hasBar, boolean editable) {
        this.toolbar = new ArrayList<JToolBar>();
        log.config("Bar=" + hasBar + ", Editable=" + editable);
        this.m_WindowNo = WindowNo;
        this.m_hasBar = hasBar;
        this.m_editable = editable;
        this.jbInit();
        if (!hasBar) {
            this.barScrollPane.setPreferredSize(new Dimension(0, 0));
            this.barScrollPane.setMaximumSize(new Dimension(0, 0));
            this.barScrollPane.setMinimumSize(new Dimension(0, 0));
            this.bar.setBackground(AdempierePLAF.getFormBackground());
            this.centerSplitPane.setDividerLocation(0);
            this.centerSplitPane.setDividerSize(0);
            this.popMenuTree.remove(this.mBarAdd);
        } else {
            this.centerSplitPane.setDividerLocation(80);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("lookAndFeel".equals(evt.getPropertyName())) {
                        VTreePanel.this.m_lookAndFeelChanged = true;
                    }
                }
            });
        }
        if (editable) {
            this.tree.setDragEnabled(true);
            this.tree.setTransferHandler(this.handler);
            this.tree.setDropMode(DropMode.INSERT);
            this.setMappings(this.tree);
        } else {
            this.popMenuTree.remove(this.mFrom);
            this.popMenuTree.remove(this.mTo);
        }
    }

    public boolean initTree(int AD_Tree_ID) {
        log.config("AD_Tree_ID=" + AD_Tree_ID);
        this.m_AD_Tree_ID = AD_Tree_ID;
        MTree vTree = new MTree(Env.getCtx(), AD_Tree_ID, this.m_editable, true, null);
        this.m_root = vTree.getRoot();
        this.m_root.setName(Msg.getMsg(Env.getCtx(), vTree.getName()));
        log.config("root=" + this.m_root);
        this.m_nodeTableName = vTree.getNodeTableName();
        this.treeModel = new AdempiereTreeModel(this.m_root, true);
        this.treeModel.setMTree(vTree);
        this.tree.setModel(this.treeModel);
        if (this.m_hasBar) {
            JToolBar jt2;
            for (JToolBar jt2 : this.toolbar) {
                jt2.removeAll();
            }
            this.toolbarMap = new HashMap();
            Enumeration<TreeNode> enTop = this.m_root.children();
            jt2 = null;
            HashMap<JToolBar, String> titleMap = new HashMap<JToolBar, String>();
            while (enTop.hasMoreElements()) {
                MTreeNode ndTop = (MTreeNode)enTop.nextElement();
                Enumeration<TreeNode> en = ndTop.preorderEnumeration();
                boolean labelDrawn = false;
                while (en.hasMoreElements()) {
                    MTreeNode nd = (MTreeNode)en.nextElement();
                    if (!nd.isOnBar()) continue;
                    if (!labelDrawn) {
                        jt2 = new JToolBar(1);
                        titleMap.put(jt2, ndTop.toString().trim());
                        labelDrawn = true;
                        this.toolbarMap.put(ndTop.getNode_ID(), jt2);
                    }
                    this.addToBar(nd, jt2, false);
                }
                if (jt2 != null) {
                    this.toolbar.add(jt2);
                }
                jt2 = null;
            }
            for (JToolBar jt2 : this.toolbar) {
                jt2.setOpaque(false);
                jt2.setFloatable(false);
                jt2.setRollover(true);
                jt2.setBorder(BorderFactory.createEmptyBorder());
                JXTaskPane barPart = new JXTaskPane();
                barPart.setUI((TaskPaneUI)new AdempiereTaskPaneUI());
                barPart.getContentPane().setBackground(AdempierePLAF.getFormBackground());
                barPart.setAnimated(true);
                barPart.setLayout((LayoutManager)new BorderLayout());
                barPart.add((Component)jt2, (Object)"North");
                barPart.setTitle((String)titleMap.get(jt2));
                this.bar.add(barPart);
                this.bar.setBackground(AdempierePLAF.getFormBackground());
            }
        }
        return true;
    }

    private void jbInit() {
        this.setLayout(this.mainLayout);
        this.mainLayout.setVgap(5);
        this.treeSelect.setSelectionMode(1);
        this.tree.setSelectionModel(this.treeSelect);
        this.tree.setEditable(false);
        this.tree.addMouseListener(this.mouseListener);
        this.tree.addKeyListener(this.keyListener);
        this.tree.setCellRenderer(new VTreeCellRenderer());
        this.treePane.getViewport().add((Component)this.tree, null);
        this.treePane.setBorder(new ShadowBorder());
        this.tree.setBorder(BorderFactory.createEmptyBorder());
        CPanel treePart = new CPanel();
        treePart.setLayout(new BorderLayout());
        treePart.add((Component)this.treePane, "Center");
        treePart.setBorder(BorderFactory.createEmptyBorder());
        this.treeExpand.setText(Msg.getMsg(Env.getCtx(), "ExpandTree"));
        this.treeExpand.setActionCommand("Expand");
        this.treeExpand.addMouseListener(this.mouseListener);
        this.treeExpand.addActionListener(this);
        this.treeSearchLabel.setText(Msg.getMsg(Env.getCtx(), "TreeSearch") + " ");
        this.treeSearchLabel.setLabelFor(this.treeSearch);
        this.treeSearchLabel.setToolTipText(Msg.getMsg(Env.getCtx(), "TreeSearchText"));
        this.treeSearch.setBackground(AdempierePLAF.getInfoBackground());
        this.treeSearch.addKeyListener(this.keyListener);
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.treeExpand, "West");
        this.southPanel.add((Component)this.treeSearchLabel, "Center");
        this.southPanel.add((Component)this.treeSearch, "East");
        treePart.add((Component)this.southPanel, "South");
        this.centerSplitPane.setOpaque(false);
        this.barScrollPane = new JScrollPane();
        this.barScrollPane.getViewport().add((Component)this.bar);
        this.centerSplitPane.add((Component)this.barScrollPane, "left");
        this.centerSplitPane.add((Component)treePart, "right");
        this.centerSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.removeSplitPaneBorder();
        this.add((Component)this.centerSplitPane, "Center");
        this.mFrom.setText(Msg.getMsg(Env.getCtx(), "ItemMove"));
        this.mFrom.setActionCommand((String)TransferHandler.getCutAction().getValue("Name"));
        this.mFrom.addActionListener(this);
        this.mFrom.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.mTo.setText(Msg.getMsg(Env.getCtx(), "ItemInsert"));
        this.mTo.setActionCommand((String)TransferHandler.getPasteAction().getValue("Name"));
        this.mTo.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.mTo.setMnemonic(86);
        this.mTo.addActionListener(this);
        this.mBarAdd.setText(Msg.getMsg(Env.getCtx(), "BarAdd"));
        this.mBarAdd.setActionCommand("BarAdd");
        this.mBarAdd.addActionListener(this);
        this.mBarRemove.setText(Msg.getMsg(Env.getCtx(), "BarRemove"));
        this.mBarRemove.setActionCommand("BarRemove");
        this.mBarRemove.addActionListener(this);
        this.popMenuTree.setLightWeightPopupEnabled(false);
        this.popMenuTree.add(this.mBarAdd);
        this.popMenuTree.add(this.mFrom);
        if (!this.m_hasBar) {
            this.popMenuTree.addSeparator();
        }
        this.popMenuTree.add(this.mTo);
        this.popMenuBar.setLightWeightPopupEnabled(false);
        this.popMenuBar.add(this.mBarRemove);
    }

    private void removeSplitPaneBorder() {
        SplitPaneUI splitPaneUI;
        if (this.centerSplitPane != null && (splitPaneUI = this.centerSplitPane.getUI()) instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI basicUI = (BasicSplitPaneUI)splitPaneUI;
            basicUI.getDivider().setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void setDividerLocation(int location) {
        this.centerSplitPane.setDividerLocation(location);
    }

    public int getDividerLocation() {
        return this.centerSplitPane.getDividerLocation();
    }

    protected void keyPressed(KeyEvent e) {
        if (e.getSource() == this.treeSearch && this.treeSearch.getText() != null && this.treeSearch.getText().length() > 0 && this.treeSearch.getText().substring(0, 1).equals(PREFIX_DOCUMENT_SEARCH)) {
            this.setBusy(true);
            DocumentSearch search = new DocumentSearch();
            if (search.openDocumentsByDocumentNo(this.treeSearch.getText().substring(1))) {
                this.treeSearch.setText(null);
            }
            this.setBusy(false);
            return;
        }
        if (e.getSource() instanceof JTree || e.getSource() == this.treeSearch && e.getModifiers() != 0) {
            TreePath tp = this.tree.getSelectionPath();
            if (tp == null) {
                ADialog.beep();
            } else {
                MTreeNode tn = (MTreeNode)tp.getLastPathComponent();
                this.setSelectedNode(tn);
            }
        } else if (e.getSource() == this.treeSearch) {
            String search = this.treeSearch.getText();
            boolean found = false;
            if (this.m_nodeEn != null && !this.m_nodeEn.hasMoreElements()) {
                this.m_search = "";
            }
            if (!search.equals(this.m_search)) {
                this.m_nodeEn = this.m_root.preorderEnumeration();
                this.m_search = search;
            }
            while (!found && this.m_nodeEn != null && this.m_nodeEn.hasMoreElements()) {
                MTreeNode nd = (MTreeNode)this.m_nodeEn.nextElement();
                if (nd.toString().toUpperCase().indexOf(search.toUpperCase()) == -1) continue;
                found = true;
                TreePath treePath = new TreePath(nd.getPath());
                this.tree.setSelectionPath(treePath);
                this.tree.makeVisible(treePath);
                this.tree.scrollPathToVisible(treePath);
            }
            if (!found) {
                ADialog.beep();
            }
        }
    }

    protected void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof JTree) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 0) {
                int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    MTreeNode tn = (MTreeNode)this.tree.getPathForLocation(e.getX(), e.getY()).getLastPathComponent();
                    this.setSelectedNode(tn);
                }
            } else if ((this.m_editable || this.m_hasBar) && SwingUtilities.isRightMouseButton(e)) {
                int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    this.tree.setSelectionRow(selRow);
                }
                if (this.tree.getSelectionPath() != null) {
                    MTreeNode nd = (MTreeNode)this.tree.getSelectionPath().getLastPathComponent();
                    if (nd.isLeaf()) {
                        this.mBarAdd.setEnabled(true);
                    } else {
                        this.mBarAdd.setEnabled(false);
                    }
                    Rectangle r = this.tree.getPathBounds(this.tree.getSelectionPath());
                    this.popMenuTree.show(this.tree, (int)r.getMaxX(), (int)r.getY());
                }
            }
        } else if (e.getSource() instanceof JButton && SwingUtilities.isRightMouseButton(e)) {
            this.m_buttonSelected = (CButton)e.getSource();
            this.popMenuBar.show(this.m_buttonSelected, e.getX(), e.getY());
        }
    }

    public MTreeNode getSelectedNode() {
        return this.m_selectedNode;
    }

    public JComponent getSearchField() {
        return this.treeSearch;
    }

    public boolean setSelectedNode(int nodeID) {
        log.config("ID=" + nodeID);
        if (nodeID != -1) {
            return this.selectID(nodeID, true);
        }
        return false;
    }

    private boolean selectID(int nodeID, boolean show) {
        if (this.m_root == null) {
            return false;
        }
        log.config("NodeID=" + nodeID + ", Show=" + show + ", root=" + this.m_root);
        MTreeNode node = this.m_root.findNode(nodeID);
        if (node != null) {
            TreePath treePath = new TreePath(node.getPath());
            log.config("Node=" + node + ", Path=" + treePath.toString());
            this.tree.setSelectionPath(treePath);
            if (show) {
                this.tree.makeVisible(treePath);
                this.tree.scrollPathToVisible(treePath);
            }
            return true;
        }
        log.info("Node not found; ID=" + nodeID);
        return false;
    }

    private void setSelectedNode(MTreeNode nd) {
        log.config("Node = " + nd);
        this.m_selectedNode = nd;
        this.firePropertyChange(NODE_SELECTION, null, nd);
    }

    public void nodeChanged(boolean save, int keyID, String name, String description, boolean isSummary, String imageIndicator) {
        log.config("Save=" + save + ", KeyID=" + keyID + ", Name=" + name + ", Description=" + description + ", IsSummary=" + isSummary + ", ImageInd=" + imageIndicator + ", root=" + this.m_root);
        if (keyID == 0) {
            return;
        }
        MTreeNode node = this.m_root.findNode(keyID);
        if (node == null && save) {
            node = new MTreeNode(keyID, 0, name, description, this.m_root.getNode_ID(), isSummary, imageIndicator, false, null);
            this.m_root.add(node);
        } else if (node != null && save) {
            node.setName(name);
            node.setAllowsChildren(isSummary);
        } else if (node != null && !save) {
            MTreeNode parent = (MTreeNode)node.getParent();
            node.removeFromParent();
            node = parent;
        } else {
            log.log(Level.SEVERE, "Save=" + save + ", KeyID=" + keyID + ", Node=" + node);
            node = null;
        }
        if (node == null) {
            return;
        }
        this.tree.updateUI();
        TreePath treePath = new TreePath(node.getPath());
        this.tree.setSelectionPath(treePath);
        this.tree.makeVisible(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            this.selectID(Integer.parseInt(e.getActionCommand()), false);
            MTreeNode tn = (MTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            this.setSelectedNode(tn);
        } else if (e.getSource() instanceof JMenuItem) {
            String action = e.getActionCommand();
            Action a = this.tree.getActionMap().get(action);
            if (a != null) {
                a.actionPerformed(new ActionEvent(this.tree, 1001, null));
            } else if (action.equals("BarAdd")) {
                this.barAdd();
            } else if (action.equals("BarRemove")) {
                this.barRemove();
            }
        } else if (e.getSource() instanceof JCheckBox && e.getActionCommand().equals("Expand")) {
            this.expandTree();
        }
    }

    private void barAdd() {
        MTreeNode nd = (MTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        if (this.barDBupdate(true, nd.getNode_ID())) {
            this.addToBar(nd, this.getParentToolBar(nd), false);
        } else if (DBException.isUniqueContraintError(CLogger.retrieveException())) {
            ADialog.error(0, this, "BookmarkExist", null);
        }
    }

    private JToolBar getParentToolBar(MTreeNode nd) {
        int topParentId = this.getTopParentId(nd);
        JToolBar parent = this.toolbarMap.get(topParentId);
        if (parent == null) {
            Enumeration<TreeNode> enTop = this.m_root.children();
            while (enTop.hasMoreElements()) {
                MTreeNode ndTop = (MTreeNode)enTop.nextElement();
                if (ndTop.getNode_ID() != topParentId) continue;
                log.fine("add new category: " + ndTop);
                parent = new JToolBar(1);
                this.toolbarMap.put(ndTop.getNode_ID(), parent);
                this.toolbar.add(parent);
                parent.setOpaque(false);
                parent.setFloatable(false);
                parent.setRollover(true);
                parent.setBorder(BorderFactory.createEmptyBorder());
                JXTaskPane barPart = new JXTaskPane();
                barPart.setUI((TaskPaneUI)new AdempiereTaskPaneUI());
                barPart.getContentPane().setBackground(AdempierePLAF.getFormBackground());
                barPart.setTitle(ndTop.toString().trim());
                barPart.setAnimated(true);
                barPart.setLayout((LayoutManager)new BorderLayout());
                barPart.add((Component)parent, (Object)"North");
                this.bar.add(barPart);
                return parent;
            }
        } else {
            log.fine("parent found: " + parent);
        }
        return parent;
    }

    private int getTopParentId(MTreeNode nd) {
        MTreeNode parent = (MTreeNode)nd.getParent();
        if (parent != null && parent.getNode_ID() != 0) {
            return this.getTopParentId(parent);
        }
        return nd.getNode_ID();
    }

    private void addToBar(MTreeNode nd, JToolBar currentToolBar, boolean isLabel) {
        String label = nd.toString().trim();
        if (!isLabel) {
            CButton button = new CButton(label);
            button.setOpaque(false);
            button.setHorizontalAlignment(2);
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setIcon(nd.getIcon());
            button.setRequestFocusEnabled(false);
            button.setToolTipText(nd.getDescription());
            button.setActionCommand(String.valueOf(nd.getNode_ID()));
            button.addActionListener(this);
            button.addMouseListener(this.mouseListener);
            currentToolBar.add(button);
        } else {
            currentToolBar.add(new JLabel("<html><u><b>" + label + "</b></u></html>"));
        }
        this.bar.validate();
        this.bar.repaint();
    }

    private void barRemove() {
        JToolBar parentBar = (JToolBar)this.m_buttonSelected.getParent();
        Container parentPanel = null;
        if (parentBar != null) {
            parentPanel = parentBar.getParent();
        }
        for (JToolBar jt : this.toolbar) {
            jt.remove(this.m_buttonSelected);
        }
        if (parentPanel != null && parentBar.getComponentCount() == 1) {
            this.bar.remove((Component)parentPanel);
            this.toolbarMap.values().remove(parentBar);
        }
        this.bar.validate();
        this.bar.repaint();
        this.barDBupdate(false, Integer.parseInt(this.m_buttonSelected.getActionCommand()));
    }

    private boolean barDBupdate(boolean add, int Node_ID) {
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        int AD_Org_ID = Env.getContextAsInt(Env.getCtx(), "#AD_Org_ID");
        int AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID");
        StringBuffer sql = new StringBuffer();
        if (add) {
            sql.append("INSERT INTO AD_TreeBar (AD_Tree_ID,AD_User_ID,Node_ID, AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy)VALUES (").append(this.m_AD_Tree_ID).append(",").append(AD_User_ID).append(",").append(Node_ID).append(",").append(AD_Client_ID).append(",").append(AD_Org_ID).append(",").append("'Y',SysDate,").append(AD_User_ID).append(",SysDate,").append(AD_User_ID).append(")");
        } else {
            sql.append("DELETE AD_TreeBar WHERE AD_Tree_ID=").append(this.m_AD_Tree_ID).append(" AND AD_User_ID=").append(AD_User_ID).append(" AND Node_ID=").append(Node_ID);
        }
        int no = DB.executeUpdate(sql.toString(), false, null);
        return no == 1;
    }

    private void expandTree() {
        if (this.treeExpand.isSelected()) {
            for (int row = 0; row < this.tree.getRowCount(); ++row) {
                this.tree.expandRow(row);
            }
        } else {
            for (int row = this.tree.getRowCount(); row > 0; --row) {
                this.tree.collapseRow(row);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.m_lookAndFeelChanged) {
            this.m_lookAndFeelChanged = false;
            if (this.m_hasBar) {
                this.removeSplitPaneBorder();
            }
        }
        super.paint(g);
    }

    private void setMappings(JTree tree) {
        ActionMap map = tree.getActionMap();
        map.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }

    private void setBusy(boolean busy) {
        JFrame frame = Env.getFrame(this);
        log.info("frame: " + frame);
        if (frame == null) {
            return;
        }
        if (busy) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            frame.setCursor(Cursor.getPredefinedCursor(3));
            this.treeSearch.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            frame.setCursor(Cursor.getDefaultCursor());
            this.treeSearch.setCursor(Cursor.getDefaultCursor());
        }
    }

    class VTreePanel_keyAdapter
    extends KeyAdapter {
        VTreePanel m_adaptee;

        VTreePanel_keyAdapter(VTreePanel adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.m_adaptee.keyPressed(e);
            }
        }
    }

    class VTreePanel_mouseAdapter
    extends MouseAdapter {
        VTreePanel m_adaptee;

        VTreePanel_mouseAdapter(VTreePanel adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.m_adaptee.mouseClicked(e);
        }
    }
}

