/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;

public class AccessSqlParser {
    private static final String FROM = " FROM ";
    private static final int FROM_LENGTH = " FROM ".length();
    private static final String WHERE = " WHERE ";
    private static final String ON = " ON ";
    private CLogger log = CLogger.getCLogger(this.getClass());
    private String m_sqlOriginal;
    private String[] m_sql;
    private ArrayList<TableInfo[]> m_tableInfo = new ArrayList();

    public AccessSqlParser() {
    }

    public AccessSqlParser(String sql) {
        this.setSql(sql);
    }

    public void setSql(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("No SQL");
        }
        this.m_sqlOriginal = sql;
        int index = this.m_sqlOriginal.indexOf("\nFROM ");
        if (index != -1) {
            this.m_sqlOriginal = this.m_sqlOriginal.replace("\nFROM ", FROM);
        }
        if ((index = this.m_sqlOriginal.indexOf("\nWHERE ")) != -1) {
            this.m_sqlOriginal = this.m_sqlOriginal.replace("\nWHERE ", WHERE);
        }
        this.parse();
    }

    public String getSql() {
        return this.m_sqlOriginal;
    }

    public boolean parse() {
        if (this.m_sqlOriginal == null || this.m_sqlOriginal.length() == 0) {
            throw new IllegalArgumentException("No SQL");
        }
        this.getSelectStatements();
        for (int i = 0; i < this.m_sql.length; ++i) {
            TableInfo[] info = this.getTableInfo(this.m_sql[i].trim());
            this.m_tableInfo.add(info);
        }
        if (CLogMgt.isLevelFinest()) {
            this.log.fine(this.toString());
        }
        return this.m_tableInfo.size() > 0;
    }

    private void getSelectStatements() {
        String[] sqlIn = new String[]{this.m_sqlOriginal};
        String[] sqlOut = null;
        try {
            sqlOut = this.getSubSQL(sqlIn);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.m_sqlOriginal, e);
            throw new IllegalArgumentException(this.m_sqlOriginal);
        }
        while (sqlIn.length != sqlOut.length) {
            sqlIn = sqlOut;
            try {
                sqlOut = this.getSubSQL(sqlIn);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, this.m_sqlOriginal, e);
                throw new IllegalArgumentException(sqlOut.length + ": " + this.m_sqlOriginal);
            }
        }
        this.m_sql = sqlOut;
    }

    private String[] getSubSQL(String[] sqlIn) {
        ArrayList<String> list = new ArrayList<String>();
        for (int sqlIndex = 0; sqlIndex < sqlIn.length; ++sqlIndex) {
            String sql = sqlIn[sqlIndex];
            int index = sql.indexOf("(SELECT ", 7);
            while (index != -1) {
                int endIndex = index + 1;
                int parenthesisLevel = 0;
                while (endIndex++ < sql.length()) {
                    char c = sql.charAt(endIndex);
                    if (c == ')') {
                        if (parenthesisLevel == 0) break;
                        --parenthesisLevel;
                        continue;
                    }
                    if (c != '(') continue;
                    ++parenthesisLevel;
                }
                String subSQL = sql.substring(index, endIndex + 1);
                list.add(subSQL);
                sql = sql.substring(0, index + 1) + "##" + sql.substring(endIndex);
                index = sql.indexOf("(SELECT ", 7);
            }
            list.add(sql);
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private TableInfo[] getTableInfo(String sql) {
        int fromIndex;
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        if (sql.startsWith("(") && sql.endsWith(")")) {
            sql = sql.substring(1, sql.length() - 1);
        }
        if ((fromIndex = sql.indexOf(FROM)) != sql.lastIndexOf(FROM)) {
            this.log.log(Level.WARNING, "More than one FROM clause - " + sql);
        }
        while (fromIndex != -1) {
            String from = sql.substring(fromIndex + FROM_LENGTH);
            int index = from.lastIndexOf(WHERE);
            if (index != -1) {
                from = from.substring(0, index);
            }
            from = from.replaceAll("[\r\n\t ]+AS[\r\n\t ]+", " ");
            from = from.replaceAll("[\r\n\t ]+as[\r\n\t ]+", " ");
            from = from.replaceAll("[\r\n\t ]+INNER[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = from.replaceAll("[\r\n\t ]+LEFT[\r\n\t ]+OUTER[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = from.replaceAll("[\r\n\t ]+RIGHT[\r\n\t ]+OUTER[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = from.replaceAll("[\r\n\t ]+FULL[\r\n\t ]+JOIN[\r\n\t ]+", ", ");
            from = from.replaceAll("[\r\n\t ]+[Oo][Nn][\r\n\t ]+", ON);
            index = from.indexOf(ON);
            while (index != -1) {
                int indexClose = from.indexOf(41);
                int indexNextOn = from.indexOf(ON, index + 4);
                if (indexNextOn != -1) {
                    indexClose = from.lastIndexOf(41, indexNextOn);
                }
                if (indexClose == -1) {
                    this.log.log(Level.SEVERE, "Could not remove ON " + from);
                    break;
                }
                if (index > indexClose) {
                    throw new IllegalStateException("Could not remove (index=" + index + " > indexClose=" + indexClose + ") - " + from);
                }
                from = from.substring(0, index) + from.substring(indexClose + 1);
                index = from.indexOf(ON);
            }
            StringTokenizer tableST = new StringTokenizer(from, ",");
            while (tableST.hasMoreTokens()) {
                String tableString = tableST.nextToken().trim();
                StringTokenizer synST = new StringTokenizer(tableString, " \r\n\t");
                TableInfo tableInfo = null;
                tableInfo = synST.countTokens() > 1 ? new TableInfo(synST.nextToken(), synST.nextToken()) : new TableInfo(tableString);
                list.add(tableInfo);
            }
            sql = sql.substring(0, fromIndex);
            fromIndex = sql.lastIndexOf(FROM);
        }
        TableInfo[] retValue = new TableInfo[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AccessSqlParser[");
        if (this.m_tableInfo == null) {
            sb.append(this.m_sqlOriginal);
        } else {
            for (int i = 0; i < this.m_tableInfo.size(); ++i) {
                if (i > 0) {
                    sb.append("|");
                }
                TableInfo[] info = this.m_tableInfo.get(i);
                for (int ii = 0; ii < info.length; ++ii) {
                    if (ii > 0) {
                        sb.append(",");
                    }
                    sb.append(info[ii].toString());
                }
            }
        }
        sb.append("|").append(this.getMainSqlIndex());
        sb.append("]");
        return sb.toString();
    }

    public TableInfo[] getTableInfo(int index) {
        if (index < 0 || index > this.m_tableInfo.size()) {
            return null;
        }
        TableInfo[] retValue = this.m_tableInfo.get(index);
        return retValue;
    }

    public String getSqlStatement(int index) {
        if (index < 0 || index > this.m_sql.length) {
            return null;
        }
        return this.m_sql[index];
    }

    public int getNoSqlStatments() {
        if (this.m_sql == null) {
            return 0;
        }
        return this.m_sql.length;
    }

    public int getMainSqlIndex() {
        if (this.m_sql == null) {
            return -1;
        }
        if (this.m_sql.length == 1) {
            return 0;
        }
        for (int i = this.m_sql.length - 1; i >= 0; --i) {
            if (this.m_sql[i].charAt(0) == '(') continue;
            return i;
        }
        return -1;
    }

    public String getMainSql() {
        if (this.m_sql == null) {
            return this.m_sqlOriginal;
        }
        if (this.m_sql.length == 1) {
            return this.m_sql[0];
        }
        for (int i = this.m_sql.length - 1; i >= 0; --i) {
            if (this.m_sql[i].charAt(0) == '(') continue;
            return this.m_sql[i];
        }
        return "";
    }

    public class TableInfo {
        private String m_tableName;
        private String m_synonym;

        public TableInfo(String tableName, String synonym) {
            this.m_tableName = tableName;
            this.m_synonym = synonym;
        }

        public TableInfo(String tableName) {
            this(tableName, null);
        }

        public String getSynonym() {
            if (this.m_synonym == null) {
                return "";
            }
            return this.m_synonym;
        }

        public String getTableName() {
            return this.m_tableName;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.m_tableName);
            if (this.getSynonym().length() > 0) {
                sb.append("=").append(this.m_synonym);
            }
            return sb.toString();
        }
    }
}

