/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MRole;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;

public class GridField
implements Serializable,
Evaluatee {
    private static final long serialVersionUID = -6007475135643071025L;
    private GridFieldVO m_vo;
    private char m_mnemonic = '\u0000';
    private GridTab m_gridTab;
    private Lookup m_lookup = null;
    private boolean m_inserting = false;
    public static final int MAXDISPLAY_LENGTH = 60;
    private Object m_value = null;
    private static Object s_oldValue = new Object();
    private Object m_oldValue = s_oldValue;
    private boolean m_valueNoFire = true;
    private boolean m_error = false;
    private Boolean m_parentValue = null;
    private PropertyChangeSupport m_propertyChangeListeners = new PropertyChangeSupport(this);
    public static final String PROPERTY = "FieldValue";
    public static final String INSERTING = "FieldValueInserting";
    private String m_errorValue = null;
    private boolean m_errorValueFlag = false;
    private static CLogger log = CLogger.getCLogger(GridField.class);
    private String m_backupValue = null;
    private boolean m_isBackupValue = false;

    public GridField(GridFieldVO vo) {
        this.m_vo = vo;
        this.loadLookup();
        this.setError(false);
    }

    protected void dispose() {
        this.m_propertyChangeListeners = null;
        if (this.m_lookup != null) {
            this.m_lookup.dispose();
        }
        this.m_lookup = null;
        this.m_vo.lookupInfo = null;
        this.m_vo = null;
    }

    public void loadLookup() {
        if (!this.isLookup()) {
            return;
        }
        log.config("(" + this.m_vo.ColumnName + ")");
        if (DisplayType.isLookup(this.m_vo.displayType) && this.m_vo.IsDisplayed) {
            if (this.m_vo.lookupInfo == null) {
                log.log(Level.SEVERE, "(" + this.m_vo.ColumnName + ") - No LookupInfo");
                return;
            }
            if (this.m_vo.displayType == 18 && (this.m_vo.ColumnName.equals("CreatedBy") || this.m_vo.ColumnName.equals("UpdatedBy"))) {
                this.m_vo.lookupInfo.IsCreadedUpdatedBy = true;
                this.m_vo.lookupInfo.DisplayType = 30;
            }
            this.m_vo.lookupInfo.IsKey = this.isKey();
            MLookup ml = new MLookup(this.m_vo.lookupInfo, this.m_vo.TabNo);
            this.m_lookup = ml;
        } else if (this.m_vo.displayType == 21) {
            MLocationLookup ml = new MLocationLookup(this.m_vo.ctx, this.m_vo.WindowNo);
            this.m_lookup = ml;
        } else if (this.m_vo.displayType == 31) {
            MLocatorLookup ml = new MLocatorLookup(this.m_vo.ctx, this.m_vo.WindowNo);
            this.m_lookup = ml;
        } else if (this.m_vo.displayType == 25) {
            MAccountLookup ma = new MAccountLookup(this.m_vo.ctx, this.m_vo.WindowNo);
            this.m_lookup = ma;
        } else if (this.m_vo.displayType == 35) {
            MPAttributeLookup pa = new MPAttributeLookup(this.m_vo.ctx, this.m_vo.WindowNo);
            this.m_lookup = pa;
        }
    }

    public void lookupLoadComplete() {
        if (this.m_lookup == null) {
            return;
        }
        this.m_lookup.loadComplete();
    }

    public Lookup getLookup() {
        return this.m_lookup;
    }

    public boolean isLookup() {
        boolean retValue = false;
        if (DisplayType.isLookup(this.m_vo.displayType)) {
            retValue = true;
        } else if (this.m_vo.IsKey) {
            retValue = false;
        } else if (this.m_vo.displayType == 21 || this.m_vo.displayType == 31 || this.m_vo.displayType == 25 || this.m_vo.displayType == 35) {
            retValue = true;
        }
        return retValue;
    }

    public boolean refreshLookup() {
        if (this.m_lookup == null || this.m_lookup.getValidation().length() == 0) {
            return true;
        }
        log.fine("(" + this.m_vo.ColumnName + ")");
        this.m_lookup.refresh();
        return this.m_lookup.isValidated();
    }

    public ArrayList<String> getDependentOn() {
        ArrayList<String> list = new ArrayList<String>();
        Evaluator.parseDepends(list, this.m_vo.DisplayLogic);
        Evaluator.parseDepends(list, this.m_vo.ReadOnlyLogic);
        Evaluator.parseDepends(list, this.m_vo.MandatoryLogic);
        if (this.m_lookup != null) {
            Evaluator.parseDepends(list, this.m_lookup.getValidation());
        }
        if (list.size() > 0 && CLogMgt.isLevelFiner()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                sb.append(list.get(i)).append(" ");
            }
            log.finer("(" + this.m_vo.ColumnName + ") " + sb.toString());
        }
        return list;
    }

    public void setError(boolean error) {
        this.m_error = error;
    }

    public boolean isError() {
        return this.m_error;
    }

    public boolean isMandatory(boolean checkContext) {
        if (checkContext && this.m_vo.MandatoryLogic.length() > 0) {
            boolean retValue = Evaluator.evaluateLogic(this, this.m_vo.MandatoryLogic);
            log.finest(this.m_vo.ColumnName + " Mandatory(" + this.m_vo.MandatoryLogic + ") => Mandatory-" + retValue);
            if (retValue) {
                return true;
            }
        }
        if (!this.m_vo.IsMandatory || this.isVirtualColumn()) {
            return false;
        }
        if (this.m_gridTab != null && (this.m_vo.IsKey && this.m_vo.ColumnName.endsWith("_ID") || this.m_vo.ColumnName.startsWith("Created") || this.m_vo.ColumnName.startsWith("Updated") || this.m_vo.ColumnName.equals("Value") || this.m_vo.ColumnName.equals("DocumentNo") || this.m_vo.ColumnName.equals("M_AttributeSetInstance_ID"))) {
            return false;
        }
        return this.isDisplayed(checkContext);
    }

    public boolean isEditablePara(boolean checkContext) {
        if (checkContext && this.m_vo.ReadOnlyLogic.length() > 0) {
            boolean retValue = !Evaluator.evaluateLogic(this, this.m_vo.ReadOnlyLogic);
            log.finest(this.m_vo.ColumnName + " R/O(" + this.m_vo.ReadOnlyLogic + ") => R/W-" + retValue);
            if (!retValue) {
                return false;
            }
        }
        return this.isDisplayed(checkContext);
    }

    public boolean isEditable(boolean checkContext) {
        if (this.isVirtualColumn()) {
            return false;
        }
        if (this.m_vo.ColumnName.equals("Posted") || this.m_vo.ColumnName.equals("Record_ID") && this.m_vo.displayType == 28) {
            return true;
        }
        if (this.m_vo.IsAlwaysUpdateable) {
            return true;
        }
        if (this.m_vo.tabReadOnly || this.m_vo.IsReadOnly) {
            log.finest(this.m_vo.ColumnName + " NO - TabRO=" + this.m_vo.tabReadOnly + ", FieldRO=" + this.m_vo.IsReadOnly);
            return false;
        }
        if (!this.m_vo.IsUpdateable && !this.m_inserting) {
            log.finest(this.m_vo.ColumnName + " NO - FieldUpdateable=" + this.m_vo.IsUpdateable);
            return false;
        }
        if (this.m_vo.ColumnName.equals(Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_LinkColumnName"))) {
            log.finest(this.m_vo.ColumnName + " NO - LinkColumn");
            return false;
        }
        if (checkContext) {
            int AD_Client_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "AD_Client_ID");
            int AD_Org_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "AD_Org_ID");
            String keyColumn = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_KeyColumnName");
            if ("EntityType".equals(keyColumn)) {
                keyColumn = "AD_EntityType_ID";
            }
            if (!keyColumn.endsWith("_ID")) {
                keyColumn = keyColumn + "_ID";
            }
            int Record_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, keyColumn);
            int AD_Table_ID = this.m_vo.AD_Table_ID;
            if (!MRole.getDefault(this.m_vo.ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, AD_Table_ID, Record_ID, false)) {
                return false;
            }
            if (!MRole.getDefault(this.m_vo.ctx, false).isColumnAccess(AD_Table_ID, this.m_vo.AD_Column_ID, false)) {
                return false;
            }
        }
        if (checkContext && this.m_vo.ReadOnlyLogic.length() > 0) {
            boolean retValue = !Evaluator.evaluateLogic(this, this.m_vo.ReadOnlyLogic);
            log.finest(this.m_vo.ColumnName + " R/O(" + this.m_vo.ReadOnlyLogic + ") => R/W-" + retValue);
            if (!retValue) {
                return false;
            }
        }
        if (checkContext && "Y".equals(Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "IsActive")) && (this.m_vo.ColumnName.equals("Processing") || this.m_vo.ColumnName.equals("PaymentRule") || this.m_vo.ColumnName.equals("DocAction") || this.m_vo.ColumnName.equals("GenerateTo"))) {
            return true;
        }
        if (checkContext && ("Y".equals(this.get_ValueAsString("Processed")) || "Y".equals(this.get_ValueAsString("Processing")))) {
            return false;
        }
        if (this.m_vo.ColumnName.equals("IsActive")) {
            return true;
        }
        if (checkContext && !Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "IsActive").equals("Y")) {
            return false;
        }
        return this.isDisplayed(checkContext);
    }

    public void setInserting(boolean inserting) {
        this.m_inserting = inserting;
    }

    public Object getDefault() {
        if (this.m_vo.IsKey || this.m_vo.displayType == 26 || DisplayType.isLOB(this.m_vo.displayType)) {
            return null;
        }
        if (this.isParentValue() && (this.m_vo.DefaultValue == null || this.m_vo.DefaultValue.length() == 0)) {
            String parent = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName);
            log.fine("[Parent] " + this.m_vo.ColumnName + "=" + parent);
            return this.createDefault(parent);
        }
        if (this.m_vo.ColumnName.equals("IsActive")) {
            log.fine("[IsActive] " + this.m_vo.ColumnName + "=Y");
            return "Y";
        }
        if ("4".equals(Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_AccessLevel")) && (this.m_vo.ColumnName.equals("AD_Client_ID") || this.m_vo.ColumnName.equals("AD_Org_ID"))) {
            log.fine("[SystemAccess] " + this.m_vo.ColumnName + "=0");
            return new Integer(0);
        }
        if ("6".equals(Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_AccessLevel")) && this.m_vo.ColumnName.equals("AD_Org_ID")) {
            log.fine("[ClientAccess] " + this.m_vo.ColumnName + "=0");
            return new Integer(0);
        }
        String defStr = "";
        if (this.m_vo.DefaultValue.startsWith("@SQL=")) {
            String sql = this.m_vo.DefaultValue.substring(5);
            if ((sql = Env.parseContext(this.m_vo.ctx, this.m_vo.WindowNo, sql, false, false)).equals("")) {
                log.log(Level.WARNING, "(" + this.m_vo.ColumnName + ") - Default SQL variable parse failed: " + this.m_vo.DefaultValue);
            } else {
                try {
                    CPreparedStatement stmt = DB.prepareStatement(sql, null);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        defStr = rs.getString(1);
                    } else {
                        log.log(Level.WARNING, "(" + this.m_vo.ColumnName + ") - no Result: " + sql);
                    }
                    rs.close();
                    stmt.close();
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, "(" + this.m_vo.ColumnName + ") " + sql, e);
                }
            }
            if (defStr != null && defStr.length() > 0) {
                log.fine("[SQL] " + this.m_vo.ColumnName + "=" + defStr);
                return this.createDefault(defStr);
            }
        }
        if (!this.m_vo.DefaultValue.equals("") && !this.m_vo.DefaultValue.startsWith("@SQL=")) {
            defStr = "";
            StringTokenizer st = new StringTokenizer(this.m_vo.DefaultValue, ",;", false);
            while (st.hasMoreTokens()) {
                defStr = st.nextToken().trim();
                if (defStr.equals("@SysDate@")) {
                    return new Timestamp(System.currentTimeMillis());
                }
                if (defStr.indexOf(64) != -1) {
                    defStr = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, defStr.replace('@', ' ').trim());
                } else if (defStr.indexOf("'") != -1) {
                    defStr = defStr.replace('\'', ' ').trim();
                }
                if (defStr.equals("")) continue;
                log.fine("[DefaultValue] " + this.m_vo.ColumnName + "=" + defStr);
                return this.createDefault(defStr);
            }
        }
        if (!(defStr = Env.getPreference(this.m_vo.ctx, this.m_vo.AD_Window_ID, this.m_vo.ColumnName, false)).equals("")) {
            log.fine("[UserPreference] " + this.m_vo.ColumnName + "=" + defStr);
            return this.createDefault(defStr);
        }
        defStr = Env.getPreference(this.m_vo.ctx, this.m_vo.AD_Window_ID, this.m_vo.ColumnName, true);
        if (!defStr.equals("")) {
            log.fine("[SystemPreference] " + this.m_vo.ColumnName + "=" + defStr);
            return this.createDefault(defStr);
        }
        if (this.m_vo.displayType == 28 && !this.m_vo.ColumnName.endsWith("_ID")) {
            log.fine("[Button=N] " + this.m_vo.ColumnName);
            return "N";
        }
        if (this.m_vo.displayType == 20) {
            log.fine("[YesNo=N] " + this.m_vo.ColumnName);
            return "N";
        }
        if (this.m_vo.ColumnName.endsWith("_ID")) {
            log.fine("[ID=null] " + this.m_vo.ColumnName);
            return null;
        }
        if (DisplayType.isNumeric(this.m_vo.displayType)) {
            log.fine("[Number=0] " + this.m_vo.ColumnName);
            return this.createDefault("0");
        }
        log.fine("[NONE] " + this.m_vo.ColumnName);
        return null;
    }

    /*
     * Exception decompiling
     */
    private Object createDefault(String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean validateValue() {
        if (this.m_value == null || this.m_value.toString().length() == 0) {
            if (this.isMandatory(true)) {
                this.m_error = true;
                return false;
            }
            return true;
        }
        if (this.getDisplayType() == 30 && this.m_lookup != null) {
            if (this.m_lookup.getDirect(this.m_value, false, true) == null) {
                log.finest(this.m_vo.ColumnName + " Serach not valid - set to null");
                this.setValue(null, this.m_inserting);
                this.m_error = true;
                return false;
            }
            return true;
        }
        if (!this.isLookup() || this.m_lookup == null || this.m_lookup.containsKey(this.m_value)) {
            return true;
        }
        if (this.isKey() || this.isParentValue()) {
            return true;
        }
        log.finest(this.m_vo.ColumnName + " - set to null");
        this.setValue(null, this.m_inserting);
        this.m_error = true;
        return false;
    }

    public boolean isDisplayed(boolean checkContext) {
        if (!this.m_vo.IsDisplayed) {
            return false;
        }
        if (this.m_vo.DisplayLogic.equals("")) {
            return true;
        }
        if (checkContext) {
            boolean retValue = Evaluator.evaluateLogic(this, this.m_vo.DisplayLogic);
            log.finest(this.m_vo.ColumnName + " (" + this.m_vo.DisplayLogic + ") => " + retValue);
            return retValue;
        }
        return true;
    }

    public boolean isHideInListView() {
        return this.m_vo.HideInListView;
    }

    public int getPreferredWidthInListView() {
        return this.m_vo.PreferredWidth;
    }

    @Override
    public String get_ValueAsString(String variableName) {
        if (this.m_vo.TabNo == 0) {
            return Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, variableName, true);
        }
        return Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, variableName, false, true);
    }

    public void addDependencies(ArrayList<String> list) {
        if (!this.m_vo.IsDisplayed || this.m_vo.DisplayLogic.equals("")) {
            return;
        }
        StringTokenizer logic = new StringTokenizer(this.m_vo.DisplayLogic.trim(), "&|", false);
        while (logic.hasMoreTokens()) {
            StringTokenizer st = new StringTokenizer(logic.nextToken().trim(), "!=^", false);
            while (st.hasMoreTokens()) {
                String tag = st.nextToken().trim();
                if (tag.indexOf(64) == -1 || list.contains(tag = tag.replace('@', ' ').trim())) continue;
                list.add(tag);
            }
        }
    }

    public String getColumnName() {
        return this.m_vo.ColumnName;
    }

    public String getColumnSQL(boolean withAS) {
        if (this.m_vo.ColumnSQL != null && this.m_vo.ColumnSQL.length() > 0) {
            if (withAS) {
                return this.m_vo.ColumnSQL + " AS " + this.m_vo.ColumnName;
            }
            return this.m_vo.ColumnSQL;
        }
        return this.m_vo.ColumnName;
    }

    public boolean isVirtualColumn() {
        return this.m_vo.ColumnSQL != null && this.m_vo.ColumnSQL.length() > 0;
    }

    public String getHeader() {
        return this.m_vo.Header;
    }

    public int getDisplayType() {
        return this.m_vo.displayType;
    }

    public int getAD_Reference_Value_ID() {
        return this.m_vo.AD_Reference_Value_ID;
    }

    public int getAD_Window_ID() {
        return this.m_vo.AD_Window_ID;
    }

    public int getWindowNo() {
        return this.m_vo.WindowNo;
    }

    public int getAD_Column_ID() {
        return this.m_vo.AD_Column_ID;
    }

    public int getDisplayLength() {
        return this.m_vo.DisplayLength;
    }

    public boolean isSameLine() {
        return this.m_vo.IsSameLine;
    }

    public boolean isDisplayed() {
        return this.m_vo.IsDisplayed;
    }

    public String getDisplayLogic() {
        return this.m_vo.DisplayLogic;
    }

    public String getDefaultValue() {
        return this.m_vo.DefaultValue;
    }

    public boolean isReadOnly() {
        if (this.isVirtualColumn()) {
            return true;
        }
        return this.m_vo.IsReadOnly;
    }

    public boolean isUpdateable() {
        if (this.isVirtualColumn()) {
            return false;
        }
        return this.m_vo.IsUpdateable;
    }

    public boolean isAutocomplete() {
        return this.m_vo.IsAutocomplete;
    }

    public boolean isAlwaysUpdateable() {
        if (this.isVirtualColumn() || !this.m_vo.IsUpdateable) {
            return false;
        }
        return this.m_vo.IsAlwaysUpdateable;
    }

    public boolean isHeading() {
        return this.m_vo.IsHeading;
    }

    public boolean isFieldOnly() {
        return this.m_vo.IsFieldOnly;
    }

    public boolean isEncryptedField() {
        return this.m_vo.IsEncryptedField;
    }

    public boolean isEncrypted() {
        if (this.m_vo.IsEncryptedField) {
            return true;
        }
        String ob = this.getObscureType();
        if (ob != null && ob.length() > 0) {
            return true;
        }
        return this.m_vo.ColumnName.equals("Password");
    }

    public boolean isEncryptedColumn() {
        return this.m_vo.IsEncryptedColumn;
    }

    public boolean isSelectionColumn() {
        return this.m_vo.IsSelectionColumn;
    }

    public String getObscureType() {
        return this.m_vo.ObscureType;
    }

    public int getSortNo() {
        return this.m_vo.SortNo;
    }

    public int getFieldLength() {
        return this.m_vo.FieldLength;
    }

    public String getVFormat() {
        return this.m_vo.VFormat;
    }

    public String getValueMin() {
        return this.m_vo.ValueMin;
    }

    public String getValueMax() {
        return this.m_vo.ValueMax;
    }

    public String getFieldGroup() {
        return this.m_vo.FieldGroup;
    }

    public String getFieldGroupType() {
        return this.m_vo.FieldGroupType;
    }

    public boolean isKey() {
        return this.m_vo.IsKey;
    }

    public boolean isParentColumn() {
        return this.m_vo.IsParent;
    }

    public boolean isParentValue() {
        if (this.m_parentValue != null) {
            return this.m_parentValue;
        }
        if (!DisplayType.isID(this.m_vo.displayType) || this.m_vo.TabNo == 0) {
            this.m_parentValue = Boolean.FALSE;
        } else {
            String LinkColumnName = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_LinkColumnName");
            this.m_parentValue = LinkColumnName == null || LinkColumnName.length() == 0 ? Boolean.FALSE : Boolean.valueOf(this.m_vo.ColumnName.equals(LinkColumnName));
            if (this.m_parentValue.booleanValue()) {
                log.config(this.m_parentValue + " - Link(" + LinkColumnName + ", W=" + this.m_vo.WindowNo + ",T=" + this.m_vo.TabNo + ") = " + this.m_vo.ColumnName);
            } else {
                this.m_parentValue = this.isIndirectParentValue();
            }
        }
        return this.m_parentValue;
    }

    public String getCallout() {
        return this.m_vo.Callout;
    }

    public int getAD_Process_ID() {
        return this.m_vo.AD_Process_ID;
    }

    public String getDescription() {
        return this.m_vo.Description;
    }

    public String getHelp() {
        return this.m_vo.Help;
    }

    public int getAD_Tab_ID() {
        return this.m_vo.AD_Tab_ID;
    }

    public GridFieldVO getVO() {
        return this.m_vo;
    }

    public boolean isLongField() {
        return this.m_vo.DisplayLength >= 30;
    }

    public void setValue() {
        if (this.m_valueNoFire) {
            this.m_oldValue = this.m_value;
        }
        this.m_value = null;
        this.m_inserting = false;
        this.m_error = false;
        this.m_propertyChangeListeners.firePropertyChange(PROPERTY, this.m_oldValue, this.m_value);
    }

    public void setValueAndUpdateContext() {
        if (this.m_valueNoFire) {
            this.m_oldValue = this.m_value;
        }
        this.m_value = null;
        this.m_inserting = false;
        this.m_error = false;
        Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, (String)this.m_value);
        this.m_propertyChangeListeners.firePropertyChange(PROPERTY, this.m_oldValue, this.m_value);
    }

    public void setValue(Object newValue, boolean inserting) {
        if (this.m_valueNoFire) {
            this.m_oldValue = this.m_value;
        }
        this.m_value = newValue;
        this.m_inserting = inserting;
        this.m_error = false;
        this.updateContext();
        Object oldValue = this.m_oldValue;
        if (inserting) {
            oldValue = INSERTING;
        }
        this.m_propertyChangeListeners.firePropertyChange(PROPERTY, oldValue, this.m_value);
    }

    public void updateContext() {
        if (this.m_vo.displayType != 14 && this.m_vo.displayType != 34 && this.m_vo.displayType != 36 && this.m_vo.displayType != 23 && this.m_vo.displayType != 26 && !this.isEncrypted()) {
            if (this.m_value instanceof Boolean) {
                this.backupValue();
                if (!this.isParentTabField()) {
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, (Boolean)this.m_value);
                }
                Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName, this.m_value == null ? null : ((Boolean)this.m_value != false ? "Y" : "N"));
            } else if (this.m_value instanceof Timestamp) {
                this.backupValue();
                if (!this.isParentTabField()) {
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, (Timestamp)this.m_value);
                }
                String stringValue = null;
                if (this.m_value != null && !this.m_value.toString().equals("")) {
                    Calendar c1 = Calendar.getInstance();
                    c1.setTime((Date)this.m_value);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    stringValue = sdf.format(c1.getTime());
                }
                Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName, stringValue);
            } else {
                this.backupValue();
                if (!this.isParentTabField()) {
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, this.m_value == null ? null : this.m_value.toString());
                }
                Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName, this.m_value == null ? null : this.m_value.toString());
            }
        }
    }

    public String setValueValidate(String newValue, boolean inserting) {
        if (newValue == null) {
            this.setValue();
        }
        int dt = this.getDisplayType();
        try {
            if (!(dt == 11 || DisplayType.isID(dt) && this.getColumnName().endsWith("_ID"))) {
                if (DisplayType.isNumeric(dt)) {
                    BigDecimal value = (BigDecimal)DisplayType.getNumberFormat(dt).parse(newValue);
                    this.setValue(value, inserting);
                    return null;
                }
                if (DisplayType.isDate(dt)) {
                    long time = DisplayType.getDateFormat_JDBC().parse(newValue).getTime();
                    this.setValue(new Timestamp(time), inserting);
                    return null;
                }
                if (dt == 20) {
                    Boolean value = null;
                    if (newValue.equals("Y")) {
                        value = Boolean.TRUE;
                    } else if (newValue.equals("N")) {
                        value = Boolean.FALSE;
                    } else {
                        return this.getColumnName() + " = " + newValue + " - Must be Y/N";
                    }
                    this.setValue(value, inserting);
                    return null;
                }
                if (DisplayType.isText(dt)) {
                    this.setValue(newValue, inserting);
                    return null;
                }
                return this.getColumnName() + " not mapped " + DisplayType.getDescription(dt);
            }
            int i = Integer.parseInt(newValue);
            this.setValue(new Integer(i), inserting);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Value=" + newValue, ex);
            String error = ex.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = ex.toString();
            }
            return this.getColumnName() + " = " + newValue + " - " + error;
        }
        if (!DisplayType.isID(dt)) {
            return null;
        }
        return null;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValueNoFire(boolean value) {
        this.m_valueNoFire = value;
    }

    public Object getOldValue() {
        return this.m_oldValue;
    }

    public void setErrorValue(String errorValue) {
        this.m_errorValue = errorValue;
        this.m_errorValueFlag = true;
    }

    public String getErrorValue() {
        String s = this.m_errorValue;
        this.m_errorValue = null;
        this.m_errorValueFlag = false;
        return s;
    }

    public boolean isErrorValue() {
        boolean b = this.m_errorValueFlag;
        this.m_errorValueFlag = false;
        return b;
    }

    public void setDisplayLength(int length) {
        this.m_vo.DisplayLength = length;
    }

    public void setDisplayed(boolean displayed) {
        this.m_vo.IsDisplayed = displayed;
    }

    public boolean isCreateMnemonic() {
        return !this.isReadOnly() && !this.m_vo.ColumnName.equals("AD_Client_ID") && !this.m_vo.ColumnName.equals("AD_Org_ID") && !this.m_vo.ColumnName.equals("DocumentNo");
    }

    public char getMnemonic() {
        return this.m_mnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.m_mnemonic = mnemonic;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GridField[").append(this.m_vo.ColumnName).append("=").append(this.m_value);
        if (this.isKey()) {
            sb.append("(Key)");
        }
        if (this.isParentColumn()) {
            sb.append("(Parent)");
        }
        sb.append(", IsDisplayed=" + this.m_vo.IsDisplayed);
        sb.append("]");
        return sb.toString();
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer("MField[");
        sb.append(this.m_vo.ColumnName).append("=").append(this.m_value).append(",DisplayType=").append(this.getDisplayType()).append("]");
        return sb.toString();
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeListeners.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeListeners.addPropertyChangeListener(l);
    }

    public static GridField[] createFields(Properties ctx, int WindowNo, int TabNo, int AD_Tab_ID) {
        ArrayList<GridFieldVO> listVO = new ArrayList<GridFieldVO>();
        int AD_Window_ID = 0;
        boolean readOnly = false;
        String sql = GridFieldVO.getSQL(ctx);
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Tab_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                GridFieldVO vo = GridFieldVO.create(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, readOnly, rs);
                listVO.add(vo);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        GridField[] retValue = new GridField[listVO.size()];
        for (int i = 0; i < listVO.size(); ++i) {
            retValue[i] = new GridField((GridFieldVO)listVO.get(i));
        }
        return retValue;
    }

    private boolean isIndirectParentValue() {
        boolean result = false;
        int tabNo = this.m_vo.TabNo;
        int currentLevel = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, tabNo, "_TabInfo_TabLevel");
        if (tabNo > 1 && currentLevel > 1) {
            while (tabNo >= 1 && !result) {
                int level;
                if ((level = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, --tabNo, "_TabInfo_TabLevel")) <= 0 || level >= currentLevel) continue;
                String linkColumn = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, tabNo, "_TabInfo_LinkColumnName");
                if (this.m_vo.ColumnName.equals(linkColumn)) {
                    result = true;
                    log.config(result + " - Link(" + linkColumn + ", W=" + this.m_vo.WindowNo + ",T=" + this.m_vo.TabNo + ") = " + this.m_vo.ColumnName);
                }
                currentLevel = level;
            }
        }
        return result;
    }

    private final void backupValue() {
        if (!this.m_isBackupValue) {
            this.m_backupValue = this.get_ValueAsString(this.m_vo.ColumnName);
            if (CLogMgt.isLevelFinest()) {
                log.finest("Backup " + this.m_vo.WindowNo + "|" + this.m_vo.ColumnName + "=" + this.m_backupValue);
            }
            this.m_isBackupValue = true;
        }
    }

    public void restoreValue() {
        if (this.m_isBackupValue) {
            if (this.isParentTabField()) {
                if (CLogMgt.isLevelFinest()) {
                    log.finest("Restore " + this.m_vo.WindowNo + "|" + this.m_vo.TabNo + "|" + this.m_vo.ColumnName + "=" + this.m_backupValue);
                }
                Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName, this.m_backupValue);
            } else {
                if (CLogMgt.isLevelFinest()) {
                    log.finest("Restore " + this.m_vo.WindowNo + "|" + this.m_vo.ColumnName + "=" + this.m_backupValue);
                }
                Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, this.m_backupValue);
            }
        }
    }

    public void setVFormat(String strNewFormat) {
        this.m_vo.VFormat = strNewFormat;
    }

    public int getIncluded_Tab_ID() {
        return this.m_vo.Included_Tab_ID;
    }

    public void setIsCollapsedByDefault(boolean flag) {
        this.m_vo.IsCollapsedByDefault = flag;
    }

    public boolean getIsCollapsedByDefault() {
        return this.m_vo.IsCollapsedByDefault;
    }

    public List<String> getEntries() {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "";
        try {
            String tableName = null;
            String columnName = null;
            int AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
            int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
            sql = "SELECT t.TableName, c.ColumnName  FROM AD_COLUMN c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE AD_Column_ID=?";
            CPreparedStatement pstmt1 = DB.prepareStatement(sql, null);
            pstmt1.setInt(1, this.getAD_Column_ID());
            ResultSet rs1 = pstmt1.executeQuery();
            if (rs1.next()) {
                tableName = rs1.getString(1);
                columnName = rs1.getString(2);
            }
            DB.close(rs1, pstmt1);
            if (tableName != null && columnName != null) {
                sql = "SELECT DISTINCT " + columnName + " FROM " + tableName + " WHERE AD_Client_ID=? " + " AND AD_Org_ID=?";
                CPreparedStatement pstmt2 = DB.prepareStatement(sql, null);
                pstmt2.setInt(1, AD_Client_ID);
                pstmt2.setInt(2, AD_Org_ID);
                ResultSet rs2 = pstmt2.executeQuery();
                while (rs2.next()) {
                    list.add(rs2.getString(1));
                }
                DB.close(rs2, pstmt2);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        return list;
    }

    public void setGridTab(GridTab gridTab) {
        this.m_gridTab = gridTab;
    }

    public GridTab getGridTab() {
        return this.m_gridTab;
    }

    private boolean isParentTabField(String columnName) {
        if (this.m_gridTab == null) {
            return false;
        }
        if (!this.m_gridTab.isIncluded()) {
            return false;
        }
        GridTab parentTab = this.m_gridTab.getParentTab();
        if (parentTab == null) {
            return false;
        }
        return parentTab.getField(columnName) != null;
    }

    private boolean isParentTabField() {
        return this.isParentTabField(this.m_vo.ColumnName);
    }
}

