/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class GridFieldVO
implements Serializable {
    public String InfoFactoryClass = null;
    static final long serialVersionUID = 4385061125114436797L;
    public Properties ctx = null;
    public int WindowNo;
    public int TabNo;
    public int AD_Window_ID;
    public int AD_Tab_ID;
    public boolean tabReadOnly = false;
    public boolean isProcess = false;
    public String ColumnName = "";
    public String ColumnSQL;
    public String Header = "";
    public int displayType = 0;
    public int AD_Table_ID = 0;
    public int AD_Column_ID = 0;
    public int DisplayLength = 0;
    public boolean IsSameLine = false;
    public boolean IsDisplayed = false;
    public boolean HideInListView = false;
    public int PreferredWidth = 0;
    public String DisplayLogic = "";
    public String DefaultValue = "";
    public boolean IsMandatory = false;
    public boolean IsReadOnly = false;
    public boolean IsUpdateable = false;
    public boolean IsAlwaysUpdateable = false;
    public boolean IsHeading = false;
    public boolean IsFieldOnly = false;
    public boolean IsEncryptedField = false;
    public boolean IsEncryptedColumn = false;
    public boolean IsSelectionColumn = false;
    public int SortNo = 0;
    public int FieldLength = 0;
    public String VFormat = "";
    public String ValueMin = "";
    public String ValueMax = "";
    public String FieldGroup = "";
    public String FieldGroupType = "";
    public boolean IsKey = false;
    public boolean IsParent = false;
    public String Callout = "";
    public int AD_Process_ID = 0;
    public String Description = "";
    public String Help = "";
    public String MandatoryLogic = "";
    public String ReadOnlyLogic = "";
    public String ObscureType = null;
    public String ValidationCode = "";
    public int AD_Reference_Value_ID = 0;
    public boolean isRange = false;
    public String DefaultValue2 = "";
    public MLookupInfo lookupInfo = null;
    public int Included_Tab_ID = 0;
    public boolean IsCollapsedByDefault = false;
    public boolean IsAutocomplete = false;

    public static String getSQL(Properties ctx) {
        String sql = "SELECT * FROM AD_Field_v WHERE AD_Tab_ID=? ORDER BY IsDisplayed DESC, SeqNo";
        if (!Env.isBaseLanguage(ctx, "AD_Tab")) {
            sql = "SELECT * FROM AD_Field_vt WHERE AD_Tab_ID=? AND AD_Language='" + Env.getAD_Language(ctx) + "'" + " ORDER BY IsDisplayed DESC, SeqNo";
        }
        return sql;
    }

    public static GridFieldVO create(Properties ctx, int WindowNo, int TabNo, int AD_Window_ID, int AD_Tab_ID, boolean readOnly, ResultSet rs) {
        MClient client;
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, readOnly);
        String columnName = "ColumnName";
        int AD_Field_ID = 0;
        try {
            vo.ColumnName = rs.getString("ColumnName");
            if (vo.ColumnName == null) {
                return null;
            }
            CLogger.get().fine(vo.ColumnName);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                columnName = rsmd.getColumnName(i);
                if (columnName.equalsIgnoreCase("Name")) {
                    vo.Header = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Reference_ID")) {
                    vo.displayType = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Column_ID")) {
                    vo.AD_Column_ID = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Table_ID")) {
                    vo.AD_Table_ID = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("DisplayLength")) {
                    vo.DisplayLength = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsSameLine")) {
                    vo.IsSameLine = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsDisplayed")) {
                    vo.IsDisplayed = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("DisplayLogic")) {
                    vo.DisplayLogic = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("DefaultValue")) {
                    vo.DefaultValue = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsMandatory")) {
                    vo.IsMandatory = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsReadOnly")) {
                    vo.IsReadOnly = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsUpdateable")) {
                    vo.IsUpdateable = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsAlwaysUpdateable")) {
                    vo.IsAlwaysUpdateable = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsHeading")) {
                    vo.IsHeading = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsFieldOnly")) {
                    vo.IsFieldOnly = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsEncryptedField")) {
                    vo.IsEncryptedField = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsEncryptedColumn")) {
                    vo.IsEncryptedColumn = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsSelectionColumn")) {
                    vo.IsSelectionColumn = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("SortNo")) {
                    vo.SortNo = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("FieldLength")) {
                    vo.FieldLength = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("VFormat")) {
                    vo.VFormat = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ValueMin")) {
                    vo.ValueMin = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ValueMax")) {
                    vo.ValueMax = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("FieldGroup")) {
                    vo.FieldGroup = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("FieldGroupType")) {
                    vo.FieldGroupType = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsKey")) {
                    vo.IsKey = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsParent")) {
                    vo.IsParent = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("Description")) {
                    vo.Description = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("Help")) {
                    vo.Help = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("Callout")) {
                    vo.Callout = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Process_ID")) {
                    vo.AD_Process_ID = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ReadOnlyLogic")) {
                    vo.ReadOnlyLogic = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("MandatoryLogic")) {
                    vo.MandatoryLogic = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ObscureType")) {
                    vo.ObscureType = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Reference_Value_ID")) {
                    vo.AD_Reference_Value_ID = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ValidationCode")) {
                    vo.ValidationCode = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ColumnSQL")) {
                    vo.ColumnSQL = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("Included_Tab_ID")) {
                    vo.Included_Tab_ID = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsCollapsedByDefault")) {
                    vo.IsCollapsedByDefault = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("InfoFactoryClass")) {
                    vo.InfoFactoryClass = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsAutocomplete")) {
                    vo.IsAutocomplete = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("HideInListView")) {
                    vo.HideInListView = "Y".equals(rs.getString(i));
                    continue;
                }
                if (!columnName.equalsIgnoreCase("PreferredWidth")) continue;
                vo.PreferredWidth = rs.getInt(i);
            }
            if (vo.Header == null) {
                vo.Header = vo.ColumnName;
            }
            AD_Field_ID = rs.getInt("AD_Field_ID");
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, "ColumnName=" + columnName, e);
            return null;
        }
        if (vo.IsDisplayed && !(client = MClient.get(ctx)).isDisplayField(AD_Field_ID)) {
            vo.IsDisplayed = false;
        }
        vo.initFinish();
        return vo;
    }

    public static GridFieldVO createParameter(Properties ctx, int WindowNo, ResultSet rs) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, 0, 0, 0, false);
        vo.isProcess = true;
        vo.IsDisplayed = true;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        try {
            vo.AD_Table_ID = 0;
            vo.AD_Column_ID = rs.getInt("AD_Process_Para_ID");
            vo.ColumnName = rs.getString("ColumnName");
            vo.Header = rs.getString("Name");
            vo.Description = rs.getString("Description");
            vo.Help = rs.getString("Help");
            vo.displayType = rs.getInt("AD_Reference_ID");
            vo.IsMandatory = rs.getString("IsMandatory").equals("Y");
            vo.DisplayLength = vo.FieldLength = rs.getInt("FieldLength");
            vo.DefaultValue = rs.getString("DefaultValue");
            vo.DefaultValue2 = rs.getString("DefaultValue2");
            vo.VFormat = rs.getString("VFormat");
            vo.ValueMin = rs.getString("ValueMin");
            vo.ValueMax = rs.getString("ValueMax");
            vo.isRange = rs.getString("IsRange").equals("Y");
            vo.AD_Reference_Value_ID = rs.getInt("AD_Reference_Value_ID");
            vo.ValidationCode = rs.getString("ValidationCode");
            vo.ReadOnlyLogic = rs.getString("ReadOnlyLogic");
            vo.DisplayLogic = rs.getString("DisplayLogic");
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, "createParameter", e);
        }
        vo.initFinish();
        if (vo.DefaultValue2 == null) {
            vo.DefaultValue2 = "";
        }
        return vo;
    }

    public static GridFieldVO createParameter(GridFieldVO voF) {
        GridFieldVO voT = new GridFieldVO(voF.ctx, voF.WindowNo, voF.TabNo, voF.AD_Window_ID, voF.AD_Tab_ID, voF.tabReadOnly);
        voT.isProcess = true;
        voT.IsDisplayed = true;
        voT.IsReadOnly = false;
        voT.IsUpdateable = true;
        voT.AD_Table_ID = voF.AD_Table_ID;
        voT.AD_Column_ID = voF.AD_Column_ID;
        voT.ColumnName = voF.ColumnName;
        voT.Header = voF.Header;
        voT.Description = voF.Description;
        voT.Help = voF.Help;
        voT.displayType = voF.displayType;
        voT.IsMandatory = voF.IsMandatory;
        voT.FieldLength = voF.FieldLength;
        voT.DisplayLength = voF.FieldLength;
        voT.DefaultValue = voF.DefaultValue2;
        voT.VFormat = voF.VFormat;
        voT.ValueMin = voF.ValueMin;
        voT.ValueMax = voF.ValueMax;
        voT.isRange = voF.isRange;
        voT.AD_Reference_Value_ID = voF.AD_Reference_Value_ID;
        voT.initFinish();
        return voT;
    }

    public static GridFieldVO createStdField(Properties ctx, int WindowNo, int TabNo, int AD_Window_ID, int AD_Tab_ID, boolean tabReadOnly, boolean isCreated, boolean isTimestamp) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, tabReadOnly);
        String string = vo.ColumnName = isCreated ? "Created" : "Updated";
        if (!isTimestamp) {
            vo.ColumnName = vo.ColumnName + "By";
        }
        int n = vo.displayType = isTimestamp ? 16 : 18;
        if (!isTimestamp) {
            vo.AD_Reference_Value_ID = 110;
        }
        vo.IsDisplayed = false;
        vo.IsMandatory = false;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        vo.initFinish();
        return vo;
    }

    private GridFieldVO(Properties Ctx, int windowNo, int tabNo, int ad_Window_ID, int ad_Tab_ID, boolean TabReadOnly) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
        this.TabNo = tabNo;
        this.AD_Window_ID = ad_Window_ID;
        this.AD_Tab_ID = ad_Tab_ID;
        this.tabReadOnly = TabReadOnly;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        if (this.lookupInfo != null) {
            this.lookupInfo.ctx = newCtx;
        }
    }

    protected void initFinish() {
        if (this.DisplayLogic == null) {
            this.DisplayLogic = "";
        }
        if (this.DefaultValue == null) {
            this.DefaultValue = "";
        }
        if (this.FieldGroup == null) {
            this.FieldGroup = "";
        }
        if (this.FieldGroupType == null) {
            this.FieldGroupType = "";
        }
        if (this.Description == null) {
            this.Description = "";
        }
        if (this.Help == null) {
            this.Help = "";
        }
        if (this.Callout == null) {
            this.Callout = "";
        }
        if (this.ReadOnlyLogic == null) {
            this.ReadOnlyLogic = "";
        }
        if (this.MandatoryLogic == null) {
            this.MandatoryLogic = "";
        }
        if (DisplayType.isLookup(this.displayType) && this.IsDisplayed) {
            try {
                this.lookupInfo = MLookupFactory.getLookupInfo(this.ctx, this.WindowNo, this.AD_Column_ID, this.displayType, Env.getLanguage(this.ctx), this.ColumnName, this.AD_Reference_Value_ID, this.IsParent, this.ValidationCode);
                this.lookupInfo.InfoFactoryClass = this.InfoFactoryClass;
            }
            catch (Exception e) {
                CLogger.get().log(Level.SEVERE, "No LookupInfo for " + this.ColumnName, e);
                this.displayType = 13;
            }
        }
    }

    public GridFieldVO clone(Properties Ctx, int windowNo, int tabNo, int ad_Window_ID, int ad_Tab_ID, boolean TabReadOnly) {
        GridFieldVO clone = new GridFieldVO(Ctx, windowNo, tabNo, ad_Window_ID, ad_Tab_ID, TabReadOnly);
        clone.isProcess = false;
        clone.ColumnName = this.ColumnName;
        clone.ColumnSQL = this.ColumnSQL;
        clone.Header = this.Header;
        clone.displayType = this.displayType;
        clone.AD_Table_ID = this.AD_Table_ID;
        clone.AD_Column_ID = this.AD_Column_ID;
        clone.DisplayLength = this.DisplayLength;
        clone.IsSameLine = this.IsSameLine;
        clone.IsDisplayed = this.IsDisplayed;
        clone.HideInListView = this.HideInListView;
        clone.PreferredWidth = this.PreferredWidth;
        clone.DisplayLogic = this.DisplayLogic;
        clone.DefaultValue = this.DefaultValue;
        clone.IsMandatory = this.IsMandatory;
        clone.IsReadOnly = this.IsReadOnly;
        clone.IsUpdateable = this.IsUpdateable;
        clone.IsAlwaysUpdateable = this.IsAlwaysUpdateable;
        clone.IsHeading = this.IsHeading;
        clone.IsFieldOnly = this.IsFieldOnly;
        clone.IsEncryptedField = this.IsEncryptedField;
        clone.IsEncryptedColumn = this.IsEncryptedColumn;
        clone.IsSelectionColumn = this.IsSelectionColumn;
        clone.IsAutocomplete = this.IsAutocomplete;
        clone.SortNo = this.SortNo;
        clone.FieldLength = this.FieldLength;
        clone.VFormat = this.VFormat;
        clone.ValueMin = this.ValueMin;
        clone.ValueMax = this.ValueMax;
        clone.FieldGroup = this.FieldGroup;
        clone.FieldGroupType = this.FieldGroupType;
        clone.IsKey = this.IsKey;
        clone.IsParent = this.IsParent;
        clone.Callout = this.Callout;
        clone.AD_Process_ID = this.AD_Process_ID;
        clone.Description = this.Description;
        clone.Help = this.Help;
        clone.ReadOnlyLogic = this.ReadOnlyLogic;
        clone.MandatoryLogic = this.MandatoryLogic;
        clone.ObscureType = this.ObscureType;
        clone.ValidationCode = this.ValidationCode;
        clone.AD_Reference_Value_ID = this.AD_Reference_Value_ID;
        clone.lookupInfo = this.lookupInfo;
        clone.isRange = this.isRange;
        clone.DefaultValue2 = this.DefaultValue2;
        return clone;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MFieldVO[");
        sb.append(this.AD_Column_ID).append("-").append(this.ColumnName).append("]");
        return sb.toString();
    }
}

