/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAlert;
import org.compiere.model.MRole;
import org.compiere.model.X_AD_AlertRule;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class MAlertRule
extends X_AD_AlertRule {
    private static final long serialVersionUID = -1267260460210893262L;
    private MAlert m_parent = null;

    public MAlertRule(Properties ctx, int AD_AlertRule_ID, String trxName) {
        super(ctx, AD_AlertRule_ID, trxName);
    }

    public MAlertRule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAlert getParent() {
        if (this.m_parent == null || this.m_parent.get_ID() != this.getAD_Alert_ID()) {
            this.m_parent = new MAlert(this.getCtx(), this.getAD_Alert_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setParent(MAlert alert) {
        this.m_parent = alert;
    }

    public String getSql() {
        return this.getSql(false);
    }

    public String getSql(boolean applySecurity) {
        MAlert alert;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ").append(this.getSelectClause()).append(" FROM ").append(this.getFromClause());
        if (this.getWhereClause() != null && this.getWhereClause().length() > 0) {
            sql.append(" WHERE ").append(this.getWhereClause());
        }
        String finalSQL = sql.toString();
        if (applySecurity && ((alert = this.getParent()).isEnforceRoleSecurity() || alert.isEnforceClientSecurity())) {
            int AD_Role_ID = alert.getFirstAD_Role_ID();
            if (AD_Role_ID == -1) {
                AD_Role_ID = alert.getFirstUserAD_Role_ID();
            }
            if (AD_Role_ID != -1) {
                MRole role = MRole.get(this.getCtx(), AD_Role_ID);
                finalSQL = role.addAccessSQL(finalSQL, null, true, false);
            }
        }
        if (this.getOtherClause() != null && this.getOtherClause().length() > 0) {
            finalSQL = finalSQL + " " + this.getOtherClause();
        }
        return finalSQL;
    }

    public File createReportFile(String extension) {
        if (Util.isEmpty(extension)) {
            throw new IllegalArgumentException("Parameter extension cannot be empty");
        }
        String name = new SimpleDateFormat("yyyyMMddhhmm").format(new Timestamp(System.currentTimeMillis())) + "_" + Util.stripDiacritics(this.getName().trim());
        File file = null;
        try {
            file = new File(System.getProperty("java.io.tmpdir"), name + "." + extension);
            file.createNewFile();
            return file;
        }
        catch (Exception e) {
            file = null;
            String filePrefix = "Alert_";
            try {
                file = File.createTempFile(filePrefix, "." + extension);
            }
            catch (IOException e2) {
                throw new AdempiereException(e2);
            }
            return file;
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            this.setIsValid(true);
        }
        if (this.isValid()) {
            this.setErrorMsg(null);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        return this.updateParent();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return false;
        }
        return this.updateParent();
    }

    private boolean updateParent() {
        String sql_count = "SELECT COUNT(*) FROM AD_AlertRule r WHERE r.AD_Alert_ID=a.AD_Alert_ID AND r.IsValid='N' AND r.IsActive='Y'";
        String sql = "UPDATE AD_Alert a SET  IsValid=(CASE WHEN (SELECT COUNT(*) FROM AD_AlertRule r WHERE r.AD_Alert_ID=a.AD_Alert_ID AND r.IsValid='N' AND r.IsActive='Y') > 0 THEN 'N' ELSE 'Y' END) WHERE a.AD_Alert_ID=?";
        int no = DB.executeUpdate("UPDATE AD_Alert a SET  IsValid=(CASE WHEN (SELECT COUNT(*) FROM AD_AlertRule r WHERE r.AD_Alert_ID=a.AD_Alert_ID AND r.IsValid='N' AND r.IsActive='Y') > 0 THEN 'N' ELSE 'Y' END) WHERE a.AD_Alert_ID=?", this.getAD_Alert_ID(), this.get_TrxName());
        return no == 1;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAlertRule[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Valid=").append(this.isValid()).append(",").append(this.getSql(false));
        sb.append("]");
        return sb.toString();
    }
}

