/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostQueue;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCosting;
import org.compiere.model.MProductPO;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.model.X_M_Cost;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class MCost
extends X_M_Cost {
    private static final long serialVersionUID = -127982599769472918L;
    private static CLogger s_log = CLogger.getCLogger(MCost.class);
    private boolean m_manual = true;

    public static BigDecimal getCurrentCost(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, String costingMethod, BigDecimal qty, int C_OrderLine_ID, boolean zeroCostsOK, String trxName) {
        String CostingLevel = product.getCostingLevel(as);
        if ("C".equals(CostingLevel)) {
            AD_Org_ID = 0;
            M_AttributeSetInstance_ID = 0;
        } else if ("O".equals(CostingLevel)) {
            M_AttributeSetInstance_ID = 0;
        } else if ("B".equals(CostingLevel)) {
            AD_Org_ID = 0;
        }
        if (costingMethod == null && (costingMethod = product.getCostingMethod(as)) == null) {
            throw new IllegalArgumentException("No Costing Method");
        }
        MCostDetail.processProduct(product, trxName);
        return MCost.getCurrentCost(product, M_AttributeSetInstance_ID, as, AD_Org_ID, as.getM_CostType_ID(), costingMethod, qty, C_OrderLine_ID, zeroCostsOK, trxName);
    }

    private static BigDecimal getCurrentCost(MProduct product, int M_ASI_ID, MAcctSchema as, int Org_ID, int M_CostType_ID, String costingMethod, BigDecimal qty, int C_OrderLine_ID, boolean zeroCostsOK, String trxName) {
        BigDecimal otherCost;
        BigDecimal costs;
        String costElementType = null;
        BigDecimal percent = null;
        BigDecimal materialCostEach = Env.ZERO;
        BigDecimal otherCostEach = Env.ZERO;
        BigDecimal percentage = Env.ZERO;
        int count = 0;
        String sql = "SELECT COALESCE(SUM(c.CurrentCostPrice),0), ce.CostElementType, ce.CostingMethod, c.Percent, c.M_CostElement_ID , COALESCE(SUM(c.CurrentCostPriceLL),0)  FROM M_Cost c LEFT OUTER JOIN M_CostElement ce ON (c.M_CostElement_ID=ce.M_CostElement_ID) WHERE c.AD_Client_ID=? AND c.AD_Org_ID=? AND c.M_Product_ID=? AND (c.M_AttributeSetInstance_ID=? OR c.M_AttributeSetInstance_ID=0) AND c.M_CostType_ID=? AND c.C_AcctSchema_ID=? AND (ce.CostingMethod IS NULL OR ce.CostingMethod=?) GROUP BY ce.CostElementType, ce.CostingMethod, c.Percent, c.M_CostElement_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, product.getAD_Client_ID());
            pstmt.setInt(2, Org_ID);
            pstmt.setInt(3, product.getM_Product_ID());
            pstmt.setInt(4, M_ASI_ID);
            pstmt.setInt(5, M_CostType_ID);
            pstmt.setInt(6, as.getC_AcctSchema_ID());
            pstmt.setString(7, costingMethod);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal currentCostPrice = rs.getBigDecimal(1);
                BigDecimal currentCostPriceLL = rs.getBigDecimal(6);
                costElementType = rs.getString(2);
                String cm = rs.getString(3);
                percent = rs.getBigDecimal(4);
                s_log.finest("CurrentCostPrice=" + currentCostPrice + ", CurrentCostPriceLL=" + currentCostPriceLL + ", CostElementType=" + costElementType + ", CostingMethod=" + cm + ", Percent=" + percent);
                if (currentCostPrice.signum() != 0 || currentCostPriceLL.signum() != 0) {
                    if (cm != null) {
                        materialCostEach = materialCostEach.add(currentCostPrice).add(currentCostPriceLL);
                    } else {
                        otherCostEach = otherCostEach.add(currentCostPrice).add(currentCostPriceLL);
                    }
                }
                if (percent != null && percent.signum() != 0) {
                    percentage = percentage.add(percent);
                }
                ++count;
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (count > 1) {
            s_log.finest("MaterialCost=" + materialCostEach + ", OtherCosts=" + otherCostEach + ", Percentage=" + percentage);
        }
        if (materialCostEach.signum() == 0) {
            if (zeroCostsOK) {
                return Env.ZERO;
            }
            materialCostEach = MCost.getSeedCosts(product, M_ASI_ID, as, Org_ID, costingMethod, C_OrderLine_ID);
        }
        if (materialCostEach == null) {
            return null;
        }
        BigDecimal materialCost = materialCostEach.multiply(qty);
        if ("S".equals(costingMethod)) {
            s_log.finer("MaterialCosts = " + materialCost);
            return materialCost;
        }
        if ("F".equals(costingMethod) || "L".equals(costingMethod)) {
            MCostElement ce = MCostElement.getMaterialCostElement(as, costingMethod);
            materialCost = MCostQueue.getCosts(product, M_ASI_ID, as, Org_ID, ce, qty, trxName);
        }
        if ((costs = (otherCost = otherCostEach.multiply(qty)).add(materialCost)).signum() == 0) {
            return null;
        }
        s_log.finer("Sum Costs = " + costs);
        int precision = as.getCostingPrecision();
        if (percentage.signum() == 0) {
            if (costs.scale() > precision) {
                costs = costs.setScale(precision, 4);
            }
            return costs;
        }
        BigDecimal percentCost = costs.multiply(percentage);
        if ((costs = costs.add(percentCost = percentCost.divide(Env.ONEHUNDRED, precision, 4))).scale() > precision) {
            costs = costs.setScale(precision, 4);
        }
        s_log.finer("Sum Costs = " + costs + " (Add=" + percentCost + ")");
        return costs;
    }

    public static BigDecimal getSeedCosts(MProduct product, int M_ASI_ID, MAcctSchema as, int Org_ID, String costingMethod, int C_OrderLine_ID) {
        MCostElement ce;
        MCost cost;
        BigDecimal retValue = null;
        if ("I".equals(costingMethod)) {
            retValue = MCost.calculateAverageInv(product, M_ASI_ID, as, Org_ID);
        } else if ("A".equals(costingMethod)) {
            retValue = MCost.calculateAveragePO(product, M_ASI_ID, as, Org_ID);
        } else if ("F".equals(costingMethod)) {
            retValue = MCost.calculateFiFo(product, M_ASI_ID, as, Org_ID);
        } else if ("L".equals(costingMethod)) {
            retValue = MCost.calculateLiFo(product, M_ASI_ID, as, Org_ID);
        } else if ("i".equals(costingMethod)) {
            retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
        } else if ("p".equals(costingMethod)) {
            if (C_OrderLine_ID != 0) {
                retValue = MCost.getPOPrice(product, C_OrderLine_ID, as.getC_Currency_ID());
            }
            if (retValue == null || retValue.signum() == 0) {
                retValue = MCost.getLastPOPrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            }
        } else if ("S".equals(costingMethod)) {
            MProductCosting pc = MProductCosting.get(product.getCtx(), product.getM_Product_ID(), as.getC_AcctSchema_ID(), null);
            if (pc != null) {
                retValue = pc.getCurrentCostPrice();
            }
        } else if (!"U".equals(costingMethod)) {
            throw new IllegalArgumentException("Unknown Costing Method = " + costingMethod);
        }
        if (retValue != null && retValue.signum() != 0) {
            s_log.fine(product.getName() + ", CostingMethod=" + costingMethod + " - " + retValue);
            return retValue;
        }
        if (C_OrderLine_ID != 0 && (retValue = MCost.getPOPrice(product, C_OrderLine_ID, as.getC_Currency_ID())) != null && retValue.signum() != 0) {
            s_log.fine(product.getName() + ", PO - " + retValue);
            return retValue;
        }
        if (!"S".equals(costingMethod) && (cost = MCost.get(product, M_ASI_ID, as, Org_ID, (ce = MCostElement.getMaterialCostElement(as, "S")).getM_CostElement_ID())) != null && cost.getCurrentCostPrice().signum() != 0) {
            s_log.fine(product.getName() + ", Standard - " + cost);
            return cost.getCurrentCostPrice();
        }
        if ("A".equals(costingMethod) || "p".equals(costingMethod) || "S".equals(costingMethod)) {
            retValue = MCost.getLastPOPrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            if (Org_ID != 0 && (retValue == null || retValue.signum() == 0)) {
                retValue = MCost.getLastPOPrice(product, M_ASI_ID, 0, as.getC_Currency_ID());
            }
            if (retValue != null && retValue.signum() != 0) {
                s_log.fine(product.getName() + ", LastPO = " + retValue);
                return retValue;
            }
        } else {
            retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            if (Org_ID != 0 && (retValue == null || retValue.signum() == 0)) {
                retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, 0, as.getC_Currency_ID());
            }
            if (retValue != null && retValue.signum() != 0) {
                s_log.fine(product.getName() + ", LastInv = " + retValue);
                return retValue;
            }
        }
        if ("A".equals(costingMethod) || "p".equals(costingMethod) || "S".equals(costingMethod)) {
            retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            if (Org_ID != 0 && (retValue == null || retValue.signum() == 0)) {
                retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, 0, as.getC_Currency_ID());
            }
            if (retValue != null && retValue.signum() != 0) {
                s_log.fine(product.getName() + ", LastInv = " + retValue);
                return retValue;
            }
        } else {
            retValue = MCost.getLastPOPrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            if (Org_ID != 0 && (retValue == null || retValue.signum() == 0)) {
                retValue = MCost.getLastPOPrice(product, M_ASI_ID, 0, as.getC_Currency_ID());
            }
            if (retValue != null && retValue.signum() != 0) {
                s_log.fine(product.getName() + ", LastPO = " + retValue);
                return retValue;
            }
        }
        MProductPO[] pos = MProductPO.getOfProduct(product.getCtx(), product.getM_Product_ID(), null);
        for (int i2 = 0; i2 < pos.length; ++i2) {
            BigDecimal price = pos[i2].getPricePO();
            if (price == null || price.signum() == 0) {
                price = pos[i2].getPriceList();
            }
            if (price == null || price.signum() == 0) continue;
            price = MConversionRate.convert(product.getCtx(), price, pos[i2].getC_Currency_ID(), as.getC_Currency_ID(), as.getAD_Client_ID(), Org_ID);
            if (price != null && price.signum() != 0 && pos[i2].getC_UOM_ID() != product.getC_UOM_ID()) {
                price = MUOMConversion.convertProductTo(Env.getCtx(), product.getM_Product_ID(), pos[i2].getC_UOM_ID(), price);
            }
            if (price == null || price.signum() == 0) continue;
            retValue = price;
            s_log.fine(product.getName() + ", Product_PO = " + retValue);
            return retValue;
        }
        s_log.fine(product.getName() + " = " + retValue);
        return retValue;
    }

    public static BigDecimal getLastInvoicePrice(MProduct product, int M_ASI_ID, int AD_Org_ID, int C_Currency_ID) {
        BigDecimal retValue = null;
        String sql = "SELECT currencyConvert(il.PriceActual, i.C_Currency_ID, ?, i.DateAcct, i.C_ConversionType_ID, il.AD_Client_ID, il.AD_Org_ID) FROM C_InvoiceLine il  INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) WHERE il.M_Product_ID=? AND i.IsSOTrx='N'";
        if (AD_Org_ID != 0) {
            sql = sql + " AND il.AD_Org_ID=?";
        } else if (M_ASI_ID != 0) {
            sql = sql + " AND il.M_AttributeSetInstance_ID=?";
        }
        sql = sql + " ORDER BY i.DateInvoiced DESC, il.Line DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, product.get_TrxName());
            pstmt.setInt(1, C_Currency_ID);
            pstmt.setInt(2, product.getM_Product_ID());
            if (AD_Org_ID != 0) {
                pstmt.setInt(3, AD_Org_ID);
            } else if (M_ASI_ID != 0) {
                pstmt.setInt(3, M_ASI_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue != null) {
            s_log.finer(product.getName() + " = " + retValue);
            return retValue;
        }
        return null;
    }

    public static BigDecimal getLastPOPrice(MProduct product, int M_ASI_ID, int AD_Org_ID, int C_Currency_ID) {
        BigDecimal retValue = null;
        String sql = "SELECT currencyConvert(ol.PriceCost, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID), currencyConvert(ol.PriceActual, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.M_Product_ID=? AND o.IsSOTrx='N'";
        if (AD_Org_ID != 0) {
            sql = sql + " AND ol.AD_Org_ID=?";
        } else if (M_ASI_ID != 0) {
            sql = sql + " AND ol.M_AttributeSetInstance_ID=?";
        }
        sql = sql + " ORDER BY o.DateOrdered DESC, ol.Line DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, product.get_TrxName());
            pstmt.setInt(1, C_Currency_ID);
            pstmt.setInt(2, C_Currency_ID);
            pstmt.setInt(3, product.getM_Product_ID());
            if (AD_Org_ID != 0) {
                pstmt.setInt(4, AD_Org_ID);
            } else if (M_ASI_ID != 0) {
                pstmt.setInt(4, M_ASI_ID);
            }
            rs = pstmt.executeQuery();
            if (rs.next() && ((retValue = rs.getBigDecimal(1)) == null || retValue.signum() == 0)) {
                retValue = rs.getBigDecimal(2);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue != null) {
            s_log.finer(product.getName() + " = " + retValue);
            return retValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getPOPrice(MProduct product, int C_OrderLine_ID, int C_Currency_ID) {
        BigDecimal retValue = null;
        String sql = "SELECT currencyConvert(ol.PriceCost, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID), currencyConvert(ol.PriceActual, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.C_OrderLine_ID=? AND o.IsSOTrx='N'";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, product.get_TrxName());
            pstmt.setInt(1, C_Currency_ID);
            pstmt.setInt(2, C_Currency_ID);
            pstmt.setInt(3, C_OrderLine_ID);
            rs = pstmt.executeQuery();
            if (rs.next() && ((retValue = rs.getBigDecimal(1)) == null || retValue.signum() == 0)) {
                retValue = rs.getBigDecimal(2);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            s_log.finer(product.getName() + " = " + retValue);
            return retValue;
        }
        return null;
    }

    public static void create(MClient client) {
        String trxName;
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(client.getCtx(), client.getAD_Client_ID());
        String trxNameUsed = trxName = client.get_TrxName();
        Trx trx = null;
        if (trxName == null) {
            trxNameUsed = Trx.createTrxName("Cost");
            trx = Trx.get(trxNameUsed, true);
        }
        boolean success = true;
        String sql = "SELECT * FROM M_Product p WHERE AD_Client_ID=? AND EXISTS (SELECT * FROM M_CostDetail cd WHERE p.M_Product_ID=cd.M_Product_ID AND Processed='N')";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxNameUsed);
            pstmt.setInt(1, client.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MProduct product = new MProduct(client.getCtx(), rs, trxNameUsed);
                for (int i2 = 0; i2 < ass.length; ++i2) {
                    BigDecimal cost = MCost.getCurrentCost(product, 0, ass[i2], 0, null, Env.ONE, 0, false, trxNameUsed);
                    s_log.info(product.getName() + " = " + cost);
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
            success = false;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (trx != null) {
            if (success) {
                trx.commit();
            } else {
                trx.rollback();
            }
            trx.close();
        }
    }

    protected static void create(MProduct product) {
        s_log.config(product.getName());
        List<MCostElement> ces = MCostElement.getCostElementsWithCostingMethods(product);
        MAcctSchema[] mass = MAcctSchema.getClientAcctSchema(product.getCtx(), product.getAD_Client_ID(), product.get_TrxName());
        MOrg[] orgs = null;
        int M_ASI_ID = 0;
        for (MAcctSchema as : mass) {
            String cl = product.getCostingLevel(as);
            if ("C".equals(cl)) {
                for (MCostElement ce : ces) {
                    MCost cost = MCost.get(product, M_ASI_ID, as, 0, ce.getM_CostElement_ID(), product.get_TrxName());
                    if (!cost.is_new()) continue;
                    if (cost.save()) {
                        s_log.config("Std.Cost for " + product.getName() + " - " + as.getName());
                        continue;
                    }
                    s_log.warning("Not created: Std.Cost for " + product.getName() + " - " + as.getName());
                }
                continue;
            }
            if ("O".equals(cl)) {
                if (orgs == null) {
                    orgs = MOrg.getOfClient(product);
                }
                for (MOrg o : orgs) {
                    for (MCostElement ce : ces) {
                        MCost cost = MCost.get(product, M_ASI_ID, as, o.getAD_Org_ID(), ce.getM_CostElement_ID(), product.get_TrxName());
                        if (!cost.is_new()) continue;
                        if (cost.save()) {
                            s_log.config("Std.Cost for " + product.getName() + " - " + o.getName() + " - " + as.getName());
                            continue;
                        }
                        s_log.warning("Not created: Std.Cost for " + product.getName() + " - " + o.getName() + " - " + as.getName());
                    }
                }
                continue;
            }
            s_log.warning("Not created: Std.Cost for " + product.getName() + " - Costing Level on Batch/Lot");
        }
    }

    protected static void delete(MProduct product) {
        s_log.config(product.getName());
        List<MCostElement> ces = MCostElement.getCostElementsWithCostingMethods(product);
        MAcctSchema[] mass = MAcctSchema.getClientAcctSchema(product.getCtx(), product.getAD_Client_ID(), product.get_TrxName());
        MOrg[] orgs = null;
        int M_ASI_ID = 0;
        for (MAcctSchema as : mass) {
            String cl = product.getCostingLevel(as);
            if ("C".equals(cl)) {
                for (MCostElement ce : ces) {
                    MCost cost = MCost.get(product, M_ASI_ID, as, 0, ce.getM_CostElement_ID(), product.get_TrxName());
                    if (cost == null) continue;
                    cost.deleteEx(true);
                }
                continue;
            }
            if ("O".equals(cl)) {
                if (orgs == null) {
                    orgs = MOrg.getOfClient(product);
                }
                for (MOrg o : orgs) {
                    for (MCostElement ce : ces) {
                        MCost cost = MCost.get(product, M_ASI_ID, as, o.getAD_Org_ID(), ce.getM_CostElement_ID(), product.get_TrxName());
                        if (cost == null) continue;
                        cost.deleteEx(true);
                    }
                }
                continue;
            }
            s_log.warning("Not created: Std.Cost for " + product.getName() + " - Costing Level on Batch/Lot");
        }
    }

    public static BigDecimal calculateAverageInv(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID) {
        String sql = "SELECT t.MovementQty, mi.Qty, il.QtyInvoiced, il.PriceActual, i.C_Currency_ID, i.DateAcct, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID, t.M_Transaction_ID FROM M_Transaction t INNER JOIN M_MatchInv mi ON (t.M_InOutLine_ID=mi.M_InOutLine_ID) INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID) INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) WHERE t.M_Product_ID=?";
        if (AD_Org_ID != 0) {
            sql = sql + " AND t.AD_Org_ID=?";
        } else if (M_AttributeSetInstance_ID != 0) {
            sql = sql + " AND t.M_AttributeSetInstance_ID=?";
        }
        sql = sql + " ORDER BY t.M_Transaction_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal newStockQty = Env.ZERO;
        BigDecimal newAverageAmt = Env.ZERO;
        int oldTransaction_ID = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, product.getM_Product_ID());
            if (AD_Org_ID != 0) {
                pstmt.setInt(2, AD_Org_ID);
            } else if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(2, M_AttributeSetInstance_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal oldStockQty = newStockQty;
                BigDecimal movementQty = rs.getBigDecimal(1);
                int M_Transaction_ID = rs.getInt(10);
                if (M_Transaction_ID != oldTransaction_ID) {
                    newStockQty = oldStockQty.add(movementQty);
                }
                M_Transaction_ID = oldTransaction_ID;
                BigDecimal matchQty = rs.getBigDecimal(2);
                if (matchQty == null) {
                    s_log.finer("Movement=" + movementQty + ", StockQty=" + newStockQty);
                    continue;
                }
                BigDecimal price = rs.getBigDecimal(4);
                int C_Currency_ID = rs.getInt(5);
                Timestamp DateAcct = rs.getTimestamp(6);
                int C_ConversionType_ID = rs.getInt(7);
                int Client_ID = rs.getInt(8);
                int Org_ID = rs.getInt(9);
                BigDecimal cost = MConversionRate.convert(product.getCtx(), price, C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, Client_ID, Org_ID);
                BigDecimal oldAverageAmt = newAverageAmt;
                BigDecimal averageCurrent = oldStockQty.multiply(oldAverageAmt);
                BigDecimal averageIncrease = matchQty.multiply(cost);
                BigDecimal newAmt = averageCurrent.add(averageIncrease);
                newAmt = newAmt.setScale(as.getCostingPrecision(), 4);
                newAverageAmt = newAmt.divide(newStockQty, as.getCostingPrecision(), 4);
                s_log.finer("Movement=" + movementQty + ", StockQty=" + newStockQty + ", Match=" + matchQty + ", Cost=" + cost + ", NewAvg=" + newAverageAmt);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (newAverageAmt != null && newAverageAmt.signum() != 0) {
            s_log.finer(product.getName() + " = " + newAverageAmt);
            return newAverageAmt;
        }
        return null;
    }

    public static BigDecimal calculateAveragePO(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID) {
        String sql = "SELECT t.MovementQty, mp.Qty, ol.QtyOrdered, ol.PriceCost, ol.PriceActual, o.C_Currency_ID, o.DateAcct, o.C_ConversionType_ID, o.AD_Client_ID, o.AD_Org_ID, t.M_Transaction_ID FROM M_Transaction t INNER JOIN M_MatchPO mp ON (t.M_InOutLine_ID=mp.M_InOutLine_ID) INNER JOIN C_OrderLine ol ON (mp.C_OrderLine_ID=ol.C_OrderLine_ID) INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE t.M_Product_ID=?";
        if (AD_Org_ID != 0) {
            sql = sql + " AND t.AD_Org_ID=?";
        } else if (M_AttributeSetInstance_ID != 0) {
            sql = sql + " AND t.M_AttributeSetInstance_ID=?";
        }
        sql = sql + " ORDER BY t.M_Transaction_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal newStockQty = Env.ZERO;
        BigDecimal newAverageAmt = Env.ZERO;
        int oldTransaction_ID = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, product.getM_Product_ID());
            if (AD_Org_ID != 0) {
                pstmt.setInt(2, AD_Org_ID);
            } else if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(2, M_AttributeSetInstance_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal oldStockQty = newStockQty;
                BigDecimal movementQty = rs.getBigDecimal(1);
                int M_Transaction_ID = rs.getInt(11);
                if (M_Transaction_ID != oldTransaction_ID) {
                    newStockQty = oldStockQty.add(movementQty);
                }
                M_Transaction_ID = oldTransaction_ID;
                BigDecimal matchQty = rs.getBigDecimal(2);
                if (matchQty == null) {
                    s_log.finer("Movement=" + movementQty + ", StockQty=" + newStockQty);
                    continue;
                }
                BigDecimal price = rs.getBigDecimal(4);
                if (price == null || price.signum() == 0) {
                    price = rs.getBigDecimal(5);
                }
                int C_Currency_ID = rs.getInt(6);
                Timestamp DateAcct = rs.getTimestamp(7);
                int C_ConversionType_ID = rs.getInt(8);
                int Client_ID = rs.getInt(9);
                int Org_ID = rs.getInt(10);
                BigDecimal cost = MConversionRate.convert(product.getCtx(), price, C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, Client_ID, Org_ID);
                BigDecimal oldAverageAmt = newAverageAmt;
                BigDecimal averageCurrent = oldStockQty.multiply(oldAverageAmt);
                BigDecimal averageIncrease = matchQty.multiply(cost);
                BigDecimal newAmt = averageCurrent.add(averageIncrease);
                newAmt = newAmt.setScale(as.getCostingPrecision(), 4);
                newAverageAmt = newAmt.divide(newStockQty, as.getCostingPrecision(), 4);
                s_log.finer("Movement=" + movementQty + ", StockQty=" + newStockQty + ", Match=" + matchQty + ", Cost=" + cost + ", NewAvg=" + newAverageAmt);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (newAverageAmt != null && newAverageAmt.signum() != 0) {
            s_log.finer(product.getName() + " = " + newAverageAmt);
            return newAverageAmt;
        }
        return null;
    }

    public static BigDecimal calculateFiFo(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID) {
        String sql = "SELECT t.MovementQty, mi.Qty, il.QtyInvoiced, il.PriceActual, i.C_Currency_ID, i.DateAcct, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID, t.M_Transaction_ID FROM M_Transaction t INNER JOIN M_MatchInv mi ON (t.M_InOutLine_ID=mi.M_InOutLine_ID) INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID) INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) WHERE t.M_Product_ID=?";
        if (AD_Org_ID != 0) {
            sql = sql + " AND t.AD_Org_ID=?";
        } else if (M_AttributeSetInstance_ID != 0) {
            sql = sql + " AND t.M_AttributeSetInstance_ID=?";
        }
        sql = sql + " ORDER BY t.M_Transaction_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int oldTransaction_ID = 0;
        ArrayList<QtyCost> fifo = new ArrayList<QtyCost>();
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, product.getM_Product_ID());
            if (AD_Org_ID != 0) {
                pstmt.setInt(2, AD_Org_ID);
            } else if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(2, M_AttributeSetInstance_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                QtyCost pp;
                BigDecimal movementQty = rs.getBigDecimal(1);
                int M_Transaction_ID = rs.getInt(10);
                if (M_Transaction_ID == oldTransaction_ID) continue;
                M_Transaction_ID = oldTransaction_ID;
                BigDecimal matchQty = rs.getBigDecimal(2);
                if (matchQty == null) {
                    QtyCost pp2;
                    if (fifo.size() > 0) {
                        pp2 = (QtyCost)fifo.get(0);
                        pp2.Qty = pp2.Qty.add(movementQty);
                        BigDecimal remainder = pp2.Qty;
                        if (remainder.signum() == 0) {
                            fifo.remove(0);
                        } else {
                            while (remainder.signum() != 0) {
                                if (fifo.size() == 1) {
                                    pp2.Cost = Env.ZERO;
                                    remainder = Env.ZERO;
                                    continue;
                                }
                                fifo.remove(0);
                                pp2 = (QtyCost)fifo.get(0);
                                remainder = pp2.Qty = pp2.Qty.add(movementQty);
                            }
                        }
                    } else {
                        pp2 = new QtyCost(movementQty, Env.ZERO);
                        fifo.add(pp2);
                    }
                    s_log.finer("Movement=" + movementQty + ", Size=" + fifo.size());
                    continue;
                }
                BigDecimal price = rs.getBigDecimal(4);
                int C_Currency_ID = rs.getInt(5);
                Timestamp DateAcct = rs.getTimestamp(6);
                int C_ConversionType_ID = rs.getInt(7);
                int Client_ID = rs.getInt(8);
                int Org_ID = rs.getInt(9);
                BigDecimal cost = MConversionRate.convert(product.getCtx(), price, C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, Client_ID, Org_ID);
                boolean used = false;
                if (fifo.size() == 1) {
                    pp = (QtyCost)fifo.get(0);
                    if (pp.Qty.signum() < 0) {
                        pp.Qty = pp.Qty.add(movementQty);
                        if (pp.Qty.signum() == 0) {
                            fifo.remove(0);
                        } else {
                            pp.Cost = cost;
                        }
                        used = true;
                    }
                }
                if (!used) {
                    pp = new QtyCost(movementQty, cost);
                    fifo.add(pp);
                }
                s_log.finer("Movement=" + movementQty + ", Size=" + fifo.size());
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (fifo.size() == 0) {
            return null;
        }
        QtyCost pp = (QtyCost)fifo.get(0);
        s_log.finer(product.getName() + " = " + pp.Cost);
        return pp.Cost;
    }

    public static BigDecimal calculateLiFo(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID) {
        String sql = "SELECT t.MovementQty, mi.Qty, il.QtyInvoiced, il.PriceActual, i.C_Currency_ID, i.DateAcct, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID, t.M_Transaction_ID FROM M_Transaction t INNER JOIN M_MatchInv mi ON (t.M_InOutLine_ID=mi.M_InOutLine_ID) INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID) INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) WHERE t.M_Product_ID=?";
        if (AD_Org_ID != 0) {
            sql = sql + " AND t.AD_Org_ID=?";
        } else if (M_AttributeSetInstance_ID != 0) {
            sql = sql + " AND t.M_AttributeSetInstance_ID=?";
        }
        sql = sql + " ORDER BY t.M_Transaction_ID DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int oldTransaction_ID = 0;
        ArrayList<QtyCost> lifo = new ArrayList<QtyCost>();
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, product.getM_Product_ID());
            if (AD_Org_ID != 0) {
                pstmt.setInt(2, AD_Org_ID);
            } else if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(2, M_AttributeSetInstance_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal movementQty = rs.getBigDecimal(1);
                int M_Transaction_ID = rs.getInt(10);
                if (M_Transaction_ID == oldTransaction_ID) continue;
                M_Transaction_ID = oldTransaction_ID;
                BigDecimal matchQty = rs.getBigDecimal(2);
                if (matchQty == null) {
                    QtyCost pp;
                    if (lifo.size() > 0) {
                        pp = (QtyCost)lifo.get(lifo.size() - 1);
                        pp.Qty = pp.Qty.add(movementQty);
                        BigDecimal remainder = pp.Qty;
                        if (remainder.signum() == 0) {
                            lifo.remove(lifo.size() - 1);
                        } else {
                            while (remainder.signum() != 0) {
                                if (lifo.size() == 1) {
                                    pp.Cost = Env.ZERO;
                                    remainder = Env.ZERO;
                                    continue;
                                }
                                lifo.remove(lifo.size() - 1);
                                pp = (QtyCost)lifo.get(lifo.size() - 1);
                                remainder = pp.Qty = pp.Qty.add(movementQty);
                            }
                        }
                    } else {
                        pp = new QtyCost(movementQty, Env.ZERO);
                        lifo.add(pp);
                    }
                    s_log.finer("Movement=" + movementQty + ", Size=" + lifo.size());
                    continue;
                }
                BigDecimal price = rs.getBigDecimal(4);
                int C_Currency_ID = rs.getInt(5);
                Timestamp DateAcct = rs.getTimestamp(6);
                int C_ConversionType_ID = rs.getInt(7);
                int Client_ID = rs.getInt(8);
                int Org_ID = rs.getInt(9);
                BigDecimal cost = MConversionRate.convert(product.getCtx(), price, C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, Client_ID, Org_ID);
                QtyCost pp = new QtyCost(movementQty, cost);
                lifo.add(pp);
                s_log.finer("Movement=" + movementQty + ", Size=" + lifo.size());
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (lifo.size() == 0) {
            return null;
        }
        QtyCost pp = (QtyCost)lifo.get(lifo.size() - 1);
        s_log.finer(product.getName() + " = " + pp.Cost);
        return pp.Cost;
    }

    public static MCost get(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID, String trxName) {
        MCost cost = null;
        String whereClause = "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=?";
        cost = (MCost)new Query(product.getCtx(), "M_Cost", "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=?", trxName).setParameters(product.getAD_Client_ID(), AD_Org_ID, product.getM_Product_ID(), M_AttributeSetInstance_ID, as.getM_CostType_ID(), as.getC_AcctSchema_ID(), M_CostElement_ID).firstOnly();
        if (cost == null) {
            cost = new MCost(product, M_AttributeSetInstance_ID, as, AD_Org_ID, M_CostElement_ID);
        }
        return cost;
    }

    @Deprecated
    public static MCost get(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID) {
        return MCost.get(product, M_AttributeSetInstance_ID, as, AD_Org_ID, M_CostElement_ID, product.get_TrxName());
    }

    public static MCost get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int M_Product_ID, int M_CostType_ID, int C_AcctSchema_ID, int M_CostElement_ID, int M_AttributeSetInstance_ID, String trxName) {
        String whereClause = "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=? AND M_AttributeSetInstance_ID=?";
        Object[] params = new Object[]{AD_Client_ID, AD_Org_ID, M_Product_ID, M_CostType_ID, C_AcctSchema_ID, M_CostElement_ID, M_AttributeSetInstance_ID};
        return (MCost)new Query(ctx, "M_Cost", "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=? AND M_AttributeSetInstance_ID=?", trxName).setOnlyActiveRecords(true).setParameters(params).firstOnly();
    }

    @Deprecated
    public static MCost get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int M_Product_ID, int M_CostType_ID, int C_AcctSchema_ID, int M_CostElement_ID, int M_AttributeSetInstance_ID) {
        return MCost.get(ctx, AD_Client_ID, AD_Org_ID, M_Product_ID, M_CostType_ID, C_AcctSchema_ID, M_CostElement_ID, M_AttributeSetInstance_ID, null);
    }

    public MCost(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setM_AttributeSetInstance_ID(0);
        this.setCurrentCostPrice(Env.ZERO);
        this.setFutureCostPrice(Env.ZERO);
        this.setCurrentQty(Env.ZERO);
        this.setCumulatedAmt(Env.ZERO);
        this.setCumulatedQty(Env.ZERO);
    }

    public MCost(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_manual = false;
    }

    public MCost(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID) {
        this(product.getCtx(), 0, product.get_TrxName());
        this.setClientOrg(product.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_CostType_ID(as.getM_CostType_ID());
        this.setM_Product_ID(product.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.m_manual = false;
    }

    public void add(BigDecimal amt, BigDecimal qty) {
        this.setCumulatedAmt(this.getCumulatedAmt().add(amt));
        this.setCumulatedQty(this.getCumulatedQty().add(qty));
        this.setCurrentQty(this.getCurrentQty().add(qty));
    }

    public void setWeightedAverage(BigDecimal amt, BigDecimal qty) {
        BigDecimal oldSum = this.getCurrentCostPrice().multiply(this.getCurrentQty());
        BigDecimal newSum = amt;
        BigDecimal sumAmt = oldSum.add(newSum);
        BigDecimal sumQty = this.getCurrentQty().add(qty);
        if (sumQty.signum() != 0) {
            BigDecimal cost = sumAmt.divide(sumQty, this.getPrecision(), 4);
            this.setCurrentCostPrice(cost);
        }
        this.setCumulatedAmt(this.getCumulatedAmt().add(amt));
        this.setCumulatedQty(this.getCumulatedQty().add(qty));
        this.setCurrentQty(this.getCurrentQty().add(qty));
    }

    private int getPrecision() {
        MAcctSchema as = MAcctSchema.get(this.getCtx(), this.getC_AcctSchema_ID());
        if (as != null) {
            return as.getCostingPrecision();
        }
        return 6;
    }

    @Override
    public void setCurrentCostPrice(BigDecimal currentCostPrice) {
        if (currentCostPrice != null) {
            super.setCurrentCostPrice(currentCostPrice);
        } else {
            super.setCurrentCostPrice(Env.ZERO);
        }
    }

    public BigDecimal getHistoryAverage() {
        BigDecimal retValue = null;
        if (this.getCumulatedQty().signum() != 0 && this.getCumulatedAmt().signum() != 0) {
            retValue = this.getCumulatedAmt().divide(this.getCumulatedQty(), this.getPrecision(), 4);
        }
        return retValue;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MCost[");
        sb.append("AD_Client_ID=").append(this.getAD_Client_ID());
        if (this.getAD_Org_ID() != 0) {
            sb.append(",AD_Org_ID=").append(this.getAD_Org_ID());
        }
        sb.append(",M_Product_ID=").append(this.getM_Product_ID());
        if (this.getM_AttributeSetInstance_ID() != 0) {
            sb.append(",AD_ASI_ID=").append(this.getM_AttributeSetInstance_ID());
        }
        sb.append(",M_CostElement_ID=").append(this.getM_CostElement_ID());
        sb.append(", CurrentCost=").append(this.getCurrentCostPrice()).append(", C.Amt=").append(this.getCumulatedAmt()).append(",C.Qty=").append(this.getCumulatedQty()).append("]");
        return sb.toString();
    }

    public MCostElement getCostElement() {
        int M_CostElement_ID = this.getM_CostElement_ID();
        if (M_CostElement_ID == 0) {
            return null;
        }
        return MCostElement.get(this.getCtx(), M_CostElement_ID);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MCostElement ce = (MCostElement)this.getM_CostElement();
        if (this.m_manual) {
            MAcctSchema as = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), null);
            MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
            String CostingLevel = product.getCostingLevel(as);
            if ("C".equals(CostingLevel)) {
                if (this.getAD_Org_ID() != 0 || this.getM_AttributeSetInstance_ID() != 0) {
                    this.log.saveError("CostingLevelClient", "");
                    return false;
                }
            } else if ("B".equals(CostingLevel)) {
                if (this.getM_AttributeSetInstance_ID() == 0 && ce.isCostingMethod()) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "M_AttributeSetInstance_ID"));
                    return false;
                }
                if (this.getAD_Org_ID() != 0) {
                    this.setAD_Org_ID(0);
                }
            }
        }
        if (this.m_manual && ce != null && ce.isCalculated()) {
            this.log.saveError("Error", Msg.getElement(this.getCtx(), "IsCalculated"));
            return false;
        }
        if (ce != null && (ce.isCalculated() || "M".equals(ce.getCostElementType()) && this.getPercent() != 0)) {
            this.setPercent(0);
        }
        if (this.getPercent() != 0) {
            if (this.getCurrentCostPrice().signum() != 0) {
                this.setCurrentCostPrice(Env.ZERO);
            }
            if (this.getFutureCostPrice().signum() != 0) {
                this.setFutureCostPrice(Env.ZERO);
            }
            if (this.getCumulatedAmt().signum() != 0) {
                this.setCumulatedAmt(Env.ZERO);
            }
            if (this.getCumulatedQty().signum() != 0) {
                this.setCumulatedQty(Env.ZERO);
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        return true;
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        MClient client = MClient.get(Env.getCtx(), 11);
        MCost.create(client);
    }

    public static class QtyCost {
        public BigDecimal Qty = null;
        public BigDecimal Cost = null;

        public QtyCost(BigDecimal qty, BigDecimal cost) {
            this.Qty = qty;
            this.Cost = cost;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Qty=").append(this.Qty).append(",Cost=").append(this.Cost);
            return sb.toString();
        }
    }
}

