/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.model.X_GL_JournalLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MJournalLine
extends X_GL_JournalLine {
    private static final long serialVersionUID = -7008806797777773843L;
    private MJournal m_parent = null;
    private int m_precision = 2;
    private MAccount m_account = null;
    private MElementValue m_accountElement = null;

    public MJournalLine(Properties ctx, int GL_JournalLine_ID, String trxName) {
        super(ctx, GL_JournalLine_ID, trxName);
        if (GL_JournalLine_ID == 0) {
            this.setLine(0);
            this.setAmtAcctCr(Env.ZERO);
            this.setAmtAcctDr(Env.ZERO);
            this.setAmtSourceCr(Env.ZERO);
            this.setAmtSourceDr(Env.ZERO);
            this.setCurrencyRate(Env.ONE);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setIsGenerated(true);
        }
    }

    public MJournalLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournalLine(MJournal parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setGL_Journal_ID(parent.getGL_Journal_ID());
        this.setC_Currency_ID(parent.getC_Currency_ID());
        this.setC_ConversionType_ID(parent.getC_ConversionType_ID());
        this.setDateAcct(parent.getDateAcct());
    }

    public MJournal getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MJournal(this.getCtx(), this.getGL_Journal_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setCurrency(int C_Currency_ID, int C_ConversionType_ID, BigDecimal CurrencyRate) {
        this.setC_Currency_ID(C_Currency_ID);
        if (C_ConversionType_ID != 0) {
            this.setC_ConversionType_ID(C_ConversionType_ID);
        }
        if (CurrencyRate != null && CurrencyRate.signum() == 0) {
            this.setCurrencyRate(CurrencyRate);
        }
    }

    @Override
    public void setC_Currency_ID(int C_Currency_ID) {
        if (C_Currency_ID == 0) {
            return;
        }
        super.setC_Currency_ID(C_Currency_ID);
        this.m_precision = MCurrency.getStdPrecision(this.getCtx(), C_Currency_ID);
    }

    public int getPrecision() {
        return this.m_precision;
    }

    @Override
    public void setCurrencyRate(BigDecimal CurrencyRate) {
        if (CurrencyRate == null) {
            this.log.warning("was NULL - set to 1");
            super.setCurrencyRate(Env.ONE);
        } else if (CurrencyRate.signum() < 0) {
            this.log.warning("negative - " + CurrencyRate + " - set to 1");
            super.setCurrencyRate(Env.ONE);
        } else {
            super.setCurrencyRate(CurrencyRate);
        }
    }

    public void setAmtAcct(BigDecimal AmtAcctDr, BigDecimal AmtAcctCr) {
        double rateDR = 0.0;
        if (AmtAcctDr != null && AmtAcctDr.signum() != 0) {
            rateDR = AmtAcctDr.doubleValue() / this.getAmtSourceDr().doubleValue();
            super.setAmtAcctDr(AmtAcctDr);
        }
        double rateCR = 0.0;
        if (AmtAcctCr != null && AmtAcctCr.signum() != 0) {
            rateCR = AmtAcctCr.doubleValue() / this.getAmtSourceCr().doubleValue();
            super.setAmtAcctCr(AmtAcctCr);
        }
        if (rateDR != 0.0 && rateCR != 0.0 && rateDR != rateCR) {
            this.log.warning("Rates Different DR=" + rateDR + "(used) <> CR=" + rateCR + "(ignored)");
            rateCR = 0.0;
        }
        if (rateDR < 0.0 || Double.isInfinite(rateDR) || Double.isNaN(rateDR)) {
            this.log.warning("DR Rate ignored - " + rateDR);
            return;
        }
        if (rateCR < 0.0 || Double.isInfinite(rateCR) || Double.isNaN(rateCR)) {
            this.log.warning("CR Rate ignored - " + rateCR);
            return;
        }
        if (rateDR != 0.0) {
            this.setCurrencyRate(new BigDecimal(rateDR));
        }
        if (rateCR != 0.0) {
            this.setCurrencyRate(new BigDecimal(rateCR));
        }
    }

    @Override
    public void setC_ValidCombination_ID(int C_ValidCombination_ID) {
        super.setC_ValidCombination_ID(C_ValidCombination_ID);
        this.m_account = null;
        this.m_accountElement = null;
    }

    public void setC_ValidCombination_ID(MAccount acct) {
        if (acct == null) {
            throw new IllegalArgumentException("Account is null");
        }
        super.setC_ValidCombination_ID(acct.getC_ValidCombination_ID());
        this.m_account = acct;
        this.m_accountElement = null;
    }

    public MAccount getAccount() {
        if (this.m_account == null && this.getC_ValidCombination_ID() != 0) {
            this.m_account = new MAccount(this.getCtx(), this.getC_ValidCombination_ID(), this.get_TrxName());
        }
        return this.m_account;
    }

    public MElementValue getAccountElementValue() {
        MAccount vc;
        if (this.m_accountElement == null && (vc = this.getAccount()) != null && vc.getAccount_ID() != 0) {
            this.m_accountElement = new MElementValue(this.getCtx(), vc.getAccount_ID(), this.get_TrxName());
        }
        return this.m_accountElement;
    }

    public boolean isDocControlled() {
        MElementValue acct = this.getAccountElementValue();
        if (acct == null) {
            this.log.warning("Account not found for C_ValidCombination_ID=" + this.getC_ValidCombination_ID());
            return false;
        }
        return acct.isDocControlled();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "GL_JournalLine"));
            return false;
        }
        BigDecimal rate = this.getCurrencyRate();
        BigDecimal amt = rate.multiply(this.getAmtSourceDr());
        if (amt.scale() > this.getPrecision()) {
            amt = amt.setScale(this.getPrecision(), 4);
        }
        this.setAmtAcctDr(amt);
        amt = rate.multiply(this.getAmtSourceCr());
        if (amt.scale() > this.getPrecision()) {
            amt = amt.setScale(this.getPrecision(), 4);
        }
        this.setAmtAcctCr(amt);
        if (newRecord || this.is_ValueChanged("C_ValidCombination_ID") || this.is_ValueChanged("AD_Org_ID")) {
            int AD_Org_ID = this.getAccount().getAD_Org_ID();
            if (AD_Org_ID > 0) {
                this.setAD_Org_ID(AD_Org_ID);
            } else {
                this.setAD_Org_ID(this.getParent().getAD_Org_ID());
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateJournalTotal();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateJournalTotal();
    }

    private boolean updateJournalTotal() {
        String sql = "UPDATE GL_Journal j SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(AmtAcctDr),0), COALESCE(SUM(AmtAcctCr),0) FROM GL_JournalLine jl WHERE jl.IsActive='Y' AND j.GL_Journal_ID=jl.GL_Journal_ID) WHERE GL_Journal_ID=" + this.getGL_Journal_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 1) {
            this.log.warning("afterSave - Update Journal #" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE GL_JournalBatch jb SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(TotalDr),0), COALESCE(SUM(TotalCr),0) FROM GL_Journal j WHERE jb.GL_JournalBatch_ID=j.GL_JournalBatch_ID) WHERE GL_JournalBatch_ID=(SELECT DISTINCT GL_JournalBatch_ID FROM GL_Journal WHERE GL_Journal_ID=" + this.getGL_Journal_ID() + ")", this.get_TrxName())) != 1) {
            this.log.warning("Update Batch #" + no);
        }
        return no == 1;
    }
}

