/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MCurrency;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.Query;
import org.compiere.model.X_I_PriceList;
import org.compiere.model.X_M_PriceList;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MPriceList
extends X_M_PriceList {
    private static final long serialVersionUID = -5096935348390226068L;
    private static CCache<Integer, MPriceList> s_cache = new CCache("M_PriceList", 5);
    private MPriceListVersion m_plv = null;
    private Integer m_precision = null;

    public static MPriceList get(Properties ctx, int M_PriceList_ID, String trxName) {
        Integer key = new Integer(M_PriceList_ID);
        MPriceList retValue = s_cache.get(key);
        if (retValue == null) {
            retValue = new MPriceList(ctx, M_PriceList_ID, trxName);
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MPriceList getDefault(Properties ctx, boolean IsSOPriceList) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        MPriceList retValue2 = null;
        for (MPriceList retValue2 : s_cache.values()) {
            if (!retValue2.isDefault() || retValue2.getAD_Client_ID() != AD_Client_ID || retValue2.isSOPriceList() != IsSOPriceList) continue;
            return retValue2;
        }
        String whereClause = "AD_Client_ID=? AND IsDefault=? AND IsSOPriceList=?";
        retValue2 = (MPriceList)new Query(ctx, "M_PriceList", "AD_Client_ID=? AND IsDefault=? AND IsSOPriceList=?", null).setParameters(AD_Client_ID, "Y", IsSOPriceList ? "Y" : "N").setOnlyActiveRecords(true).setOrderBy("M_PriceList_ID").first();
        if (retValue2 != null) {
            s_cache.put(retValue2.get_ID(), retValue2);
        }
        return retValue2;
    }

    public static MPriceList getDefault(Properties ctx, boolean IsSOPriceList, String ISOCurrency) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        MCurrency currency = MCurrency.get(ctx, ISOCurrency);
        if (currency == null) {
            return MPriceList.getDefault(ctx, IsSOPriceList);
        }
        int M_Currency_ID = currency.get_ID();
        MPriceList retValue2 = null;
        for (MPriceList retValue2 : s_cache.values()) {
            if (!retValue2.isDefault() || retValue2.getAD_Client_ID() != AD_Client_ID || retValue2.isSOPriceList() != IsSOPriceList || retValue2.getC_Currency_ID() != M_Currency_ID) continue;
            return retValue2;
        }
        String whereClause = "AD_Client_ID=? AND IsDefault=? AND IsSOPriceList=? AND C_Currency_ID=?";
        retValue2 = (MPriceList)new Query(ctx, "M_PriceList", "AD_Client_ID=? AND IsDefault=? AND IsSOPriceList=? AND C_Currency_ID=?", null).setParameters(AD_Client_ID, "Y", IsSOPriceList ? "Y" : "N", M_Currency_ID).setOnlyActiveRecords(true).setOrderBy("M_PriceList_ID").first();
        if (retValue2 != null) {
            s_cache.put(retValue2.get_ID(), retValue2);
        }
        return retValue2;
    }

    public static int getStandardPrecision(Properties ctx, int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(ctx, M_PriceList_ID, null);
        return pl.getStandardPrecision();
    }

    public static int getPricePrecision(Properties ctx, int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(ctx, M_PriceList_ID, null);
        return pl.getPricePrecision();
    }

    public MPriceList(Properties ctx, int M_PriceList_ID, String trxName) {
        super(ctx, M_PriceList_ID, trxName);
        if (M_PriceList_ID == 0) {
            this.setEnforcePriceLimit(false);
            this.setIsDefault(false);
            this.setIsSOPriceList(false);
            this.setIsTaxIncluded(false);
            this.setPricePrecision(2);
        }
    }

    public MPriceList(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPriceList(X_I_PriceList impPL) {
        this(impPL.getCtx(), 0, impPL.get_TrxName());
        this.setClientOrg(impPL);
        this.setUpdatedBy(impPL.getUpdatedBy());
        this.setName(impPL.getName());
        this.setDescription(impPL.getDescription());
        this.setC_Currency_ID(impPL.getC_Currency_ID());
        this.setPricePrecision(impPL.getPricePrecision());
        this.setIsSOPriceList(impPL.isSOPriceList());
        this.setIsTaxIncluded(impPL.isTaxIncluded());
        this.setEnforcePriceLimit(impPL.isEnforcePriceLimit());
    }

    public MPriceListVersion getPriceListVersion(Timestamp valid) {
        if (valid == null) {
            valid = new Timestamp(System.currentTimeMillis());
        }
        if (this.m_plv != null && this.m_plv.getValidFrom().before(valid)) {
            return this.m_plv;
        }
        String whereClause = "M_PriceList_ID=? AND TRUNC(ValidFrom, 'DD')<=?";
        this.m_plv = (MPriceListVersion)new Query(this.getCtx(), "M_PriceList_Version", "M_PriceList_ID=? AND TRUNC(ValidFrom, 'DD')<=?", this.get_TrxName()).setParameters(this.getM_PriceList_ID(), valid).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        if (this.m_plv == null) {
            this.log.warning("None found M_PriceList_ID=" + this.getM_PriceList_ID() + " - " + valid);
        } else {
            this.log.fine(this.m_plv.toString());
        }
        return this.m_plv;
    }

    public int getStandardPrecision() {
        if (this.m_precision == null) {
            MCurrency c = MCurrency.get(this.getCtx(), this.getC_Currency_ID());
            this.m_precision = new Integer(c.getStdPrecision());
        }
        return this.m_precision;
    }
}

