/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTypeTask;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_ProjectTask;
import org.compiere.util.Env;

public class MProjectTask
extends X_C_ProjectTask {
    private static final long serialVersionUID = 6714520156233475723L;
    private int C_Project_ID = 0;

    public MProjectTask(Properties ctx, int C_ProjectTask_ID, String trxName) {
        super(ctx, C_ProjectTask_ID, trxName);
        if (C_ProjectTask_ID == 0) {
            this.setSeqNo(0);
            this.setQty(Env.ZERO);
        }
    }

    public MProjectTask(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectTask(MProjectPhase phase) {
        this(phase.getCtx(), 0, phase.get_TrxName());
        this.setClientOrg(phase);
        this.setC_ProjectPhase_ID(phase.getC_ProjectPhase_ID());
    }

    public MProjectTask(MProjectPhase phase, MProjectTypeTask task) {
        this(phase);
        this.setC_Task_ID(task.getC_Task_ID());
        this.setSeqNo(task.getSeqNo());
        this.setName(task.getName());
        this.setDescription(task.getDescription());
        this.setHelp(task.getHelp());
        if (task.getM_Product_ID() != 0) {
            this.setM_Product_ID(task.getM_Product_ID());
        }
        this.setQty(task.getStandardQty());
    }

    public MProjectLine[] getLines() {
        String whereClause = "C_ProjectPhase_ID=? and C_ProjectTask_ID=? ";
        List<MProjectLine> list = new Query(this.getCtx(), "C_ProjectLine", "C_ProjectPhase_ID=? and C_ProjectTask_ID=? ", this.get_TrxName()).setParameters(this.getC_ProjectPhase_ID(), this.getC_ProjectTask_ID()).setOrderBy("Line").list();
        MProjectLine[] retValue = new MProjectLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyLinesFrom(MProjectTask fromTask) {
        if (fromTask == null) {
            return 0;
        }
        int count = 0;
        MProjectLine[] fromLines = fromTask.getLines();
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MProjectLine toLine = new MProjectLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromLines[i2], toLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            toLine.setC_Project_ID(this.getC_Project_ID(false));
            toLine.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
            toLine.setC_ProjectTask_ID(this.getC_ProjectTask_ID());
            if (!toLine.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.warning("Count difference - ProjectLine=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    private int getC_Project_ID(boolean reQuery) {
        if (this.C_Project_ID == 0 || reQuery) {
            this.C_Project_ID = this.getC_ProjectPhase().getC_Project_ID();
        }
        return this.C_Project_ID;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProjectTask[");
        sb.append(this.get_ID()).append("-").append(this.getSeqNo()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

