/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MGoalRestriction;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.X_C_ProjectType;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MProjectType
extends X_C_ProjectType {
    private static final long serialVersionUID = -6041540981032251476L;
    private static CCache<Integer, MProjectType> s_cache = new CCache("C_ProjectType", 20);

    public static MProjectType get(Properties ctx, int C_ProjectType_ID) {
        Integer key = new Integer(C_ProjectType_ID);
        MProjectType retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProjectType(ctx, C_ProjectType_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MProjectType(Properties ctx, int C_ProjectType_ID, String trxName) {
        super(ctx, C_ProjectType_ID, trxName);
    }

    public MProjectType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProjectType[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public MProjectTypePhase[] getPhases() {
        ArrayList<MProjectTypePhase> list = new ArrayList<MProjectTypePhase>();
        String sql = "SELECT * FROM C_Phase WHERE C_ProjectType_ID=? ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_ProjectType_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProjectTypePhase(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MProjectTypePhase[] retValue = new MProjectTypePhase[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String getSqlPI(MGoalRestriction[] restrictions, String MeasureScope, String MeasureDataType, Timestamp reportDate, MRole role) {
        String dateColumn = "Created";
        String orgColumn = "AD_Org_ID";
        String bpColumn = "C_BPartner_ID";
        String pColumn = null;
        StringBuffer sb = new StringBuffer("SELECT COALESCE(SUM(PlannedAmt),COALESCE(SUM(PlannedQty),COUNT(*))) FROM C_Project WHERE C_ProjectType_ID=" + this.getC_ProjectType_ID() + " AND Processed<>'Y')");
        if ("T".equals(MeasureDataType) && !"0".equals(MeasureScope)) {
            if (reportDate == null) {
                reportDate = new Timestamp(System.currentTimeMillis());
            }
            String dateString = DB.TO_DATE(reportDate);
            String trunc = "D";
            if ("1".equals(MeasureScope)) {
                trunc = "Y";
            } else if ("3".equals(MeasureScope)) {
                trunc = "Q";
            } else if ("5".equals(MeasureScope)) {
                trunc = "MM";
            } else if ("7".equals(MeasureScope)) {
                trunc = "W";
            }
            sb.append(" AND TRUNC(").append(dateColumn).append(",'").append(trunc).append("')=TRUNC(").append(DB.TO_DATE(reportDate)).append(",'").append(trunc).append("')");
        }
        String sql = MMeasureCalc.addRestrictions(sb.toString(), false, restrictions, role, "C_Project", orgColumn, bpColumn, pColumn);
        this.log.fine(sql);
        return sql;
    }

    public String getSqlBarChart(MGoalRestriction[] restrictions, String MeasureDisplay, String MeasureDataType, Timestamp startDate, MRole role) {
        String dateColumn = "Created";
        String orgColumn = "AD_Org_ID";
        String bpColumn = "C_BPartner_ID";
        String pColumn = null;
        StringBuffer sb = new StringBuffer("SELECT COALESCE(SUM(PlannedAmt),COALESCE(SUM(PlannedQty),COUNT(*))), ");
        String orderBy = null;
        String groupBy = null;
        if ("T".equals(MeasureDataType) && !"0".equals(MeasureDisplay)) {
            String trunc = "D";
            if ("1".equals(MeasureDisplay)) {
                trunc = "Y";
            } else if ("3".equals(MeasureDisplay)) {
                trunc = "Q";
            } else if ("5".equals(MeasureDisplay)) {
                trunc = "MM";
            } else if ("7".equals(MeasureDisplay)) {
                trunc = "W";
            }
            orderBy = "TRUNC(" + dateColumn + ",'" + trunc + "')";
            groupBy = orderBy + ", 0 ";
            sb.append(groupBy).append("FROM C_Project ");
        } else {
            orderBy = "p.SeqNo";
            groupBy = "COALESCE(p.Name,TO_NCHAR('-')), p.C_Phase_ID, p.SeqNo ";
            sb.append(groupBy).append("FROM C_Project LEFT OUTER JOIN C_Phase p ON (C_Project.C_Phase_ID=p.C_Phase_ID) ");
        }
        sb.append("WHERE C_Project.C_ProjectType_ID=").append(this.getC_ProjectType_ID()).append(" AND C_Project.Processed<>'Y'");
        if (startDate != null && !"0".equals(MeasureDisplay)) {
            String dateString = DB.TO_DATE(startDate);
            sb.append(" AND ").append(dateColumn).append(">=").append(dateString);
        }
        String sql = MMeasureCalc.addRestrictions(sb.toString(), false, restrictions, role, "C_Project", orgColumn, bpColumn, pColumn);
        if (groupBy != null) {
            sql = sql + " GROUP BY " + groupBy + " ORDER BY " + orderBy;
        }
        this.log.fine(sql);
        return sql;
    }

    public MQuery getQuery(MGoalRestriction[] restrictions, String MeasureDisplay, Timestamp date, int C_Phase_ID, MRole role) {
        String dateColumn = "Created";
        String orgColumn = "AD_Org_ID";
        String bpColumn = "C_BPartner_ID";
        String pColumn = null;
        MQuery query = new MQuery("C_Project");
        query.addRangeRestriction("C_ProjectType_ID", "=", this.getC_ProjectType_ID());
        String where = null;
        if (C_Phase_ID != 0) {
            where = "C_Phase_ID=" + C_Phase_ID;
        } else {
            String trunc = "D";
            if ("1".equals(MeasureDisplay)) {
                trunc = "Y";
            } else if ("3".equals(MeasureDisplay)) {
                trunc = "Q";
            } else if ("5".equals(MeasureDisplay)) {
                trunc = "MM";
            } else if ("7".equals(MeasureDisplay)) {
                trunc = "W";
            }
            where = "TRUNC(" + dateColumn + ",'" + trunc + "')=TRUNC(" + DB.TO_DATE(date) + ",'" + trunc + "')";
        }
        String sql = MMeasureCalc.addRestrictions(where + " AND Processed<>'Y' ", true, restrictions, role, "C_Project", orgColumn, bpColumn, pColumn);
        query.addRestriction(sql);
        query.setRecordCount(1);
        return query;
    }
}

