/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Comparator;
import java.util.Properties;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.X_C_RfQResponseLineQty;
import org.compiere.util.Env;

public class MRfQResponseLineQty
extends X_C_RfQResponseLineQty
implements Comparator {
    private static final long serialVersionUID = -4118030805518374853L;
    private MRfQLineQty m_rfqQty = null;
    private static BigDecimal ONEHUNDRED = new BigDecimal(100);

    public MRfQResponseLineQty(Properties ctx, int C_RfQResponseLineQty_ID, String trxName) {
        super(ctx, C_RfQResponseLineQty_ID, trxName);
        if (C_RfQResponseLineQty_ID == 0) {
            this.setPrice(Env.ZERO);
            this.setDiscount(Env.ZERO);
        }
    }

    public MRfQResponseLineQty(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRfQResponseLineQty(MRfQResponseLine line, MRfQLineQty qty) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg(line);
        this.setC_RfQResponseLine_ID(line.getC_RfQResponseLine_ID());
        this.setC_RfQLineQty_ID(qty.getC_RfQLineQty_ID());
    }

    public MRfQLineQty getRfQLineQty() {
        if (this.m_rfqQty == null) {
            this.m_rfqQty = MRfQLineQty.get(this.getCtx(), this.getC_RfQLineQty_ID(), this.get_TrxName());
        }
        return this.m_rfqQty;
    }

    public boolean isValidAmt() {
        BigDecimal price = this.getPrice();
        if (price == null || Env.ZERO.compareTo(price) == 0) {
            this.log.warning("No Price - " + price);
            return false;
        }
        BigDecimal discount = this.getDiscount();
        if (discount != null && discount.abs().compareTo(ONEHUNDRED) > 0) {
            this.log.warning("Discount > 100 - " + discount);
            return false;
        }
        BigDecimal net = this.getNetAmt();
        if (net == null) {
            this.log.warning("Net is null");
            return false;
        }
        if (net.compareTo(Env.ZERO) <= 0) {
            this.log.warning("Net <= 0 - " + net);
            return false;
        }
        return true;
    }

    public BigDecimal getNetAmt() {
        BigDecimal price = this.getPrice();
        if (price == null || Env.ZERO.compareTo(price) == 0) {
            return null;
        }
        BigDecimal discount = this.getDiscount();
        if (discount == null || Env.ZERO.compareTo(discount) == 0) {
            return price;
        }
        BigDecimal factor = ONEHUNDRED.subtract(discount);
        return price.multiply(factor).divide(ONEHUNDRED, 2, 4);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRfQResponseLineQty[");
        sb.append(this.get_ID()).append(",Rank=").append(this.getRanking()).append(",Price=").append(this.getPrice()).append(",Discount=").append(this.getDiscount()).append(",Net=").append(this.getNetAmt()).append("]");
        return sb.toString();
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            throw new IllegalArgumentException("o1 = null");
        }
        if (o2 == null) {
            throw new IllegalArgumentException("o2 = null");
        }
        MRfQResponseLineQty q1 = null;
        MRfQResponseLineQty q2 = null;
        if (!(o1 instanceof MRfQResponseLineQty)) {
            throw new ClassCastException("o1");
        }
        q1 = (MRfQResponseLineQty)o1;
        if (!(o2 instanceof MRfQResponseLineQty)) {
            throw new ClassCastException("o2");
        }
        q2 = (MRfQResponseLineQty)o2;
        if (!q1.isValidAmt()) {
            return -99;
        }
        if (!q2.isValidAmt()) {
            return 99;
        }
        BigDecimal net1 = q1.getNetAmt();
        if (net1 == null) {
            return -9;
        }
        BigDecimal net2 = q2.getNetAmt();
        if (net2 == null) {
            return 9;
        }
        return net1.compareTo(net2);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MRfQResponseLineQty) {
            MRfQResponseLineQty cmp = (MRfQResponseLineQty)obj;
            if (!cmp.isValidAmt() || !this.isValidAmt()) {
                return false;
            }
            BigDecimal cmpNet = cmp.getNetAmt();
            if (cmpNet == null) {
                return false;
            }
            BigDecimal net = cmp.getNetAmt();
            if (net == null) {
                return false;
            }
            return cmpNet.compareTo(net) == 0;
        }
        return false;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!this.isActive()) {
            this.setRanking(999);
        }
        return true;
    }
}

