/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Dimension;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MMenu;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MWindowAccess;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Window;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.wf.MWFNode;

public class MWindow
extends X_AD_Window {
    private static final long serialVersionUID = -7604318488890368565L;
    private static CLogger s_log = CLogger.getCLogger(MWindow.class);
    private MTab[] m_tabs = null;

    public MWindow(Properties ctx, int AD_Window_ID, String trxName) {
        super(ctx, AD_Window_ID, trxName);
        if (AD_Window_ID == 0) {
            this.setWindowType("M");
            this.setEntityType("U");
            this.setIsBetaFunctionality(false);
            this.setIsDefault(false);
            this.setIsSOTrx(true);
        }
    }

    public MWindow(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setWindowSize(Dimension size) {
        if (size != null) {
            this.setWinWidth(size.width);
            this.setWinHeight(size.height);
        }
    }

    public MTab[] getTabs(boolean reload, String trxName) {
        if (this.m_tabs != null && !reload) {
            return this.m_tabs;
        }
        String whereClause = "AD_Window_ID=?";
        List<MTab> list = new Query(this.getCtx(), "AD_Tab", "AD_Window_ID=?", trxName).setParameters(this.getAD_Window_ID()).setOrderBy("SeqNo").list();
        this.m_tabs = new MTab[list.size()];
        list.toArray(this.m_tabs);
        return this.m_tabs;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        block6: {
            block5: {
                if (!newRecord) break block5;
                MRole[] roles = MRole.getOf(this.getCtx(), "IsManual='N'");
                for (int i2 = 0; i2 < roles.length; ++i2) {
                    MWindowAccess wa = new MWindowAccess(this, roles[i2].getAD_Role_ID());
                    wa.save();
                }
                break block6;
            }
            if (!this.is_ValueChanged("IsActive") && !this.is_ValueChanged("Name") && !this.is_ValueChanged("Description") && !this.is_ValueChanged("Help")) break block6;
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Window_ID=" + this.getAD_Window_ID(), this.get_TrxName());
            for (int i3 = 0; i3 < menues.length; ++i3) {
                menues[i3].setName(this.getName());
                menues[i3].setDescription(this.getDescription());
                menues[i3].setIsActive(this.isActive());
                menues[i3].save();
            }
            MWFNode[] nodes = MWindow.getWFNodes(this.getCtx(), "AD_Window_ID=" + this.getAD_Window_ID(), this.get_TrxName());
            for (int i4 = 0; i4 < nodes.length; ++i4) {
                boolean changed = false;
                if (nodes[i4].isActive() != this.isActive()) {
                    nodes[i4].setIsActive(this.isActive());
                    changed = true;
                }
                if (nodes[i4].isCentrallyMaintained()) {
                    nodes[i4].setName(this.getName());
                    nodes[i4].setDescription(this.getDescription());
                    nodes[i4].setHelp(this.getHelp());
                    changed = true;
                }
                if (!changed) continue;
                nodes[i4].save();
            }
        }
        return success;
    }

    public static MWFNode[] getWFNodes(Properties ctx, String whereClause, String trxName) {
        List<MWFNode> list = new Query(ctx, "AD_WF_Node", whereClause, trxName).list();
        MWFNode[] retValue = new MWFNode[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getWindow_ID(String windowName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        int retValue;
        block4: {
            retValue = 0;
            String SQL = "SELECT AD_Window_ID FROM AD_Window WHERE Name = ?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(SQL, null);
                pstmt.setString(1, windowName);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                retValue = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    s_log.log(Level.SEVERE, SQL, e);
                    retValue = -1;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        DB.close(rs, pstmt);
        return retValue;
    }
}

