/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MProduct;
import org.compiere.pos.AdempierePOSException;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class PosOrderModel
extends MOrder {
    private static final long serialVersionUID = 5253837037827124425L;
    private MPOS m_pos;

    public PosOrderModel(Properties ctx, int C_Order_ID, String trxName, MPOS pos) {
        super(ctx, C_Order_ID, trxName);
        this.m_pos = pos;
    }

    public static PosOrderModel createOrder(MPOS pos, MBPartner partner) {
        PosOrderModel order = new PosOrderModel(Env.getCtx(), 0, null, pos);
        order.setAD_Org_ID(pos.getAD_Org_ID());
        order.setIsSOTrx(true);
        order.setC_POS_ID(pos.getC_POS_ID());
        if (pos.getC_DocType_ID() != 0) {
            order.setC_DocTypeTarget_ID(pos.getC_DocType_ID());
        } else {
            order.setC_DocTypeTarget_ID("WR");
        }
        if (partner == null || partner.get_ID() == 0) {
            partner = pos.getBPartner();
        }
        if (partner == null || partner.get_ID() == 0) {
            throw new AdempierePOSException("No BPartner for order");
        }
        order.setBPartner(partner);
        order.setM_PriceList_ID(pos.getM_PriceList_ID());
        order.setM_Warehouse_ID(pos.getM_Warehouse_ID());
        order.setSalesRep_ID(pos.getSalesRep_ID());
        order.setPaymentRule("B");
        if (!order.save()) {
            order = null;
            throw new AdempierePOSException("Save order failed");
        }
        return order;
    }

    @Override
    public void setBPartner(MBPartner partner) {
        if (this.getDocStatus().equals("DR")) {
            if (partner == null || partner.get_ID() == 0) {
                throw new AdempierePOSException("no BPartner");
            }
            this.log.info("SubCurrentLine.getOrder -" + partner);
            super.setBPartner(partner);
            MOrderLine[] lineas = this.getLines();
            for (int i = 0; i < lineas.length; ++i) {
                lineas[i].setC_BPartner_ID(partner.getC_BPartner_ID());
                lineas[i].setTax();
                lineas[i].save();
            }
            this.saveEx();
        }
    }

    public MOrderLine createLine(MProduct product, BigDecimal QtyOrdered, BigDecimal PriceActual) {
        if (!this.getDocStatus().equals("DR")) {
            return null;
        }
        int numLines = 0;
        MOrderLine[] lines = null;
        try {
            lines = this.getLines(null, "Line");
            numLines = lines.length;
            for (int i = 0; i < numLines; ++i) {
                if (lines[i].getM_Product_ID() != product.getM_Product_ID()) continue;
                BigDecimal current = lines[i].getQtyEntered();
                BigDecimal toadd = QtyOrdered;
                BigDecimal total = current.add(toadd);
                lines[i].setQty(total);
                lines[i].setPrice();
                if (PriceActual.compareTo(Env.ZERO) > 0) {
                    lines[i].setPrice(PriceActual);
                }
                lines[i].save();
                return lines[i];
            }
        }
        catch (Exception e) {
            this.log.severe("Order lines cannot be created - " + e.getMessage());
        }
        MOrderLine line = new MOrderLine(this);
        line.setProduct(product);
        line.setQty(QtyOrdered);
        line.setPrice();
        if (PriceActual.compareTo(Env.ZERO) > 0) {
            line.setPrice(PriceActual);
        }
        line.save();
        return line;
    }

    public boolean deleteOrder() {
        if (this.getDocStatus().equals("DR")) {
            int numTax;
            MOrderTax[] taxs;
            int numLines;
            MOrderLine[] lines = this.getLines();
            if (lines != null && (numLines = lines.length) > 0) {
                for (int i = numLines - 1; i >= 0; --i) {
                    if (lines[i] == null) continue;
                    this.deleteLine(lines[i].getC_Order_ID());
                }
            }
            if ((taxs = this.getTaxes(true)) != null && (numTax = taxs.length) > 0) {
                for (int i = taxs.length - 1; i >= 0; --i) {
                    if (taxs[i] != null) {
                        taxs[i].delete(true);
                    }
                    taxs[i] = null;
                }
            }
            this.getLines(true, null);
            return this.delete(true);
        }
        return false;
    }

    public void deleteLine(int C_OrderLine_ID) {
        if (C_OrderLine_ID != -1) {
            for (MOrderLine line : this.getLines(true, "M_Product_ID")) {
                if (line.getC_OrderLine_ID() != C_OrderLine_ID) continue;
                line.delete(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processOrder() {
        boolean orderCompleted = false;
        if (this.getDocStatus().equals("DR") || this.getDocStatus().equals("IP")) {
            this.setDocAction("CO");
            try {
                if (this.processIt("CO")) {
                    this.save();
                } else {
                    this.log.info("Process Order FAILED");
                }
            }
            catch (Exception e) {
                this.log.severe("Order can not be completed - " + e.getMessage());
            }
            finally {
                if (this.getDocStatus().equals("IN")) {
                    this.setDocStatus("DR");
                } else if (this.getDocStatus().equals("CO")) {
                    orderCompleted = true;
                    this.log.info("SubCheckout - processOrder OK");
                } else {
                    this.log.info("SubCheckout - processOrder - unrecognized DocStatus");
                }
            }
        }
        return orderCompleted;
    }

    public BigDecimal getTaxAmt() {
        BigDecimal taxAmt = Env.ZERO;
        for (MOrderTax tax : this.getTaxes(true)) {
            taxAmt = taxAmt.add(tax.getTaxAmt());
        }
        return taxAmt;
    }

    public BigDecimal getSubtotal() {
        return this.getGrandTotal().subtract(this.getTaxAmt());
    }

    public BigDecimal getPaidAmt() {
        BigDecimal cashline;
        String sql = "SELECT sum(PayAmt) FROM C_Payment WHERE C_Order_ID = ? AND DocStatus IN ('CO','CL')";
        BigDecimal received = DB.getSQLValueBD(null, sql, this.getC_Order_ID());
        if (received == null) {
            received = Env.ZERO;
        }
        if ((cashline = DB.getSQLValueBD(null, sql = "SELECT sum(Amount) FROM C_CashLine WHERE C_Invoice_ID = ? ", this.getC_Invoice_ID())) != null) {
            received = received.add(cashline);
        }
        return received;
    }

    public boolean payCash(BigDecimal amt) {
        MPayment payment = this.createPayment("X");
        payment.setC_CashBook_ID(this.m_pos.getC_CashBook_ID());
        payment.setAmount(this.getC_Currency_ID(), amt);
        payment.setC_BankAccount_ID(this.m_pos.getC_BankAccount_ID());
        payment.save();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.save();
            return true;
        }
        return false;
    }

    public boolean payCheck(BigDecimal amt, String accountNo, String routingNo, String checkNo) {
        MPayment payment = this.createPayment("K");
        payment.setAmount(this.getC_Currency_ID(), amt);
        payment.setC_BankAccount_ID(this.m_pos.getC_BankAccount_ID());
        payment.setAccountNo(accountNo);
        payment.setRoutingNo(routingNo);
        payment.setCheckNo(checkNo);
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            return true;
        }
        return false;
    }

    public boolean payCreditCard(BigDecimal amt, String accountName, int month, int year, String cardNo, String cvc, String cardtype) {
        MPayment payment = this.createPayment("K");
        payment.setAmount(this.getC_Currency_ID(), amt);
        payment.setC_BankAccount_ID(this.m_pos.getC_BankAccount_ID());
        payment.setCreditCard("S", cardtype, cardNo, cvc, month, year);
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            return true;
        }
        return false;
    }

    private MPayment createPayment(String tenderType) {
        MPayment payment = new MPayment(this.getCtx(), 0, null);
        payment.setAD_Org_ID(this.m_pos.getAD_Org_ID());
        payment.setTenderType(tenderType);
        payment.setC_Order_ID(this.getC_Order_ID());
        payment.setIsReceipt(true);
        payment.setC_BPartner_ID(this.getC_BPartner_ID());
        return payment;
    }

    public void reload() {
        this.load(this.get_TrxName());
        this.getLines(true, "");
    }

    public ValueNamePair[] getCreditCards(BigDecimal amt) {
        try {
            MPaymentProcessor[] m_mPaymentProcessors = MPaymentProcessor.find(this.getCtx(), null, null, this.getAD_Client_ID(), this.getAD_Org_ID(), this.getC_Currency_ID(), amt, this.get_TrxName());
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            for (int i = 0; i < m_mPaymentProcessors.length; ++i) {
                if (m_mPaymentProcessors[i].isAcceptAMEX()) {
                    map.put("A", this.getCreditCardPair("A"));
                }
                if (m_mPaymentProcessors[i].isAcceptDiners()) {
                    map.put("D", this.getCreditCardPair("D"));
                }
                if (m_mPaymentProcessors[i].isAcceptDiscover()) {
                    map.put("N", this.getCreditCardPair("N"));
                }
                if (m_mPaymentProcessors[i].isAcceptMC()) {
                    map.put("M", this.getCreditCardPair("M"));
                }
                if (m_mPaymentProcessors[i].isAcceptCorporate()) {
                    map.put("P", this.getCreditCardPair("P"));
                }
                if (!m_mPaymentProcessors[i].isAcceptVisa()) continue;
                map.put("V", this.getCreditCardPair("V"));
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            this.log.fine("getCreditCards - #" + retValue.length + " - Processors=" + m_mPaymentProcessors.length);
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String CreditCardType) {
        return new ValueNamePair(CreditCardType, this.getCreditCardName(CreditCardType));
    }

    public String getCreditCardName(String CreditCardType) {
        if (CreditCardType == null) {
            return "--";
        }
        if ("M".equals(CreditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(CreditCardType)) {
            return "Visa";
        }
        if ("A".equals(CreditCardType)) {
            return "Amex";
        }
        if ("C".equals(CreditCardType)) {
            return "ATM";
        }
        if ("D".equals(CreditCardType)) {
            return "Diners";
        }
        if ("N".equals(CreditCardType)) {
            return "Discover";
        }
        if ("P".equals(CreditCardType)) {
            return "PurchaseCard";
        }
        return "?" + CreditCardType + "?";
    }
}

