/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Properties;
import org.compiere.print.layout.HTMLRenderer;
import org.compiere.print.layout.PrintElement;

public class HTMLElement
extends PrintElement {
    private HTMLRenderer m_renderer;

    public HTMLElement(String html) {
        if (html == null || html.equals("")) {
            throw new IllegalArgumentException("HTMLElement is null");
        }
        this.log.fine("Length=" + html.length());
        this.m_renderer = HTMLRenderer.get(html);
    }

    @Override
    protected boolean calculateSize() {
        if (this.p_sizeCalculated) {
            return true;
        }
        this.p_height = this.m_renderer.getHeight();
        this.p_width = this.m_renderer.getWidth();
        if (this.p_maxWidth != 0.0f) {
            this.p_width = this.p_maxWidth;
        }
        if (this.p_maxHeight != 0.0f) {
            this.p_height = this.p_maxHeight == -1.0f ? this.m_renderer.getHeightOneLine() : this.p_maxHeight;
        }
        this.m_renderer.setAllocation((int)this.p_width, (int)this.p_height);
        return true;
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        Rectangle allocation = this.m_renderer.getAllocation();
        g2D.translate(location.x, location.y);
        this.m_renderer.paint(g2D, allocation);
        g2D.translate(-location.x, -location.y);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("HTMLElement[");
        sb.append("Bounds=").append(this.getBounds()).append(",Height=").append(this.p_height).append("(").append(this.p_maxHeight).append("),Width=").append(this.p_width).append("(").append(this.p_maxHeight).append("),PageLocation=").append(this.p_pageLocation).append(" - ");
        sb.append("]");
        return sb.toString();
    }

    public static boolean isHTML(Object content) {
        if (content == null) {
            return false;
        }
        String s = content.toString();
        if (s.length() < 20) {
            return false;
        }
        return (s = s.trim().toUpperCase()).startsWith("<HTML>");
    }
}

