/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.net.URI;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetDelivery;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MProductDownload;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.EMail;

public class AssetDelivery
extends SvrProcess {
    private MClient m_client = null;
    private int m_A_Asset_Group_ID = 0;
    private int m_M_Product_ID = 0;
    private int m_C_BPartner_ID = 0;
    private int m_A_Asset_ID = 0;
    private Timestamp m_GuaranteeDate = null;
    private int m_NoGuarantee_MailText_ID = 0;
    private boolean m_AttachAsset = false;
    private MMailText m_MailText = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("A_Asset_Group_ID")) {
                this.m_A_Asset_Group_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.m_M_Product_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.m_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("A_Asset_ID")) {
                this.m_A_Asset_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("GuaranteeDate")) {
                this.m_GuaranteeDate = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("NoGuarantee_MailText_ID")) {
                this.m_NoGuarantee_MailText_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AttachAsset")) {
                this.m_AttachAsset = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.m_GuaranteeDate == null) {
            this.m_GuaranteeDate = new Timestamp(System.currentTimeMillis());
        }
        this.m_client = MClient.get(this.getCtx());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        String s;
        this.log.info("");
        long start = System.currentTimeMillis();
        if (this.m_client.getSMTPHost() == null || this.m_client.getSMTPHost().length() == 0) {
            throw new Exception("No Client SMTP Info");
        }
        if (this.m_client.getRequestEMail() == null) {
            throw new Exception("No Client Request User");
        }
        if (this.m_A_Asset_ID != 0) {
            String msg = this.deliverIt(this.m_A_Asset_ID);
            this.addLog(this.m_A_Asset_ID, null, null, msg);
            return msg;
        }
        StringBuffer sql = new StringBuffer("SELECT A_Asset_ID, GuaranteeDate FROM A_Asset a INNER JOIN M_Product p ON (a.M_Product_ID=p.M_Product_ID) WHERE ");
        if (this.m_A_Asset_Group_ID != 0) {
            sql.append("a.A_Asset_Group_ID=").append(this.m_A_Asset_Group_ID).append(" AND ");
        }
        if (this.m_M_Product_ID != 0) {
            sql.append("p.M_Product_ID=").append(this.m_M_Product_ID).append(" AND ");
        }
        if (this.m_C_BPartner_ID != 0) {
            sql.append("a.C_BPartner_ID=").append(this.m_C_BPartner_ID).append(" AND ");
        }
        if ((s = sql.toString()).endsWith(" WHERE ")) {
            throw new Exception("@RestrictSelection@");
        }
        if (this.m_NoGuarantee_MailText_ID == 0) {
            sql.append("TRUNC(GuaranteeDate, 'DD') >= ").append(DB.TO_DATE(this.m_GuaranteeDate, true));
            s = sql.toString();
        }
        if (s.endsWith(" AND ")) {
            s = sql.substring(0, sql.length() - 5);
        }
        Statement stmt = null;
        int count = 0;
        int errors = 0;
        int reminders = 0;
        ResultSet rs = null;
        try {
            stmt = DB.createStatement();
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                int A_Asset_ID = rs.getInt(1);
                Timestamp GuaranteeDate = rs.getTimestamp(2);
                if (GuaranteeDate != null && GuaranteeDate.before(this.m_GuaranteeDate)) {
                    if (this.m_NoGuarantee_MailText_ID == 0) continue;
                    this.sendNoGuaranteeMail(A_Asset_ID, this.m_NoGuarantee_MailText_ID, this.get_TrxName());
                    ++reminders;
                    continue;
                }
                String msg = this.deliverIt(A_Asset_ID);
                this.addLog(A_Asset_ID, null, null, msg);
                if (msg.startsWith("** ")) {
                    ++errors;
                    continue;
                }
                ++count;
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, s, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
        this.log.info("Count=" + count + ", Errors=" + errors + ", Reminder=" + reminders + " - " + (System.currentTimeMillis() - start) + "ms");
        return "@Sent@=" + count + " - @Errors@=" + errors;
    }

    private String sendNoGuaranteeMail(int A_Asset_ID, int R_MailText_ID, String trxName) {
        MAsset asset = new MAsset(this.getCtx(), A_Asset_ID, trxName);
        if (asset.getAD_User_ID() == 0) {
            return "** No Asset User";
        }
        MUser user = new MUser(this.getCtx(), asset.getAD_User_ID(), this.get_TrxName());
        if (user.getEMail() == null || user.getEMail().length() == 0) {
            return "** No Asset User Email";
        }
        if (this.m_MailText == null || this.m_MailText.getR_MailText_ID() != R_MailText_ID) {
            this.m_MailText = new MMailText(this.getCtx(), R_MailText_ID, this.get_TrxName());
        }
        if (this.m_MailText.getMailHeader() == null || this.m_MailText.getMailHeader().length() == 0) {
            return "** No Subject";
        }
        EMail email = this.m_client.createEMail(user.getEMail(), null, null);
        this.m_MailText.setPO(user);
        this.m_MailText.setPO(asset);
        String message = this.m_MailText.getMailText(true);
        if (this.m_MailText.isHtml()) {
            email.setMessageHTML(this.m_MailText.getMailHeader(), message);
        } else {
            email.setSubject(this.m_MailText.getMailHeader());
            email.setMessageText(message);
        }
        String msg = email.send();
        new MUserMail(this.m_MailText, asset.getAD_User_ID(), email).save();
        if (!"OK".equals(msg)) {
            return "** Not delivered: " + user.getEMail() + " - " + msg;
        }
        return user.getEMail();
    }

    private String deliverIt(int A_Asset_ID) {
        this.log.fine("A_Asset_ID=" + A_Asset_ID);
        long start = System.currentTimeMillis();
        MAsset asset = new MAsset(this.getCtx(), A_Asset_ID, this.get_TrxName());
        if (asset.getAD_User_ID() == 0) {
            return "** No Asset User";
        }
        MUser user = new MUser(this.getCtx(), asset.getAD_User_ID(), this.get_TrxName());
        if (user.getEMail() == null || user.getEMail().length() == 0) {
            return "** No Asset User Email";
        }
        if (asset.getProductR_MailText_ID() == 0) {
            return "** Product Mail Text";
        }
        if (this.m_MailText == null || this.m_MailText.getR_MailText_ID() != asset.getProductR_MailText_ID()) {
            this.m_MailText = new MMailText(this.getCtx(), asset.getProductR_MailText_ID(), this.get_TrxName());
        }
        if (this.m_MailText.getMailHeader() == null || this.m_MailText.getMailHeader().length() == 0) {
            return "** No Subject";
        }
        EMail email = this.m_client.createEMail(user.getEMail(), null, null);
        if (!email.isValid()) {
            asset.setHelp(asset.getHelp() + " - Invalid EMail");
            asset.setIsActive(false);
            return "** Invalid EMail: " + user.getEMail();
        }
        if (this.m_client.isSmtpAuthorization()) {
            email.createAuthenticator(this.m_client.getRequestUser(), this.m_client.getRequestUserPW());
        }
        this.m_MailText.setUser(user);
        this.m_MailText.setPO(asset);
        String message = this.m_MailText.getMailText(true);
        if (this.m_MailText.isHtml() || this.m_AttachAsset) {
            email.setMessageHTML(this.m_MailText.getMailHeader(), message);
        } else {
            email.setSubject(this.m_MailText.getMailHeader());
            email.setMessageText(message);
        }
        if (this.m_AttachAsset) {
            MProductDownload[] pdls = asset.getProductDownloads();
            if (pdls != null) {
                for (int i2 = 0; i2 < pdls.length; ++i2) {
                    URI url = pdls[i2].getDownloadURL(this.m_client.getDocumentDir());
                    if (url == null) continue;
                    email.addAttachment(url);
                }
            } else {
                this.log.warning("No DowloadURL for A_Asset_ID=" + A_Asset_ID);
            }
        }
        String msg = email.send();
        new MUserMail(this.m_MailText, asset.getAD_User_ID(), email).save();
        if (!"OK".equals(msg)) {
            return "** Not delivered: " + user.getEMail() + " - " + msg;
        }
        MAssetDelivery ad = this.confirmDelivery(asset, email, user.getAD_User_ID());
        ad.save();
        asset.save();
        this.log.fine(System.currentTimeMillis() - start + " ms");
        return user.getEMail() + " - " + asset.getProductVersionNo();
    }

    public MAssetDelivery confirmDelivery(MAsset asset, EMail email, int AD_User_ID) {
        asset.setVersionNo(asset.getProductVersionNo());
        MAssetDelivery ad = new MAssetDelivery(asset, email, AD_User_ID);
        return ad;
    }
}

