/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MDocType;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;

public class DocActionTemplate
extends PO
implements DocAction {
    private static final long serialVersionUID = -7588955558162632796L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    private DocActionTemplate() {
        super(null);
    }

    @Override
    protected POInfo initPO(Properties ctx) {
        return null;
    }

    @Override
    protected int get_AccessLevel() {
        return 0;
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), 0);
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.approveIt();
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return this.closeIt();
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        return this.reverseCorrectIt();
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    @Override
    public String getDocumentNo() {
        return "-";
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public void setDocStatus(String newStatus) {
    }

    @Override
    public String getDocStatus() {
        return null;
    }

    @Override
    public String getDocAction() {
        return null;
    }

    @Override
    public boolean save() {
        return false;
    }
}

