/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.NoVendorForProductException;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class RequisitionPOCreate
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_M_Warehouse_ID = 0;
    private Timestamp p_DateDoc_From;
    private Timestamp p_DateDoc_To;
    private Timestamp p_DateRequired_From;
    private Timestamp p_DateRequired_To;
    private String p_PriorityRule = null;
    private int p_AD_User_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_M_Requisition_ID = 0;
    private boolean p_ConsolidateDocument = false;
    private MOrder m_order = null;
    private MOrderLine m_orderLine = null;
    private HashMap<MultiKey, MOrder> m_cacheOrders = new HashMap();
    private int m_M_Requisition_ID = 0;
    private int m_M_Product_ID = 0;
    private int m_M_AttributeSetInstance_ID = 0;
    private MBPartner m_bpartner = null;
    private List<Integer> m_excludedVendors = new ArrayList<Integer>();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DateDoc")) {
                this.p_DateDoc_From = (Timestamp)para[i2].getParameter();
                this.p_DateDoc_To = (Timestamp)para[i2].getParameter_To();
                continue;
            }
            if (name.equals("DateRequired")) {
                this.p_DateRequired_From = (Timestamp)para[i2].getParameter();
                this.p_DateRequired_To = (Timestamp)para[i2].getParameter_To();
                continue;
            }
            if (name.equals("PriorityRule")) {
                this.p_PriorityRule = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("AD_User_ID")) {
                this.p_AD_User_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Requisition_ID")) {
                this.p_M_Requisition_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        if (this.p_M_Requisition_ID != 0) {
            this.log.info("M_Requisition_ID=" + this.p_M_Requisition_ID);
            MRequisition req = new MRequisition(this.getCtx(), this.p_M_Requisition_ID, this.get_TrxName());
            if (!"CO".equals(req.getDocStatus())) {
                throw new AdempiereUserError("@DocStatus@ = " + req.getDocStatus());
            }
            MRequisitionLine[] lines = req.getLines();
            for (int i2 = 0; i2 < lines.length; ++i2) {
                if (lines[i2].getC_OrderLine_ID() != 0) continue;
                this.process(lines[i2]);
            }
            this.closeOrder();
            return "";
        }
        this.log.info("AD_Org_ID=" + this.p_AD_Org_ID + ", M_Warehouse_ID=" + this.p_M_Warehouse_ID + ", DateDoc=" + this.p_DateDoc_From + "/" + this.p_DateDoc_To + ", DateRequired=" + this.p_DateRequired_From + "/" + this.p_DateRequired_To + ", PriorityRule=" + this.p_PriorityRule + ", AD_User_ID=" + this.p_AD_User_ID + ", M_Product_ID=" + this.p_M_Product_ID + ", ConsolidateDocument" + this.p_ConsolidateDocument);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("C_OrderLine_ID IS NULL");
        if (this.p_AD_Org_ID > 0) {
            whereClause.append(" AND AD_Org_ID=?");
            params.add(this.p_AD_Org_ID);
        }
        if (this.p_M_Product_ID > 0) {
            whereClause.append(" AND M_Product_ID=?");
            params.add(this.p_M_Product_ID);
        } else if (this.p_M_Product_Category_ID > 0) {
            whereClause.append(" AND EXISTS (SELECT 1 FROM M_Product p WHERE M_RequisitionLine.M_Product_ID=p.M_Product_ID").append(" AND p.M_Product_Category_ID=?)");
            params.add(this.p_M_Product_Category_ID);
        }
        if (this.p_C_BP_Group_ID > 0) {
            whereClause.append(" AND (").append("M_RequisitionLine.C_BPartner_ID IS NULL").append(" OR EXISTS (SELECT 1 FROM C_BPartner bp WHERE M_RequisitionLine.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=?)").append(")");
            params.add(this.p_C_BP_Group_ID);
        }
        whereClause.append(" AND EXISTS (SELECT 1 FROM M_Requisition r WHERE M_RequisitionLine.M_Requisition_ID=r.M_Requisition_ID").append(" AND r.DocStatus=?");
        params.add("CO");
        if (this.p_M_Warehouse_ID > 0) {
            whereClause.append(" AND r.M_Warehouse_ID=?");
            params.add(this.p_M_Warehouse_ID);
        }
        if (this.p_DateDoc_From != null) {
            whereClause.append(" AND r.DateDoc >= ?");
            params.add(this.p_DateDoc_From);
        }
        if (this.p_DateDoc_To != null) {
            whereClause.append(" AND r.DateDoc <= ?");
            params.add(this.p_DateDoc_To);
        }
        if (this.p_DateRequired_From != null) {
            whereClause.append(" AND r.DateRequired >= ?");
            params.add(this.p_DateRequired_From);
        }
        if (this.p_DateRequired_To != null) {
            whereClause.append(" AND r.DateRequired <= ?");
            params.add(this.p_DateRequired_To);
        }
        if (this.p_PriorityRule != null) {
            whereClause.append(" AND r.PriorityRule >= ?");
            params.add(this.p_PriorityRule);
        }
        if (this.p_AD_User_ID > 0) {
            whereClause.append(" AND r.AD_User_ID=?");
            params.add(this.p_AD_User_ID);
        }
        whereClause.append(")");
        StringBuffer orderClause = new StringBuffer();
        if (!this.p_ConsolidateDocument) {
            orderClause.append("M_Requisition_ID, ");
        }
        orderClause.append("(SELECT DateRequired FROM M_Requisition r WHERE M_RequisitionLine.M_Requisition_ID=r.M_Requisition_ID),");
        orderClause.append("M_Product_ID, C_Charge_ID, M_AttributeSetInstance_ID");
        POResultSet rs = new Query(this.getCtx(), "M_RequisitionLine", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy(orderClause.toString()).setClient_ID().scroll();
        try {
            while (rs.hasNext()) {
                this.process((MRequisitionLine)rs.next());
            }
        }
        finally {
            DB.close(rs);
            rs = null;
        }
        this.closeOrder();
        return "";
    }

    private void process(MRequisitionLine rLine) throws Exception {
        if (rLine.getM_Product_ID() == 0 && rLine.getC_Charge_ID() == 0) {
            this.log.warning("Ignored Line" + rLine.getLine() + " " + rLine.getDescription() + " - " + rLine.getLineNetAmt());
            return;
        }
        if (!this.p_ConsolidateDocument && rLine.getM_Requisition_ID() != this.m_M_Requisition_ID) {
            this.closeOrder();
        }
        if (this.m_orderLine == null || rLine.getM_Product_ID() != this.m_M_Product_ID || rLine.getM_AttributeSetInstance_ID() != this.m_M_AttributeSetInstance_ID || rLine.getC_Charge_ID() != 0 || this.m_order == null || this.m_order.getDatePromised().compareTo(rLine.getDateRequired()) != 0) {
            this.newLine(rLine);
            if (this.m_orderLine == null) {
                return;
            }
        }
        this.m_orderLine.setQty(this.m_orderLine.getQtyOrdered().add(rLine.getQty()));
        rLine.setC_OrderLine_ID(this.m_orderLine.getC_OrderLine_ID());
        rLine.saveEx();
    }

    private void newOrder(MRequisitionLine rLine, int C_BPartner_ID) throws Exception {
        if (this.m_order != null) {
            this.closeOrder();
        }
        if (this.m_bpartner == null || C_BPartner_ID != this.m_bpartner.get_ID()) {
            this.m_bpartner = MBPartner.get(this.getCtx(), C_BPartner_ID);
        }
        Timestamp DateRequired = rLine.getDateRequired();
        int M_PriceList_ID = rLine.getParent().getM_PriceList_ID();
        MultiKey key = new MultiKey((Object)C_BPartner_ID, (Object)DateRequired, (Object)M_PriceList_ID);
        this.m_order = this.m_cacheOrders.get(key);
        if (this.m_order == null) {
            this.m_order = new MOrder(this.getCtx(), 0, this.get_TrxName());
            this.m_order.setDatePromised(DateRequired);
            this.m_order.setIsSOTrx(false);
            this.m_order.setC_DocTypeTarget_ID();
            this.m_order.setBPartner(this.m_bpartner);
            this.m_order.setM_PriceList_ID(M_PriceList_ID);
            if (!this.p_ConsolidateDocument) {
                this.m_order.setDescription(Msg.getElement(this.getCtx(), "M_Requisition_ID") + ": " + rLine.getParent().getDocumentNo());
            }
            this.m_order.saveEx();
            this.m_cacheOrders.put(key, this.m_order);
        }
        this.m_M_Requisition_ID = rLine.getM_Requisition_ID();
    }

    private void closeOrder() throws Exception {
        if (this.m_orderLine != null) {
            this.m_orderLine.saveEx();
        }
        if (this.m_order != null) {
            this.m_order.load(this.get_TrxName());
            this.addLog(0, null, this.m_order.getGrandTotal(), this.m_order.getDocumentNo());
        }
        this.m_order = null;
        this.m_orderLine = null;
    }

    private void newLine(MRequisitionLine rLine) throws Exception {
        if (this.m_orderLine != null) {
            this.m_orderLine.saveEx();
        }
        this.m_orderLine = null;
        MProduct product = MProduct.get(this.getCtx(), rLine.getM_Product_ID());
        int C_BPartner_ID = rLine.getC_BPartner_ID();
        if (C_BPartner_ID == 0) {
            if (rLine.getC_Charge_ID() != 0) {
                MCharge charge = MCharge.get(this.getCtx(), rLine.getC_Charge_ID());
                C_BPartner_ID = charge.getC_BPartner_ID();
                if (C_BPartner_ID == 0) {
                    throw new AdempiereUserError("No Vendor for Charge " + charge.getName());
                }
            } else {
                MProductPO[] ppos = MProductPO.getOfProduct(this.getCtx(), product.getM_Product_ID(), null);
                for (int i2 = 0; i2 < ppos.length; ++i2) {
                    if (!ppos[i2].isCurrentVendor() || ppos[i2].getC_BPartner_ID() == 0) continue;
                    C_BPartner_ID = ppos[i2].getC_BPartner_ID();
                    break;
                }
                if (C_BPartner_ID == 0 && ppos.length > 0) {
                    C_BPartner_ID = ppos[0].getC_BPartner_ID();
                }
                if (C_BPartner_ID == 0) {
                    throw new NoVendorForProductException(product.getName());
                }
            }
        }
        if (!this.isGenerateForVendor(C_BPartner_ID)) {
            this.log.info("Skip for partner " + C_BPartner_ID);
            return;
        }
        if (this.m_order == null || this.m_order.getC_BPartner_ID() != C_BPartner_ID || this.m_order.getDatePromised().compareTo(rLine.getDateRequired()) != 0) {
            this.newOrder(rLine, C_BPartner_ID);
        }
        this.m_orderLine = new MOrderLine(this.m_order);
        this.m_orderLine.setDatePromised(rLine.getDateRequired());
        if (product != null) {
            this.m_orderLine.setProduct(product);
            this.m_orderLine.setM_AttributeSetInstance_ID(rLine.getM_AttributeSetInstance_ID());
        } else {
            this.m_orderLine.setC_Charge_ID(rLine.getC_Charge_ID());
            this.m_orderLine.setPriceActual(rLine.getPriceActual());
        }
        this.m_orderLine.setAD_Org_ID(rLine.getAD_Org_ID());
        this.m_M_Product_ID = rLine.getM_Product_ID();
        this.m_M_AttributeSetInstance_ID = rLine.getM_AttributeSetInstance_ID();
        this.m_orderLine.saveEx();
    }

    private boolean isGenerateForVendor(int C_BPartner_ID) {
        if (this.p_C_BP_Group_ID <= 0) {
            return true;
        }
        if (this.m_excludedVendors.contains(C_BPartner_ID)) {
            return false;
        }
        boolean match = new Query(this.getCtx(), "C_BPartner", "C_BPartner_ID=? AND C_BP_Group_ID=?", this.get_TrxName()).setParameters(C_BPartner_ID, this.p_C_BP_Group_ID).match();
        if (!match) {
            this.m_excludedVendors.add(C_BPartner_ID);
        }
        return match;
    }
}

