/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class TranslationDocSync
extends SvrProcess {
    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        MClient client = MClient.get(this.getCtx());
        if (client.isMultiLingualDocument()) {
            throw new AdempiereUserError("@AD_Client_ID@: @IsMultiLingualDocument@");
        }
        this.log.info("" + client);
        String sql = "SELECT * FROM AD_Table WHERE TableName LIKE '%_Trl' AND TableName NOT LIKE 'AD%' ORDER BY TableName";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.processTable(new MTable(this.getCtx(), rs, null), client.getAD_Client_ID());
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "OK";
    }

    private void processTable(MTable table2, int AD_Client_ID) {
        StringBuffer sql = new StringBuffer();
        MColumn[] columns = table2.getColumns(false);
        for (int i2 = 0; i2 < columns.length; ++i2) {
            MColumn column = columns[i2];
            if (column.getAD_Reference_ID() != 10 && column.getAD_Reference_ID() != 14) continue;
            String columnName = column.getColumnName();
            if (sql.length() != 0) {
                sql.append(",");
            }
            sql.append(columnName);
        }
        String baseTable = table2.getTableName();
        baseTable = baseTable.substring(0, baseTable.length() - 4);
        this.log.config(baseTable + ": " + sql);
        String columnNames = sql.toString();
        sql = new StringBuffer();
        sql.append("UPDATE ").append(table2.getTableName()).append(" t SET (").append(columnNames).append(") = (SELECT ").append(columnNames).append(" FROM ").append(baseTable).append(" b WHERE t.").append(baseTable).append("_ID=b.").append(baseTable).append("_ID) WHERE AD_Client_ID=").append(AD_Client_ID);
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), baseTable);
    }
}

