/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class UserPassword
extends SvrProcess {
    private int p_AD_User_ID = -1;
    private String p_OldPassword = null;
    private String p_NewPassword = null;
    private String p_NewEMail = null;
    private String p_NewEMailUser = null;
    private String p_NewEMailUserPW = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_User_ID")) {
                this.p_AD_User_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("OldPassword")) {
                this.p_OldPassword = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("NewPassword")) {
                this.p_NewPassword = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("NewEMail")) {
                this.p_NewEMail = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("NewEMailUser")) {
                this.p_NewEMailUser = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("NewEMailUserPW")) {
                this.p_NewEMailUserPW = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("AD_User_ID=" + this.p_AD_User_ID + " from " + this.getAD_User_ID());
        MUser user = MUser.get(this.getCtx(), this.p_AD_User_ID);
        MUser operator = MUser.get(this.getCtx(), this.getAD_User_ID());
        this.log.fine("User=" + user + ", Operator=" + operator);
        if (Util.isEmpty(this.p_OldPassword)) {
            if (this.p_AD_User_ID == 0 || this.p_AD_User_ID == 100 || !operator.isAdministrator()) {
                throw new IllegalArgumentException("@OldPasswordMandatory@");
            }
        } else if (!this.p_OldPassword.equals(user.getPassword())) {
            throw new IllegalArgumentException("@OldPasswordNoMatch@");
        }
        if (this.p_AD_User_ID == 0) {
            String sql = "UPDATE AD_User SET Updated=SysDate, UpdatedBy=" + this.getAD_User_ID();
            if (!Util.isEmpty(this.p_NewPassword)) {
                sql = sql + ", Password=" + DB.TO_STRING(this.p_NewPassword);
            }
            if (!Util.isEmpty(this.p_NewEMail)) {
                sql = sql + ", Email=" + DB.TO_STRING(this.p_NewEMail);
            }
            if (!Util.isEmpty(this.p_NewEMailUser)) {
                sql = sql + ", EmailUser=" + DB.TO_STRING(this.p_NewEMailUser);
            }
            if (!Util.isEmpty(this.p_NewEMailUserPW)) {
                sql = sql + ", EmailUserPW=" + DB.TO_STRING(this.p_NewEMailUserPW);
            }
            if (DB.executeUpdate(sql = sql + " WHERE AD_User_ID=0", this.get_TrxName()) == 1) {
                return "OK";
            }
            return "@Error@";
        }
        if (!Util.isEmpty(this.p_NewPassword)) {
            user.setPassword(this.p_NewPassword);
        }
        if (!Util.isEmpty(this.p_NewEMail)) {
            user.setEMail(this.p_NewEMail);
        }
        if (!Util.isEmpty(this.p_NewEMailUser)) {
            user.setEMailUser(this.p_NewEMailUser);
        }
        if (!Util.isEmpty(this.p_NewEMailUserPW)) {
            user.setEMailUserPW(this.p_NewEMailUserPW);
        }
        if (user.save()) {
            return "OK";
        }
        return "@Error@";
    }
}

