/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_FA
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", "\u0178\u00e1\u00ff\u2264\u00ff\u00df\u00ff\u00b1", "\u0178\u00d6\u0178\u00e4\u0178\u00d1\u0178\u00e4\u0178\u00e0\u0178\u00dc", "\u0178\u00d6\u0178\u00e4\u0178\u00d1\u0178\u00e4\u00ff\u00df\u00ff\u00b1\u00ff\u00d8", "\u00ff\u2122\u00ff\u00b1\u0178\u00e4\u0178\u00d1\u0178\u00e4\u0178\u00e0\u0178\u00dc", "\u2044\u00a9\u0178\u00e0\u00ff\u00a2\u00ff\u00d8\u00ff\u00b1\u0178\u00e4\u0178\u00d1\u0178\u00e4\u0178\u00e0\u0178\u00dc", "\u0178\u00e1\u00ff\u2264\u00ff\u00df\u00ff\u00b1 \u2044\u00a9\u0178\u00e0\u00ff\u00a2\u00ff\u00d8\u00ff\u00b1\u0178\u00e4\u0178\u00d1\u0178\u00e4\u0178\u00e0\u0178\u00dc"};
    private static final String[] hundredsNames = new String[]{"", "\u0178\u00e4\u2044\u00a9\u00ff\u00b5\u00ff\u00d8", "\u00ff\u00d8\u0178\u00e0\u0178\u00e4\u00ff\u2265\u00ff\u2122", "\u00ff\u2265\u0178\u00e4\u00ff\u00b5\u00ff\u00d8", "\u2044\u00dc\u0178\u00e1\u00ff\u00df\u00ff\u00b1\u00ff\u00b5\u00ff\u00d8", "\u0178\u00e6\u00ff\u00df\u0178\u00dc\u00ff\u00b5\u00ff\u00d8", "\u00ff\u00a5\u00ff\u00a5\u00ff\u00b5\u00ff\u00d8", "\u0178\u00e1\u0178\u00c5\u00ff\u2122\u00ff\u00b5\u00ff\u00d8", "\u0178\u00e1\u00ff\u00a5\u00ff\u2122\u00ff\u00b5\u00ff\u00d8", "\u0178\u00dc\u0178\u00e1\u00ff\u00b5\u00ff\u00d8"};
    private static final String[] tensNames = new String[]{"", "\u00ff\u00d8\u0178\u00e1", "\u00ff\u00ae\u0178\u00e4\u00ff\u2265\u00ff\u2122", "\u00ff\u2265\u0178\u00e4", "\u2044\u00dc\u0178\u00e1\u0178\u00d1", "\u0178\u00e6\u0178\u00dc\u00ff\u00a8\u00ff\u00df\u0178\u00e1", "\u00ff\u00a5\u00ff\u00b5\u00ff\u2122", "\u0178\u00e1\u0178\u00c5\u00ff\u2122\u00ff\u00df\u00ff\u00d8", "\u0178\u00e1\u00ff\u00a5\u00ff\u2122\u00ff\u00df\u00ff\u00d8", "\u0178\u00dc\u0178\u00e0\u00ff\u00d8"};
    private static final String[] numNames = new String[]{"", "\u0178\u00e4\u2044\u00a9", "\u00ff\u00d8\u0178\u00e0", "\u00ff\u2265\u0178\u00e1", "\u2044\u00dc\u0178\u00e1\u00ff\u00df\u00ff\u00b1", "\u0178\u00e6\u0178\u00dc\u00ff\u00a8", "\u00ff\u00a5\u00ff\u00a5", "\u0178\u00e1\u0178\u00c5\u00ff\u2122", "\u0178\u00e1\u00ff\u00a5\u00ff\u2122", "\u0178\u00dc\u0178\u00e1", "\u00ff\u00d8\u0178\u00e1", "\u0178\u00e4\u00ff\u00df\u00ff\u2264\u00ff\u00d8\u0178\u00e1", "\u00ff\u00d8\u0178\u00e0\u00ff\u00df\u00ff\u2264\u00ff\u00d8\u0178\u00e1", "\u00ff\u2265\u0178\u00e4\u00ff\u2264\u00ff\u00d8\u0178\u00e1", "\u2044\u00dc\u0178\u00e1\u00ff\u00df\u00ff\u00b1\u00ff\u00d8\u0178\u00e1", "\u0178\u00e6\u00ff\u00df\u0178\u00dc\u00ff\u2264\u00ff\u00d8\u0178\u00e1", "\u00ff\u00a5\u00ff\u00df\u0178\u00dc\u00ff\u2264\u00ff\u00d8\u0178\u00e1", "\u0178\u00e1\u0178\u00c5\u00ff\u00d8\u0178\u00e1", "\u0178\u00e1\u00ff\u00a8\u00ff\u00d8\u0178\u00e1", "\u0178\u00dc\u0178\u00e0\u00ff\u2264\u00ff\u00d8\u0178\u00e1"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            soFar = hundredsNames[number /= 100] + ("".equals(soFar) || hundredsNames[number].equals("") ? soFar : " \u0178\u00e0 " + soFar);
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + (tensNames[number % 10].equals("") ? soFar : " \u0178\u00e0 " + soFar);
            soFar = hundredsNames[(number /= 10) % 10] + (hundredsNames[number % 10].equals("") ? soFar : " \u0178\u00e0 " + soFar);
        }
        return soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "\u00ff\u00b5\u0178\u00c5\u00ff\u00b1";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "\u0178\u00d6\u0178\u00dc\u0178\u00c5\u0178\u00e4 ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                soFar = !soFar.equals("") ? s + " " + majorNames[place] + (s.equals("") || majorNames[place].equals("") ? soFar : " \u0178\u00e0 " + soFar) : s + " " + majorNames[place];
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        long dollars = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(dollars));
        for (int i2 = 0; i2 < oldamt.length(); ++i2) {
            if (pos != i2) continue;
            String cents = oldamt.substring(i2 + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_FA aiw = new AmtInWords_FA();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.345");
        aiw.print("123.45");
        aiw.print("103.00");
        aiw.print("100.00");
        aiw.print("523.45");
        aiw.print("1000.00");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("123457.89");
        aiw.print("1,234,578.90");
    }
}

