/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import org.compiere.util.AmtInWords;

public class AmtInWords_HU
implements AmtInWords {
    static String thousandseparator = ",";
    static String wholeseparator = ".";
    String[] numbers = new String[]{"nulla", "egy", "kett\u2248\u00eb", "h\u221a\u00b0rom", "n\u221a\u00a9gy", "\u221a\u2202t", "hat", "h\u221a\u00a9t", "nyolc", "kilenc"};
    String[] tens_solo = new String[]{null, "t\u221a\u2260z", "h\u221a\u222bsz", "harminc", "negyven", "\u221a\u2202tven", "hatvan", "hetven", "nyolcvan", "kilencven"};
    String[] tens_connected = new String[]{null, "tizen", "huszon", "harminc", "negyven", "\u221a\u2202tven", "hatvan", "hetven", "nyolcvan", "kilencven"};
    String[] majorNames = new String[]{"", "ezer", "milli\u221a\u2265", "billi\u221a\u2265", "trilli\u221a\u2265", "kvadrilli\u221a\u2265", "kvintilli\u221a\u2265"};

    @Override
    public String getAmtInWords(String amount) throws Exception {
        String amountWhole;
        assert (amount != null);
        amount = amount.replaceAll(" ", "").replaceAll("\u00a0", "");
        amount = amount.replaceAll("\\" + thousandseparator, "");
        int pos = amount.lastIndexOf(wholeseparator);
        String cents = null;
        if (pos >= 0) {
            amountWhole = amount.substring(0, pos);
            cents = amount.substring(pos + 1);
        } else {
            amountWhole = amount;
        }
        BigInteger num = new BigInteger(amountWhole);
        StringBuilder ret = new StringBuilder();
        if (num.compareTo(BigInteger.valueOf(0L)) < 0) {
            num = num.negate();
            ret.append("m\u221a\u2260nusz ");
        }
        boolean needDivisor = true;
        if (num.compareTo(BigInteger.valueOf(2000L)) < 0) {
            needDivisor = false;
        }
        ArrayList<Integer> pieces = new ArrayList<Integer>();
        if (BigInteger.valueOf(0L).equals(num)) {
            return this.numbers[0];
        }
        while (num.compareTo(BigInteger.valueOf(0L)) > 0) {
            BigInteger[] divAndMod = num.divideAndRemainder(BigInteger.valueOf(1000L));
            int mod = divAndMod[1].intValue();
            num = divAndMod[0];
            pieces.add(mod);
        }
        Collections.reverse(pieces);
        boolean firstPiece = true;
        for (int i2 = 0; i2 < pieces.size(); ++i2) {
            int piece = (Integer)pieces.get(i2);
            int weight = pieces.size() - i2 - 1;
            if (piece == 0 && !firstPiece) continue;
            if (!firstPiece && needDivisor) {
                ret.append("-");
            }
            firstPiece = false;
            ret.append(this.getAmtInWordsTo1000(piece));
            if (this.majorNames.length > weight) {
                ret.append(this.majorNames[weight]);
                continue;
            }
            throw new NumberFormatException("number too big for converting amount to word" + amount);
        }
        if (cents != null) {
            ret.append(" eg\u221a\u00a9sz ");
            ret.append(this.getAmtInWords(cents));
            ret.append(" sz\u221a\u00b0zad");
        }
        return ret.toString();
    }

    public String getAmtInWordsTo1000(int amount) {
        StringBuilder ret = new StringBuilder();
        int hundred = amount / 100;
        int ten = (amount - amount / 100 * 100) / 10;
        int one = amount - amount / 10 * 10;
        if (hundred != 0) {
            if (hundred != 0) {
                ret.append(this.numbers[hundred]);
            }
            ret.append("sz\u221a\u00b0z");
        }
        if (ten != 0) {
            if (one != 0) {
                ret.append(this.tens_connected[ten]);
            } else {
                ret.append(this.tens_solo[ten]);
            }
        }
        if (one != 0 || hundred == 0 && ten == 0) {
            ret.append(this.numbers[one]);
        }
        return ret.toString();
    }
}

