/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_PL
implements AmtInWords {
    private static final String[][] majorNames = new String[][]{{"", "", ""}, {"tysi\u0192\u00d6c", "tysi\u0192\u00d6ce", "tysi\u0192\u00f4cy"}, {"milion", "miliony", "milion\u221a\u2265w"}, {"miliard", "miliardy", "miliard\u221a\u2265w"}, {"bilion", "biliony", "bilion\u221a\u2265w"}, {"trylion", "tryliony", "trylion\u221a\u2265w"}, {"quadrylion", "quadryliony", "quadrylion\u221a\u2265w"}};
    private static final String[] tensNames = new String[]{"", "dziesi\u0192\u00f4\u0192\u00e1", "dwadzie\u2248\u00f5cia", "trzydzie\u2248\u00f5ci", "czterdzie\u2248\u00f5ci", "pi\u0192\u00f4\u0192\u00e1dziesi\u0192\u00d6t", "sze\u2248\u00f5\u0192\u00e1dziesi\u0192\u00d6t", "siedemdziesi\u0192\u00d6t", "osiemdziesi\u0192\u00d6t", "dziewi\u0192\u00f4\u0192\u00e1dziesi\u0192\u00d6t"};
    private static final String[] hundredNames = new String[]{"", "sto", "dwie\u2248\u00f5cie", "trzysta", "czterysta", "pi\u0192\u00f4\u0192\u00e1set", "sze\u2248\u00f5\u0192\u00e1set", "siedemset", "osiemset", "dziewi\u0192\u00f4\u0192\u00e1set"};
    private static final String[] numNames = new String[]{"", "jeden", "dwa", "trzy", "cztery", "pi\u0192\u00f4\u0192\u00e1", "sze\u2248\u00f5\u0192\u00e1", "siedem", "osiem", "dzieiwi\u0192\u00f4\u0192\u00e1", "dziesi\u0192\u00f4\u0192\u00e1", "jedena\u2248\u00f5cie", "dwana\u2248\u00f5cie", "trzyna\u2248\u00f5cie", "czterna\u2248\u00f5cie", "pietna\u2248\u00f5cie", "szescna\u2248\u00f5cie", "siedemna\u2248\u00f5cie", "osiemna\u2248\u00f5cie", "dziewi\u0192\u00f4tna\u2248\u00f5cie"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + " " + soFar;
            number /= 10;
        }
        soFar = hundredNames[number % 10] + " " + soFar;
        number /= 10;
        return soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "zero";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "minus ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                int pos = number % 10L == 1L ? 0 : (number % 10L < 5L ? 1 : 2);
                if (number > 9L && number < 20L) {
                    pos = 2;
                }
                soFar = s + " " + majorNames[place][pos] + " " + soFar;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        long dollars = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(dollars));
        for (int i2 = 0; i2 < oldamt.length(); ++i2) {
            if (pos != i2) continue;
            String cents = oldamt.substring(i2 + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_PL aiw = new AmtInWords_PL();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.345");
        aiw.print("123.45");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("10345.78");
        aiw.print("123457.89");
        aiw.print("323457.89");
        aiw.print("23457.89");
        aiw.print("1,234,578.90");
    }
}

