/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_SR
implements AmtInWords {
    private static final String zero = "Nula";
    private static final String negative = "minus";
    private static final String concat = "i";
    private static final String[] din = new String[]{"dinar", "dinara"};
    private static final String[][] majorNames = new String[][]{{"", "", ""}, {"Hiljadu", "Hiljade", "Hiljada"}, {"Milion", "Miliona", "Miliona"}, {"Milijarda", "Milijarde", "Milijardi"}, {"Bilion", "Biliona", "Biliona"}, {"Bilijarda", "Bilijarde", "Bilijardi"}, {"Trilion", "Triliona", "Triliona"}};
    private static final String[] tensNames = new String[]{"", "Deset", "Dvadeset", "Trideset", "\u0192\u00e5etrdeset", "Pedeset", "\u2248\u2020estdeset", "Sedamdeset", "Osamdeset", "Devedeset"};
    private static final String[] hundredNames = new String[]{"", "JednaStotina", "DveStotine", "TriStotine", "\u0192\u00e5etiriStotine", "PetStotina", "\u2248\u2020estStotina", "SedamStotina", "OsamStotina", "DevetStotina"};
    private static final String[][] numNames = new String[][]{{"", ""}, {"Jedan", "Jedna"}, {"Dva", "Dve"}, {"Tri", "Tri"}, {"\u0192\u00e5etiri", "\u0192\u00e5etiri"}, {"Pet", "Pet"}, {"\u2248\u2020est", "\u2248\u2020est"}, {"Sedam", "Sedam"}, {"Osam", "Osam"}, {"Devet", "Devet"}, {"Deset", "Deset"}, {"Jedanaest", "Jedanast"}, {"Dvanaeset", "Dvanaest"}, {"Trinaeset", "Trinaest"}, {"\u0192\u00e5etrnaest", "\u0192\u00e5etrnaest"}, {"Petnaest", "Petnaest"}, {"\u2248\u2020estnaest", "\u2248\u2020estnaest"}, {"Sedamnaest", "Sedamnaest"}, {"Osamnaest", "Osamnaest"}, {"Devetnaest", "Devetnaest"}};

    private String convertLessThanOneThousand(int number, int w) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100][w];
            number /= 100;
        } else {
            soFar = numNames[number % 10][w];
            soFar = soFar.compareTo("") == 0 ? tensNames[number % 10] : tensNames[(number /= 10) % 10] + concat + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return hundredNames[number] + soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return zero;
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "minus ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n, place == 1 ? 1 : 0);
                if (place == 1 && s.compareTo(numNames[1][1]) == 0) {
                    soFar = majorNames[place][0] + soFar;
                } else {
                    long lastDigit = n % 10L;
                    long lastTwoDigits = n % 100L;
                    boolean teen = lastTwoDigits > 10L && lastTwoDigits < 20L;
                    String major = null;
                    major = lastDigit == 1L && !teen ? majorNames[place][0] : (lastDigit > 1L && lastDigit < 5L && !teen ? majorNames[place][1] : majorNames[place][2]);
                    soFar = s + major + soFar;
                }
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int sep = (amount = amount.replaceAll(" ", "").replaceAll("\u00a0", "")).contains(",") ? 44 : 46;
        int pos = amount.lastIndexOf(sep);
        long dins = Long.parseLong(pos >= 0 ? amount.substring(0, pos) : amount);
        sb.append(this.convert(dins) + " " + din[dins == 1L ? 0 : 1]);
        if (pos > 0) {
            String para = amount.substring(pos + 1);
            if (para.length() > 2) {
                para = para.substring(0, 2);
            }
            sb.append(" i ").append(para).append("/100");
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_SR aiw = new AmtInWords_SR();
        aiw.print("0.23");
        aiw.print("23");
        aiw.print("0,23");
        aiw.print("1,23");
        aiw.print("12,345");
        aiw.print("123,45");
        aiw.print("1 234,56");
        aiw.print("12 345,78");
        aiw.print("123 457,89");
        aiw.print("1 234 578,90");
        aiw.print("10,00");
        aiw.print("50,00");
        aiw.print("100,00");
        aiw.print("300,00");
        aiw.print("1 000,00");
        aiw.print("3 000,00");
        aiw.print("10 000,00");
        aiw.print("1 000 000,00");
        aiw.print("100 000 000,00");
        aiw.print("100 000 000 000,00");
        aiw.print("100 000 000 000 000,00");
        aiw.print("1 000 000 000 000 000,00");
        aiw.print("1 000 000 000 000 000 000,00");
    }
}

