/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Locale;
import org.compiere.Adempiere;

public class Splash
extends Frame {
    private static final long serialVersionUID = 7671371032359729541L;
    private static Splash s_splash = null;
    private MediaTracker tracker = new MediaTracker(this);
    private CImage cImage = new CImage();
    private AImage aImage = new AImage();
    private Label productLabel = new Label();
    private Panel contentPanel = new Panel();
    private GridBagLayout contentLayout = new GridBagLayout();
    private Label message = new Label();

    public static Splash getSplash() {
        String msg = Locale.getDefault().getLanguage().equals("es") ? new String("Cargando...") : new String("Loading...");
        return Splash.getSplash(msg);
    }

    public static Splash getSplash(String text) {
        if (s_splash == null) {
            s_splash = new Splash(text);
        } else {
            s_splash.setText(text);
        }
        return s_splash;
    }

    public Splash(String text) {
        super("Adempiere");
        this.message.setText(text);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            System.out.println("Splash");
            e.printStackTrace();
        }
        this.display();
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.white);
        this.setName("splash");
        this.setUndecorated(true);
        this.productLabel.setAlignment(1);
        this.message.setFont(new Font("Serif", 3, 20));
        this.message.setForeground(SystemColor.activeCaption);
        this.message.setAlignment(1);
        this.contentPanel.setLayout(this.contentLayout);
        this.contentPanel.setName("splashContent");
        this.contentPanel.setBackground(Color.white);
        this.productLabel.setFont(new Font("Serif", 2, 10));
        this.productLabel.setForeground(Color.blue);
        this.productLabel.setText(Adempiere.getSubtitle());
        this.contentPanel.add((Component)this.cImage, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 10), 0, 0));
        this.contentPanel.add((Component)this.productLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 10), 0, 0));
        this.contentPanel.add((Component)this.message, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 10, 10), 0, 0));
        this.add((Component)this.aImage, "West");
        this.add((Component)this.contentPanel, "East");
    }

    public void setText(String text) {
        this.message.setText(text);
        this.display();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.toFront();
        }
    }

    private void display() {
        this.pack();
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = this.getBounds();
        this.setBounds((ss.width - bounds.width) / 2, (ss.height - bounds.height) / 2, bounds.width, bounds.height);
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        s_splash = null;
    }

    private class AImage
    extends Component {
        private static final long serialVersionUID = -3003967119777877704L;
        private Image m_image = null;
        private Dimension m_dim = null;

        public AImage() {
            URL url = Adempiere.class.getResource("images/Java_anim.gif");
            if (url == null) {
                url = Adempiere.class.getResource("images/Java_logo.gif");
            }
            if (url != null) {
                this.m_image = Toolkit.getDefaultToolkit().getImage(url);
                Splash.this.tracker.addImage(this.m_image, 1);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            try {
                Splash.this.tracker.waitForID(1);
            }
            catch (Exception e) {
                System.err.println("Splash.AImage");
                e.printStackTrace();
            }
            this.m_dim = new Dimension(this.m_image.getWidth(this) + 15, this.m_image.getHeight(this) + 15);
            return this.m_dim;
        }

        @Override
        public void paint(Graphics g) {
            if (Splash.this.tracker.checkID(1)) {
                g.drawImage(this.m_image, 10, 10, this);
            }
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }
    }

    private class CImage
    extends Component {
        private static final long serialVersionUID = -4980770762959724071L;
        private Image m_image = Adempiere.getImageLogo();
        private Dimension m_dim = null;

        public CImage() {
            Splash.this.tracker.addImage(this.m_image, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            try {
                Splash.this.tracker.waitForID(0);
            }
            catch (Exception e) {
                System.err.println("Splash.CImage");
                e.printStackTrace();
            }
            this.m_dim = new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this));
            return this.m_dim;
        }

        @Override
        public void paint(Graphics g) {
            if (Splash.this.tracker.checkID(0)) {
                g.drawImage(this.m_image, 0, 0, this);
            }
        }
    }
}

