/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.TrxRunnable;

public class Trx
implements VetoableChangeListener {
    private static CCache<String, Trx> s_cache = null;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Connection m_connection = null;
    private String m_trxName = null;
    private boolean m_active = false;
    private long m_startTime;

    public static synchronized Trx get(String trxName, boolean createNew) {
        Trx retValue;
        if (trxName == null || trxName.length() == 0) {
            throw new IllegalArgumentException("No Transaction Name");
        }
        if (s_cache == null) {
            s_cache = new CCache("Trx", 10, -1);
            s_cache.addVetoableChangeListener(new Trx("controller"));
        }
        if ((retValue = s_cache.get(trxName)) == null && createNew) {
            retValue = new Trx(trxName);
            s_cache.put(trxName, retValue);
        }
        return retValue;
    }

    public static String createTrxName(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            prefix = "Trx";
        }
        prefix = prefix + "_" + UUID.randomUUID();
        Trx.get(prefix, true);
        return prefix;
    }

    public static String createTrxName() {
        return Trx.createTrxName(null);
    }

    private Trx(String trxName) {
        this(trxName, null);
    }

    private Trx(String trxName, Connection con) {
        this.setTrxName(trxName);
        this.setConnection(con);
    }

    public Connection getConnection() {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean createNew) {
        this.log.log(Level.ALL, "Active=" + this.isActive() + ", Connection=" + this.m_connection);
        if (this.m_connection == null) {
            if (createNew) {
                if (s_cache == null || !s_cache.containsKey(this.m_trxName)) {
                    new Exception("Illegal to getConnection for Trx that is not register.").printStackTrace();
                    return null;
                }
                this.setConnection(DB.createConnection(false, 2));
            } else {
                return null;
            }
        }
        if (!this.isActive()) {
            this.start();
        }
        return this.m_connection;
    }

    private void setConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        this.m_connection = conn;
        this.log.finest("Connection=" + conn);
        try {
            this.m_connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "connection", e);
        }
    }

    private void setTrxName(String trxName) {
        if (trxName == null || trxName.length() == 0) {
            throw new IllegalArgumentException("No Transaction Name");
        }
        this.m_trxName = trxName;
    }

    public String getTrxName() {
        return this.m_trxName;
    }

    public boolean start() {
        if (this.m_active) {
            this.log.warning("Trx in progress " + this.m_trxName);
            return false;
        }
        this.m_active = true;
        this.m_startTime = System.currentTimeMillis();
        return true;
    }

    public Date getStartTime() {
        return new Date(this.m_startTime);
    }

    public boolean isActive() {
        return this.m_active;
    }

    public boolean rollback(boolean throwException) throws SQLException {
        block3: {
            try {
                if (this.m_connection != null) {
                    this.m_connection.rollback();
                    this.log.info("**** " + this.m_trxName);
                    this.m_active = false;
                    return true;
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, this.m_trxName, e);
                if (!throwException) break block3;
                this.m_active = false;
                throw e;
            }
        }
        this.m_active = false;
        return false;
    }

    public boolean rollback() {
        try {
            return this.rollback(false);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean rollback(Savepoint savepoint) throws SQLException {
        try {
            if (this.m_connection != null) {
                this.m_connection.rollback(savepoint);
                this.log.info("**** " + this.m_trxName);
                return true;
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, this.m_trxName, e);
            throw e;
        }
        return false;
    }

    public boolean commit(boolean throwException) throws SQLException {
        block3: {
            try {
                if (this.m_connection != null) {
                    this.m_connection.commit();
                    this.log.log(this.isLocalTrx(this.m_trxName) ? Level.FINE : Level.INFO, "**** " + this.m_trxName);
                    this.m_active = false;
                    return true;
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, this.m_trxName, e);
                if (!throwException) break block3;
                this.m_active = false;
                throw e;
            }
        }
        this.m_active = false;
        return false;
    }

    public boolean commit() {
        try {
            return this.commit(false);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public synchronized boolean close() {
        if (s_cache != null) {
            s_cache.remove(this.getTrxName());
        }
        if (this.m_connection == null) {
            return true;
        }
        if (this.isActive()) {
            this.commit();
        }
        try {
            this.m_connection.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, this.m_trxName, e);
        }
        this.m_connection = null;
        this.m_active = false;
        this.log.config(this.m_trxName);
        return true;
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.m_connection == null) {
            this.getConnection();
        }
        if (this.m_connection != null) {
            if (name != null) {
                return this.m_connection.setSavepoint(name);
            }
            return this.m_connection.setSavepoint();
        }
        return null;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (DB.isOracle()) {
            return;
        }
        if (this.m_connection == null) {
            this.getConnection();
        }
        if (this.m_connection != null) {
            this.m_connection.releaseSavepoint(savepoint);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Trx[");
        sb.append(this.getTrxName()).append(",Active=").append(this.isActive()).append("]");
        return sb.toString();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.log.info(evt.toString());
        throw new PropertyVetoException("Skip reset for trx entries cache", evt);
    }

    public static Trx[] getActiveTransactions() {
        Collection<Trx> collections = s_cache.values();
        Trx[] trxs = new Trx[collections.size()];
        collections.toArray(trxs);
        return trxs;
    }

    public static void run(TrxRunnable r) {
        Trx.run(null, r);
    }

    public static void run(String trxName, TrxRunnable r) {
        boolean localTrx = false;
        if (trxName == null) {
            trxName = Trx.createTrxName("TrxRun");
            localTrx = true;
        }
        Trx trx = Trx.get(trxName, true);
        Savepoint savepoint = null;
        try {
            if (!localTrx) {
                savepoint = trx.setSavepoint(null);
            }
            r.run(trxName);
            if (localTrx) {
                trx.commit(true);
            }
        }
        catch (Throwable e) {
            if (localTrx) {
                trx.rollback();
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException e2) {
                    // empty catch block
                }
            }
            trx = null;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new AdempiereException(e);
        }
        finally {
            if (localTrx && trx != null) {
                trx.close();
                trx = null;
            }
        }
    }

    private boolean isLocalTrx(String trxName) {
        return trxName == null || trxName.startsWith("POSave");
    }
}

