/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MRMA;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.ReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextPane;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class VInOutInvoiceGen
extends CPanel
implements FormPanel,
ActionListener,
VetoableChangeListener,
ChangeListener,
TableModelListener,
ASyncProcess {
    private static final long serialVersionUID = -2327667535691916715L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private boolean m_selectionActive = true;
    private Object m_M_Warehouse_ID = null;
    private Object m_C_BPartner_ID = null;
    private static CLogger log = CLogger.getCLogger(VInOutInvoiceGen.class);
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel selPanel = new CPanel();
    private CPanel selNorthPanel = new CPanel();
    private BorderLayout selPanelLayout = new BorderLayout();
    private CLabel lWarehouse = new CLabel();
    private VLookup fWarehouse;
    private CLabel lBPartner = new CLabel();
    private VLookup fBPartner;
    private FlowLayout northPanelLayout = new FlowLayout();
    private ConfirmPanel confirmPanelSel = new ConfirmPanel(true);
    private ConfirmPanel confirmPanelGen = new ConfirmPanel(false, true, false, false, false, false, true);
    private StatusBar statusBar = new StatusBar();
    private CPanel genPanel = new CPanel();
    private BorderLayout genLayout = new BorderLayout();
    private CTextPane info = new CTextPane();
    private JScrollPane scrollPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private CLabel lDocType = new CLabel();
    private VComboBox cmbDocType = new VComboBox();
    private ArrayList<Integer> selection = null;
    private StringBuffer iText = new StringBuffer();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            this.fillPicks();
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.tabbedPane, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", ex);
        }
    }

    void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.selPanel.setLayout(this.selPanelLayout);
        this.lWarehouse.setLabelFor(this.fWarehouse);
        this.lBPartner.setLabelFor(this.fBPartner);
        this.lBPartner.setText("BPartner");
        this.selNorthPanel.setLayout(this.northPanelLayout);
        this.northPanelLayout.setAlignment(0);
        this.tabbedPane.add((Component)this.selPanel, Msg.getMsg(Env.getCtx(), "Select"));
        this.selPanel.add((Component)this.selNorthPanel, "North");
        this.selNorthPanel.add((Component)this.lWarehouse, null);
        this.selNorthPanel.add((Component)this.fWarehouse, null);
        this.selNorthPanel.add((Component)this.lBPartner, null);
        this.selNorthPanel.add((Component)this.fBPartner, null);
        this.selPanel.setName("selPanel");
        this.selPanel.add((Component)this.confirmPanelSel, "South");
        this.selPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.miniTable, null);
        this.confirmPanelSel.addActionListener(this);
        this.tabbedPane.add((Component)this.genPanel, Msg.getMsg(Env.getCtx(), "Generate"));
        this.genPanel.setLayout(this.genLayout);
        this.genPanel.add((Component)this.info, "Center");
        this.genPanel.setEnabled(false);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.info.setEditable(false);
        this.genPanel.add((Component)this.confirmPanelGen, "South");
        this.confirmPanelGen.addActionListener(this);
        this.lDocType.setLabelFor(this.cmbDocType);
        this.selNorthPanel.add((Component)this.lDocType, null);
        this.selNorthPanel.add((Component)this.cmbDocType, null);
    }

    private void fillPicks() throws Exception {
        MLookup orgL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 2223, 19);
        this.fWarehouse = new VLookup("M_Warehouse_ID", true, false, true, orgL);
        this.lWarehouse.setText(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        this.fWarehouse.addVetoableChangeListener(this);
        this.m_M_Warehouse_ID = this.fWarehouse.getValue();
        MLookup bpL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 2762, 30);
        this.fBPartner = new VLookup("C_BPartner_ID", false, false, true, bpL);
        this.lBPartner.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.fBPartner.addVetoableChangeListener(this);
        this.lDocType.setText(Msg.translate(Env.getCtx(), "C_DocType_ID"));
        this.cmbDocType.addItem(new KeyNamePair(MOrder.Table_ID, Msg.translate(Env.getCtx(), "Order")));
        this.cmbDocType.addItem(new KeyNamePair(MRMA.Table_ID, Msg.translate(Env.getCtx(), "VendorRMA")));
        this.cmbDocType.addActionListener(this);
    }

    private void dynInit() {
        this.miniTable.addColumn("C_Order_ID");
        this.miniTable.addColumn("AD_Org_ID");
        this.miniTable.addColumn("C_DocType_ID");
        this.miniTable.addColumn("DocumentNo");
        this.miniTable.addColumn("C_BPartner_ID");
        this.miniTable.addColumn("DateOrdered");
        this.miniTable.addColumn("TotalLines");
        this.miniTable.setMultiSelection(true);
        this.miniTable.setRowSelectionAllowed(true);
        this.miniTable.setColumnClass(0, IDColumn.class, false, " ");
        this.miniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "AD_Org_ID"));
        this.miniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_DocType_ID"));
        this.miniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "DocumentNo"));
        this.miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.miniTable.setColumnClass(5, Timestamp.class, true, Msg.translate(Env.getCtx(), "DateOrdered"));
        this.miniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "TotalLines"));
        this.miniTable.autoSize();
        this.miniTable.getModel().addTableModelListener(this);
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InOutGenerateSel"));
        this.statusBar.setStatusDB(" ");
        this.tabbedPane.addChangeListener(this);
    }

    private String getOrderSQL() {
        int AD_User_ID;
        String lockedIDs;
        StringBuffer sql = new StringBuffer("SELECT C_Order_ID, o.Name, dt.Name, DocumentNo, bp.Name, DateOrdered, TotalLines FROM M_InOut_Candidate_v ic, AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.AD_Client_ID=?");
        if (this.m_M_Warehouse_ID != null) {
            sql.append(" AND ic.M_Warehouse_ID=").append(this.m_M_Warehouse_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND ic.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if ((lockedIDs = MPrivateAccess.getLockedRecordWhere(MOrder.Table_ID, AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID"))) != null) {
            if (sql.length() > 0) {
                sql.append(" AND ");
            }
            sql.append("C_Order_ID").append(lockedIDs);
        }
        sql.append(" ORDER BY o.Name,bp.Name,DateOrdered");
        return sql.toString();
    }

    private String getRMASql() {
        int AD_User_ID;
        String lockedIDs;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT rma.M_RMA_ID, org.Name, dt.Name, rma.DocumentNo, bp.Name, rma.Created, rma.Amt ");
        sql.append("FROM M_RMA rma INNER JOIN AD_Org org ON rma.AD_Org_ID=org.AD_Org_ID ");
        sql.append("INNER JOIN C_DocType dt ON rma.C_DocType_ID=dt.C_DocType_ID ");
        sql.append("INNER JOIN C_BPartner bp ON rma.C_BPartner_ID=bp.C_BPartner_ID ");
        sql.append("INNER JOIN M_InOut io ON rma.InOut_ID=io.M_InOut_ID ");
        sql.append("WHERE rma.DocStatus='CO' ");
        sql.append("AND dt.DocBaseType = 'POO' ");
        sql.append("AND EXISTS (SELECT * FROM M_RMA r INNER JOIN M_RMALine rl ");
        sql.append("ON r.M_RMA_ID=rl.M_RMA_ID WHERE r.M_RMA_ID=rma.M_RMA_ID ");
        sql.append("AND rl.IsActive='Y' AND rl.M_InOutLine_ID > 0 AND rl.QtyDelivered < rl.Qty) ");
        sql.append("AND NOT EXISTS (SELECT * FROM M_InOut oio WHERE oio.M_RMA_ID=rma.M_RMA_ID ");
        sql.append("AND oio.DocStatus IN ('IP', 'CO', 'CL')) ");
        sql.append("AND rma.AD_Client_ID=?");
        if (this.m_M_Warehouse_ID != null) {
            sql.append(" AND io.M_Warehouse_ID=").append(this.m_M_Warehouse_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND bp.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if ((lockedIDs = MPrivateAccess.getLockedRecordWhere(MRMA.Table_ID, AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID"))) != null) {
            sql.append(" AND rma.M_RMA_ID").append(lockedIDs);
        }
        sql.append(" ORDER BY org.Name, bp.Name, rma.Created ");
        return sql.toString();
    }

    private void executeQuery() {
        log.info("");
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String sql = "";
        KeyNamePair docTypeKNPair = (KeyNamePair)this.cmbDocType.getSelectedItem();
        sql = docTypeKNPair.getKey() == MRMA.Table_ID ? this.getRMASql() : this.getOrderSQL();
        log.fine(sql);
        int row = 0;
        this.miniTable.setRowCount(row);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.miniTable.setRowCount(row + 1);
                this.miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, 0);
                this.miniTable.setValueAt(rs.getString(2), row, 1);
                this.miniTable.setValueAt(rs.getString(3), row, 2);
                this.miniTable.setValueAt(rs.getString(4), row, 3);
                this.miniTable.setValueAt(rs.getString(5), row, 4);
                this.miniTable.setValueAt(rs.getTimestamp(6), row, 5);
                this.miniTable.setValueAt(rs.getBigDecimal(7), row, 6);
                ++row;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.miniTable.autoSize();
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Cmd=" + e.getActionCommand());
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        if (this.cmbDocType.equals(e.getSource())) {
            this.executeQuery();
            return;
        }
        this.saveSelection();
        if (this.selection != null && this.selection.size() > 0 && this.m_selectionActive && this.m_M_Warehouse_ID != null) {
            this.generateShipments();
        } else {
            this.dispose();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        log.info(e.getPropertyName() + "=" + e.getNewValue());
        if (e.getPropertyName().equals("M_Warehouse_ID")) {
            this.m_M_Warehouse_ID = e.getNewValue();
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            this.m_C_BPartner_ID = e.getNewValue();
            this.fBPartner.setValue(this.m_C_BPartner_ID);
        }
        this.executeQuery();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        this.m_selectionActive = index == 0;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int rowsSelected = 0;
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            ++rowsSelected;
        }
        this.statusBar.setStatusDB(" " + rowsSelected + " ");
    }

    private void saveSelection() {
        log.info("");
        this.miniTable.editingStopped(new ChangeEvent(this));
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.selection = null;
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            results.add(id.getRecord_ID());
        }
        if (results.size() == 0) {
            return;
        }
        log.config("Selected #" + results.size());
        this.selection = results;
    }

    private void generateShipments() {
        log.info("M_Warehouse_ID=" + this.m_M_Warehouse_ID);
        String trxName = Trx.createTrxName("IOG");
        Trx trx = Trx.get(trxName, true);
        this.m_selectionActive = false;
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InOutGenerateGen"));
        this.statusBar.setStatusDB(String.valueOf(this.selection.size()));
        int AD_Process_ID = 0;
        KeyNamePair docTypeKNPair = (KeyNamePair)this.cmbDocType.getSelectedItem();
        AD_Process_ID = docTypeKNPair.getKey() == MRMA.Table_ID ? 52001 : 199;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            this.info.setText(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            return;
        }
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : this.selection) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(instance.getAD_PInstance_ID());
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter != 1000) continue;
            if (DB.executeUpdate(insert.toString(), trxName) < 0) {
                String msg = "No Shipments";
                log.config(msg);
                this.info.setText(msg);
                trx.rollback();
                return;
            }
            insert = new StringBuffer();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0 && DB.executeUpdate(insert.toString(), trxName) < 0) {
            String msg = "No Shipments";
            log.config(msg);
            this.info.setText(msg);
            trx.rollback();
            return;
        }
        ProcessInfo pi = new ProcessInfo("VInOutGen", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        if (!ip.save()) {
            String msg = "No Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("M_Warehouse_ID", Integer.parseInt(this.m_M_Warehouse_ID.toString()));
        if (!ip.save()) {
            String msg = "No Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ProcessCtl worker = new ProcessCtl(this, Env.getWindowNo(this), pi, trx);
        worker.start();
    }

    private void generateShipments_complete(ProcessInfo pi) {
        this.tabbedPane.setSelectedIndex(1);
        ProcessInfoUtil.setLogFromDB(pi);
        this.iText.append("<b>").append(pi.getSummary()).append("</b><br>(").append(Msg.getMsg(Env.getCtx(), "InOutGenerateInfo")).append(")<br>").append(pi.getLogInfo(true));
        this.info.setText(this.iText.toString());
        int[] ids = pi.getIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        log.config("PrintItems=" + ids.length);
        this.confirmPanelGen.getOKButton().setEnabled(false);
        if (ADialog.ask(this.m_WindowNo, this, "PrintShipments")) {
            ADialogDialog d;
            this.setCursor(Cursor.getPredefinedCursor(3));
            int retValue = ADialogDialog.A_CANCEL;
            do {
                for (int i = 0; i < ids.length; ++i) {
                    int M_InOut_ID = ids[i];
                    ReportCtl.startDocumentPrint(1, M_InOut_ID, this, Env.getWindowNo(this), true);
                }
            } while ((retValue = (d = new ADialogDialog((Frame)this.m_frame, Env.getHeader(Env.getCtx(), this.m_WindowNo), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.confirmPanelGen.getOKButton().setEnabled(true);
    }

    private void generateInvoices() {
        String trxName = Trx.createTrxName("IVG");
        Trx trx = Trx.get(trxName, true);
        this.m_selectionActive = false;
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InvGenerateGen"));
        this.statusBar.setStatusDB(String.valueOf(this.selection.size()));
        int AD_Process_ID = 0;
        KeyNamePair docTypeKNPair = (KeyNamePair)this.cmbDocType.getSelectedItem();
        AD_Process_ID = docTypeKNPair.getKey() == MRMA.Table_ID ? 52002 : 134;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            this.info.setText(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            return;
        }
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : this.selection) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(instance.getAD_PInstance_ID());
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter != 1000) continue;
            if (DB.executeUpdate(insert.toString(), trxName) < 0) {
                String msg = "No Shipments";
                log.config(msg);
                this.info.setText(msg);
                trx.rollback();
                return;
            }
            insert = new StringBuffer();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0 && DB.executeUpdate(insert.toString(), trxName) < 0) {
            String msg = "No Shipments";
            log.config(msg);
            this.info.setText(msg);
            trx.rollback();
            return;
        }
        ProcessInfo pi = new ProcessInfo("", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara para = new MPInstancePara(instance, 10);
        para.setParameter("Selection", "Y");
        if (!para.save()) {
            String msg = "No Selection Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        para = new MPInstancePara(instance, 20);
        para.setParameter("DocAction", "CO");
        if (!para.save()) {
            String msg = "No DocAction Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ProcessCtl worker = new ProcessCtl(this, Env.getWindowNo(this), pi, trx);
        worker.start();
    }

    private void generateInvoice_complete(ProcessInfo pi) {
        this.tabbedPane.setSelectedIndex(1);
        ProcessInfoUtil.setLogFromDB(pi);
        this.iText.append("<b>").append(pi.getSummary()).append("</b><br>(").append(Msg.getMsg(Env.getCtx(), "InvGenerateInfo")).append(")<br>").append(pi.getLogInfo(true));
        this.info.setText(this.iText.toString());
        int[] ids = pi.getIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        this.confirmPanelGen.getOKButton().setEnabled(false);
        if (ADialog.ask(this.m_WindowNo, this, "PrintInvoices")) {
            ADialogDialog d;
            this.setCursor(Cursor.getPredefinedCursor(3));
            int retValue = ADialogDialog.A_CANCEL;
            do {
                for (int i = 0; i < ids.length; ++i) {
                    int C_Invoice_ID = ids[i];
                    ReportCtl.startDocumentPrint(2, C_Invoice_ID, this, Env.getWindowNo(this), true);
                }
            } while ((retValue = (d = new ADialogDialog((Frame)this.m_frame, Env.getHeader(Env.getCtx(), this.m_WindowNo), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.confirmPanelGen.getOKButton().setEnabled(true);
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        if (pi.getAD_Process_ID() == 199) {
            this.generateShipments_complete(pi);
            this.generateInvoices();
        }
        if (pi.getAD_Process_ID() == 134) {
            this.generateInvoice_complete(pi);
            this.setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public boolean isUILocked() {
        return this.isEnabled();
    }

    @Override
    public void executeASync(ProcessInfo pi) {
    }
}

