/*
 * Decompiled with CFR 0.152.
 */
package test.functional.inventory;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPGroup;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCharge;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocation;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductPrice;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import test.functional.inventory.MMDocument;

public final class InventoryUtil {
    public static MProduct getCreateProduct(String value, String MMPolicy) {
        Properties ctx = Env.getCtx();
        MProduct product = (MProduct)new Query(ctx, "M_Product", "Value=?", null).setParameters(value).setOnlyActiveRecords(true).setClient_ID().firstOnly();
        if (product == null) {
            product = new MProduct(ctx, 0, null);
        }
        product.setValue(value);
        product.setName(value);
        InventoryUtil.setGeneratedTag(product);
        product.setProductType("I");
        product.setIsStocked(true);
        product.setC_UOM_ID(100);
        product.setC_TaxCategory_ID(InventoryUtil.getDefault_TaxCategory_ID());
        product.setM_Product_Category_ID(InventoryUtil.getCreateProductCategory(value, MMPolicy).get_ID());
        product.saveEx();
        InventoryUtil.getCreateProductPrice("#PO_PriceList_ID", product.get_ID(), 10);
        InventoryUtil.getCreateProductPrice("#SO_PriceList_ID", product.get_ID(), 20);
        return product;
    }

    public static MProductPrice getCreateProductPrice(String ctxPriceList, int M_Product_ID, int price) {
        Properties ctx = Env.getCtx();
        int M_PriceList_ID = Env.getContextAsInt(ctx, ctxPriceList);
        MPriceList pl = MPriceList.get(ctx, M_PriceList_ID, null);
        MPriceListVersion plv = pl.getPriceListVersion(null);
        BigDecimal priceBD = BigDecimal.valueOf(price);
        MProductPrice pp = MProductPrice.get(ctx, plv.get_ID(), M_Product_ID, null);
        if (pp == null) {
            pp = new MProductPrice(plv, M_Product_ID, priceBD, priceBD, priceBD);
        }
        pp.setPrices(priceBD, priceBD, priceBD);
        pp.saveEx();
        return pp;
    }

    public static MProductCategory getCreateProductCategory(String value, String MMPolicy) {
        if (MMPolicy == null) {
            MMPolicy = "F";
        }
        Properties ctx = Env.getCtx();
        String whereClause = "Value=?";
        MProductCategory pc = (MProductCategory)new Query(ctx, "M_Product_Category", "Value=?", null).setParameters(value).setOnlyActiveRecords(true).setClient_ID().firstOnly();
        if (pc == null) {
            pc = new MProductCategory(ctx, 0, null);
        }
        pc.setValue(value);
        pc.setName(value);
        InventoryUtil.setGeneratedTag(pc);
        pc.setMMPolicy(MMPolicy);
        pc.saveEx();
        return pc;
    }

    public static int getDefault_TaxCategory_ID() {
        Properties ctx = Env.getCtx();
        MTaxCategory taxCategory = (MTaxCategory)new Query(ctx, "C_TaxCategory", "IsDefault='Y'", null).setClient_ID().setOnlyActiveRecords(true).firstOnly();
        return taxCategory != null ? taxCategory.get_ID() : 0;
    }

    public static MBPartner getCreatePartner(String value) {
        Properties ctx = Env.getCtx();
        String whereClause = "Value=?";
        MBPartner bp = (MBPartner)new Query(ctx, "C_BPartner", "Value=?", null).setParameters(value).setClient_ID().firstOnly();
        if (bp == null) {
            bp = new MBPartner(ctx, 0, null);
        }
        bp.setValue(value);
        bp.setName(value);
        InventoryUtil.setGeneratedTag(bp);
        bp.setIsCustomer(true);
        bp.setIsVendor(true);
        bp.setC_BP_Group_ID(MBPGroup.getDefault(ctx).get_ID());
        bp.saveEx();
        if (bp.getLocations(false).length == 0) {
            MLocation loc = new MLocation(ctx, 0, null);
            loc.saveEx();
            MBPartnerLocation bpl = new MBPartnerLocation(bp);
            bpl.setC_Location_ID(loc.get_ID());
            bpl.saveEx();
        }
        return bp;
    }

    public static MOrder createOrder(MMDocument doc, String trxName) {
        boolean isSOTrx;
        int M_PriceList_ID;
        Properties ctx = Env.getCtx();
        if ("SOO".equals(doc.DocBaseType)) {
            M_PriceList_ID = Env.getContextAsInt(ctx, "SO_PriceList_ID");
            isSOTrx = true;
        } else if ("POO".equals(doc.DocBaseType)) {
            M_PriceList_ID = Env.getContextAsInt(ctx, "PO_PriceList_ID");
            isSOTrx = false;
        } else {
            throw new IllegalArgumentException("DocBaseType not supported - " + doc);
        }
        int AD_Org_ID = InventoryUtil.getFirst_Org_ID();
        MLocator locator = InventoryUtil.getCreateLocator(AD_Org_ID, doc.LocatorValue, doc.LocatorValue);
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setAD_Org_ID(AD_Org_ID);
        order.setIsSOTrx(isSOTrx);
        order.setC_DocTypeTarget_ID();
        order.setDateOrdered(doc.Date);
        order.setDateAcct(doc.Date);
        order.setDatePromised(doc.Date);
        order.setBPartner(InventoryUtil.getCreatePartner(doc.BPValue));
        order.setM_PriceList_ID(M_PriceList_ID);
        order.setM_Warehouse_ID(locator.getM_Warehouse_ID());
        InventoryUtil.setGeneratedTag(order);
        order.saveEx();
        MProduct product = InventoryUtil.getCreateProduct(doc.ProductValue, null);
        MOrderLine line = new MOrderLine(order);
        line.setProduct(product);
        line.setQty(doc.Qty);
        line.saveEx();
        doc.document = order;
        InventoryUtil.processDocument(doc, "CO", "CO");
        return order;
    }

    public static MInOut createInOut(MMDocument doc, String trxName) {
        MOrder order;
        if ("MMR".equals(doc.DocBaseType)) {
            order = (MOrder)doc.scenario.get((String)"POO", (String)doc.PODocumentNo).document;
        } else if ("MMS".equals(doc.DocBaseType)) {
            order = (MOrder)doc.scenario.get((String)"SOO", (String)doc.PODocumentNo).document;
        } else {
            throw new IllegalArgumentException("DocBaseType not supported - " + doc);
        }
        MInOut io = new MInOut(order, 0, doc.Date);
        InventoryUtil.setGeneratedTag(io);
        io.saveEx();
        MInOutLine iol = null;
        MOrderLine[] arr$ = order.getLines(true, null);
        int len$ = arr$.length;
        int i$ = 0;
        if (i$ < len$) {
            MOrderLine oline = arr$[i$];
            iol = new MInOutLine(io);
            iol.setOrderLine(oline, 0, doc.Qty);
            iol.setQty(doc.Qty);
            iol.saveEx();
        }
        doc.document = io;
        InventoryUtil.processDocument(doc, "CO", "CO");
        if (!Util.isEmpty(doc.ASI)) {
            iol.load(trxName);
            doc.scenario.registerASICode(doc.ASI, iol.getM_AttributeSetInstance_ID(), !io.isSOTrx());
        }
        return io;
    }

    public static MMovement createMovement(MMDocument doc, String trxName) {
        Properties ctx = Env.getCtx();
        int AD_Org_ID = InventoryUtil.getFirst_Org_ID();
        MProduct product = InventoryUtil.getCreateProduct(doc.ProductValue, null);
        MLocator locator = InventoryUtil.getCreateLocator(AD_Org_ID, doc.LocatorValue, doc.LocatorValue);
        MLocator locatorTo = InventoryUtil.getCreateLocator(AD_Org_ID, doc.LocatorValueTo, doc.LocatorValueTo);
        MMovement m = new MMovement(ctx, 0, trxName);
        m.setAD_Org_ID(AD_Org_ID);
        m.setMovementDate(doc.Date);
        m.saveEx();
        MMovementLine line = new MMovementLine(m);
        line.setM_Product_ID(product.get_ID());
        line.setM_Locator_ID(locator.get_ID());
        line.setM_LocatorTo_ID(locatorTo.get_ID());
        line.setMovementQty(doc.Qty);
        line.saveEx();
        doc.document = m;
        InventoryUtil.processDocument(doc, "CO", "CO");
        return m;
    }

    public static MInventory createInventory(MMDocument doc, String trxName) {
        Properties ctx = Env.getCtx();
        int AD_Org_ID = InventoryUtil.getFirst_Org_ID();
        MProduct product = InventoryUtil.getCreateProduct(doc.ProductValue, null);
        MLocator locator = InventoryUtil.getCreateLocator(AD_Org_ID, doc.LocatorValue, doc.LocatorValue);
        MInventory inv = new MInventory(ctx, 0, trxName);
        inv.setAD_Org_ID(AD_Org_ID);
        inv.setMovementDate(doc.Date);
        inv.setM_Warehouse_ID(locator.getM_Warehouse_ID());
        InventoryUtil.setGeneratedTag(inv);
        inv.saveEx();
        MInventoryLine line = new MInventoryLine(inv, locator.get_ID(), product.get_ID(), 0, null, null);
        line.setQtyInternalUse(doc.Qty);
        line.setC_Charge_ID(InventoryUtil.getCreateCharge("junit-charge").get_ID());
        line.saveEx();
        doc.document = inv;
        InventoryUtil.processDocument(doc, "CO", "CO");
        if (!Util.isEmpty(doc.ASI)) {
            line.load(trxName);
            doc.scenario.registerASICode(doc.ASI, line.getM_AttributeSetInstance_ID(), line.getQtyInternalUse().signum() <= 0);
        }
        return inv;
    }

    public static int getFirst_Org_ID() {
        int AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        if (AD_Org_ID > 0) {
            return AD_Org_ID;
        }
        String sql = "SELECT MIN(AD_Org_ID) FROM AD_Org WHERE AD_Client_ID=?";
        return DB.getSQLValueEx(null, sql, Env.getAD_Client_ID(Env.getCtx()));
    }

    public static MWarehouse getCreateWarehouse(int AD_Org_ID, String value) {
        if (AD_Org_ID <= 0) {
            AD_Org_ID = InventoryUtil.getFirst_Org_ID();
        }
        Properties ctx = Env.getCtx();
        String whereClause = "AD_Org_ID=? AND Value=?";
        MWarehouse wh = (MWarehouse)new Query(ctx, "M_Warehouse", "AD_Org_ID=? AND Value=?", null).setParameters(AD_Org_ID, value).setClient_ID().firstOnly();
        if (wh != null) {
            return wh;
        }
        wh = new MWarehouse(ctx, 0, null);
        wh.setAD_Org_ID(AD_Org_ID);
        wh.setValue(value);
        wh.setName(value);
        MLocation loc = new MLocation(ctx, 0, null);
        loc.saveEx();
        wh.setC_Location_ID(loc.get_ID());
        wh.saveEx();
        return wh;
    }

    public static MLocator getCreateLocator(int AD_Org_ID, String whValue, String value) {
        if (AD_Org_ID <= 0) {
            AD_Org_ID = InventoryUtil.getFirst_Org_ID();
        }
        MWarehouse wh = InventoryUtil.getCreateWarehouse(AD_Org_ID, whValue);
        MLocator locator = null;
        for (MLocator loc : wh.getLocators(false)) {
            if (!loc.getValue().equals(value)) continue;
            locator = loc;
            break;
        }
        if (locator == null) {
            locator = new MLocator(wh, value);
            locator.setXYZ(value, value, value);
        }
        if (wh.getLocators(false).length == 0) {
            locator.setIsDefault(true);
        }
        locator.saveEx();
        return locator;
    }

    public static MPriceList getCreatePriceList(String value, boolean IsSOPriceList) {
        Properties ctx = Env.getCtx();
        int C_Currency_ID = Env.getContextAsInt(ctx, "$C_Currency_ID");
        String whereClause = "Name=? AND IsSOPriceList=? AND C_Currency_ID=?";
        MPriceList pl = (MPriceList)new Query(ctx, "M_PriceList", whereClause, null).setParameters(value, IsSOPriceList, C_Currency_ID).setClient_ID().setOnlyActiveRecords(true).firstOnly();
        if (pl == null) {
            pl = new MPriceList(ctx, 0, null);
            pl.setName(value);
            pl.setIsSOPriceList(IsSOPriceList);
            pl.setC_Currency_ID(C_Currency_ID);
        }
        InventoryUtil.setGeneratedTag(pl);
        pl.setIsTaxIncluded(false);
        pl.saveEx();
        Timestamp ValidFrom = TimeUtil.getDay(1970, 1, 1);
        MPriceListVersion plv = pl.getPriceListVersion(ValidFrom);
        if (plv == null) {
            plv = new MPriceListVersion(pl);
            plv.setValidFrom(ValidFrom);
            plv.setM_DiscountSchema_ID(InventoryUtil.getM_DiscountSchema_ID());
            InventoryUtil.setGeneratedTag(plv);
            plv.saveEx();
        }
        return pl;
    }

    public static int getM_DiscountSchema_ID() {
        Properties ctx = Env.getCtx();
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String sql = "SELECT MIN(M_DiscountSchema_ID) FROM M_DiscountSchema WHERE AD_Client_ID=?";
        return DB.getSQLValueEx(null, "SELECT MIN(M_DiscountSchema_ID) FROM M_DiscountSchema WHERE AD_Client_ID=?", AD_Client_ID);
    }

    public static void setGeneratedTag(PO po) {
        String desc = "Generated by " + InventoryUtil.class + " on " + new Timestamp(System.currentTimeMillis());
        po.set_ValueOfColumn("Description", (Object)desc);
    }

    public static void processDocument(MMDocument doc, String docAction, String targetDocStatus) {
        PO po = (PO)((Object)doc.document);
        po.load(po.get_TrxName());
        po.set_ValueOfColumn("DocAction", (Object)docAction);
        try {
            if (!doc.document.processIt(docAction)) {
                throw new AdempiereException(doc.document.getProcessMsg());
            }
        }
        catch (Exception e) {
            throw e instanceof AdempiereException ? (AdempiereException)e : new AdempiereException(e);
        }
        po.saveEx();
        if (targetDocStatus != null && !targetDocStatus.equals(doc.document.getDocStatus())) {
            throw new AdempiereException("Doc process error " + doc + " (TargetDocStatus=" + targetDocStatus + ", DocStatus=" + doc.document.getDocStatus() + ")");
        }
        if (!"CO".equals(doc.document.getDocStatus()) || !Util.isEmpty(doc.ASI)) {
            // empty if block
        }
    }

    public static MCharge getCreateCharge(String value) {
        Properties ctx = Env.getCtx();
        String whereClause = "Name=?";
        MCharge charge = (MCharge)new Query(ctx, "C_Charge", whereClause, null).setParameters(value).setOnlyActiveRecords(true).setClient_ID().firstOnly();
        if (charge == null) {
            charge = new MCharge(ctx, 0, null);
            charge.setName(value);
            InventoryUtil.setGeneratedTag(charge);
            charge.saveEx();
        }
        return charge;
    }
}

