/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MContactInterest;
import org.compiere.model.MInterestArea;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class InfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 7753318286119195317L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("InfoServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Interest Area Servlet";
    }

    public void destroy() {
        this.log.info("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        boolean success = this.processParameter(request);
        String url = "/info.jsp";
        this.log.info("Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        this.doGet(request, response);
    }

    private boolean processParameter(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Properties ctx = JSPEnv.getCtx(request);
        String mode = WebUtil.getParameter(request, "mode");
        if (mode == null) {
            return false;
        }
        boolean subscribe = !mode.startsWith("un");
        int R_InterestArea_ID = WebUtil.getParameterAsInt(request, "area");
        MInterestArea ia = MInterestArea.get(ctx, R_InterestArea_ID);
        int AD_User_ID = WebUtil.getParameterAsInt(request, "contact");
        this.log.fine("Subscribe=" + subscribe + ",R_InterestArea_ID=" + R_InterestArea_ID + ",AD_User_ID=" + AD_User_ID);
        if (R_InterestArea_ID == 0 || AD_User_ID == 0) {
            return false;
        }
        MContactInterest ci = MContactInterest.get(ctx, R_InterestArea_ID, AD_User_ID, false, null);
        ci.subscribe(subscribe);
        boolean ok = ci.save();
        if (ok) {
            this.log.fine("success");
        } else {
            this.log.log(Level.SEVERE, "subscribe failed");
        }
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            wu = WebUser.get(ctx, AD_User_ID);
            session.setAttribute("webUser", (Object)wu);
        }
        this.sendEMail(request, wu, ia.getName(), subscribe);
        return ok;
    }

    private void sendEMail(HttpServletRequest request, WebUser wu, String listName, boolean subscribe) {
        String msg = JSPEnv.sendEMail(request, wu, subscribe ? "LS" : "LU", new Object[]{listName, wu.getName(), listName});
    }
}

