/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;
import org.compiere.wstore.WebBasket;
import org.compiere.wstore.WebOrder;

public class OrderServlet
extends HttpServlet {
    private static final long serialVersionUID = -94012227184686536L;
    private static CLogger log = CLogger.getCLogger(OrderServlet.class);
    public static final String NAME = "orderServlet";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("OrderServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Order Servlet";
    }

    public void destroy() {
        log.fine("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Get from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MPayment p2;
        WebOrder wo;
        log.info("Post from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        WebUser wu = (WebUser)session.getAttribute("webUser");
        WebBasket wb = (WebBasket)session.getAttribute("webBasket");
        MOrder order = null;
        boolean done = false;
        String url = "/paymentInfo.jsp";
        if (wu == null || !wu.isLoggedIn()) {
            session.setAttribute("CheckOut", (Object)"Y");
            url = "/login.jsp";
            done = true;
        } else {
            order = this.getOrder(request, ctx);
        }
        if (!done && order != null) {
            if (this.processOrder(request, order)) {
                url = "/orders.jsp";
            } else {
                wo = new WebOrder(order);
                p2 = this.createPayment(session, ctx, wu, wo);
                if (p2 != null) {
                    session.setAttribute("payment", (Object)p2);
                    session.setAttribute("webOrder", (Object)wo);
                } else {
                    url = "/orders.jsp";
                }
            }
            done = true;
        }
        if (!(done || wb != null && wb.getLineCount() != 0)) {
            url = "/basket.jsp";
            done = true;
        }
        if (!done) {
            wo = new WebOrder(wu, wb, ctx);
            if (wo.isInProgress() || wo.isCompleted()) {
                session.removeAttribute("CheckOut");
                session.removeAttribute("webBasket");
                this.sendEMail(request, ctx, wo, wu);
            }
            if (wo.getGrandTotal().compareTo(Env.ZERO) > 0) {
                session.setAttribute("webOrder", (Object)wo);
                p2 = this.createPayment(session, ctx, wu, wo);
                if (p2 == null) {
                    WebUtil.createForwardPage(response, "Payment could not be created", "orders.jsp", 5);
                    return;
                }
                session.setAttribute("payment", (Object)p2);
            } else {
                url = "/orders.jsp";
            }
        }
        log.info("Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private MPayment createPayment(HttpSession session, Properties ctx, WebUser wu, WebOrder wo) {
        MPayment p2 = new MPayment(ctx, 0, null);
        p2.setAD_Org_ID(wo.getAD_Org_ID());
        p2.setIsSelfService(true);
        p2.setAmount(wo.getC_Currency_ID(), wo.getGrandTotal());
        p2.setIsOnline(true);
        p2.setC_DocType_ID(true);
        p2.setTrxType("S");
        p2.setTenderType("C");
        p2.setC_Order_ID(wo.getC_Order_ID());
        p2.setBP_BankAccount(wu.getBankAccount());
        return p2;
    }

    private MOrder getOrder(HttpServletRequest request, Properties ctx) {
        String para = WebUtil.getParameter(request, "C_Order_ID");
        if (para == null || para.length() == 0) {
            return null;
        }
        int C_Order_ID = 0;
        try {
            C_Order_ID = Integer.parseInt(para);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (C_Order_ID == 0) {
            return null;
        }
        log.fine("C_Order_ID=" + C_Order_ID);
        return new MOrder(ctx, C_Order_ID, null);
    }

    private boolean processOrder(HttpServletRequest request, MOrder order) {
        String DocAction2 = WebUtil.getParameter(request, "DocAction");
        if (DocAction2 == null || DocAction2.length() == 0) {
            return false;
        }
        MDocType dt = MDocType.get(order.getCtx(), order.getC_DocType_ID());
        if (!order.isSOTrx() || order.getGrandTotal().compareTo(Env.ZERO) <= 0 || !"SOO".equals(dt.getDocBaseType())) {
            log.warning("Not a valid Sales Order " + order);
            return true;
        }
        log.fine("DocAction=" + DocAction2);
        if (!"VO".equals(DocAction2)) {
            if ("WP".equals(order.getDocStatus())) {
                return false;
            }
            if ("PR".equals(dt.getDocSubTypeSO())) {
                return false;
            }
            if (!"CO".equals(DocAction2)) {
                log.warning("Invalid DocAction=" + DocAction2);
                return true;
            }
        }
        order.setDocAction(DocAction2, true);
        boolean ok = order.processIt(DocAction2);
        order.save();
        return ok;
    }

    private void sendEMail(HttpServletRequest request, Properties ctx, WebOrder wo, WebUser wu) {
        StringBuffer message = new StringBuffer("\n");
        MOrder mo = wo.getOrder();
        if (mo != null) {
            MOrderLine[] ol = mo.getLines(true, null);
            for (int i = 0; i < ol.length; ++i) {
                message.append("\n").append(ol[i].getQtyOrdered()).append(" * ").append(ol[i].getName());
                if (ol[i].getDescription() != null) {
                    message.append(" - ").append(ol[i].getDescription());
                }
                message.append(" (").append(ol[i].getPriceActual()).append(") = ").append(ol[i].getLineNetAmt());
            }
        }
        message.append("\n\n").append(Msg.getElement(ctx, "C_Order_ID")).append(": ").append(wo.getDocumentNo()).append(" - ").append(Msg.getElement(ctx, "GrandTotal")).append(": ").append(wo.getGrandTotal());
        JSPEnv.sendEMail(request, wu, "OA", new Object[]{wo.getDocumentNo(), wu.getName(), message.toString()});
    }
}

