/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.MChat;
import org.compiere.model.MChatEntry;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WWindowStatus;

public class WChat
extends HttpServlet {
    private static final long serialVersionUID = 6826855534161342772L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private MChat m_chat;
    private boolean m_readOnly;
    private boolean m_hasDependents;
    private boolean m_hasCallout;
    private int m_displayLength;
    private String m_columnName;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WChat.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.fine("doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = null;
        if (ws == null) {
            doc = WebDoc.createPopup("No Context");
            doc.addPopupClose(wsc.ctx);
        } else {
            doc = this.CreateChatPage(ws, wsc, doc, 0);
        }
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebDoc doc = null;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String data = WebUtil.getParameter(request, "chatinput");
        int CM_ChatID = WebUtil.getParameterAsInt(request, "CM_ChatID");
        int AD_Table_ID = WebUtil.getParameterAsInt(request, "AD_Table_ID");
        int record_ID = WebUtil.getParameterAsInt(request, "record_ID");
        String description = WebUtil.getParameter(request, "description");
        if (data != null && data.length() > 0) {
            if (CM_ChatID == 0) {
                this.m_chat = new MChat(wsc.ctx, AD_Table_ID, record_ID, description, null);
                this.m_chat.save();
            }
            MChatEntry entry = new MChatEntry(this.m_chat, data);
            entry.save();
        }
        doc = this.CreateChatPage(ws, wsc, doc, this.m_chat.getCM_Chat_ID());
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private td getTextField(String data, int rows) {
        textarea text = new textarea(this.m_columnName, rows, this.m_displayLength).addElement(Util.maskHTML(data));
        text.setID(this.m_columnName + "F");
        text.setName(this.m_columnName);
        text.setDisabled(this.m_readOnly);
        if (this.m_hasDependents || this.m_hasCallout) {
            text.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)text);
    }

    private td createTD(Element element) {
        td td2 = new td().addElement(element).setAlign("left").setVAlign("top");
        td2.setColSpan(3);
        return td2;
    }

    private WebDoc CreateChatPage(WWindowStatus ws, WebSessionCtx wsc, WebDoc doc, int CM_Chat_ID) {
        doc = WebDoc.createPopup("Chat ");
        td center = doc.addWindowCenter(false);
        int record_ID = ws.curTab.getRecord_ID();
        this.log.info("Record_ID=" + record_ID);
        if (record_ID == -1) {
            this.log.info("Record does not exist");
            return doc;
        }
        String infoName = null;
        String infoDisplay = null;
        for (int i = 0; i < ws.curTab.getFieldCount(); ++i) {
            GridField field = ws.curTab.getField(i);
            if (field.isKey()) {
                infoName = field.getHeader();
            }
            if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                infoDisplay = field.getValue().toString();
            }
            if (infoName != null && infoDisplay != null) break;
        }
        String description = infoName + ": " + infoDisplay;
        this.m_chat = ws.curTab.getCM_ChatID() > 0 ? new MChat(wsc.ctx, ws.curTab.getCM_ChatID(), null) : (CM_Chat_ID > 0 ? new MChat(wsc.ctx, CM_Chat_ID, null) : new MChat(wsc.ctx, ws.curTab.getAD_Table_ID(), record_ID, description, null));
        String text = this.m_chat.getHistory("I").toString();
        form myForm = new form("WChat").setName("chat");
        myForm.setOnSubmit("this.Submit.disabled=true;return true;");
        if (CM_Chat_ID == 0) {
            myForm.addElement((Element)new input("hidden", "CM_ChatID", ws.curTab.getCM_ChatID()));
        } else {
            myForm.addElement((Element)new input("hidden", "CM_ChatID", CM_Chat_ID));
        }
        myForm.addElement((Element)new input("hidden", "AD_Table_ID", ws.curTab.getAD_Table_ID()));
        myForm.addElement((Element)new input("hidden", "record_ID", record_ID));
        myForm.addElement((Element)new input("hidden", "description", description));
        table myTable = new table("0", "0", "5", "100%", null);
        myTable.setID("WChatParameter");
        this.m_displayLength = 80;
        myTable.addElement((Element)new tr().addElement((Element)new td("History")));
        this.m_readOnly = true;
        table HistoryTable = new table("1", "0", "5", "100%", null);
        HistoryTable.addElement((Element)new tr().addElement((Element)new td(text).setRowSpan(10).setAlign("left").setVAlign("top").setColSpan(4)));
        myTable.addElement((Element)HistoryTable);
        myTable.addElement((Element)new tr().addElement((Element)new td("Input")));
        this.m_readOnly = false;
        this.m_columnName = "chatinput";
        myTable.addElement((Element)new tr().addElement((Element)this.getTextField("", 10)));
        String textbtn = "Reset";
        if (wsc.ctx != null) {
            text = Msg.getMsg(wsc.ctx, "Reset");
        }
        input restbtn = new input("reset", textbtn, "  " + text);
        restbtn.setID(text);
        restbtn.setClass("resetbtn");
        textbtn = "Submit";
        if (wsc.ctx != null) {
            text = Msg.getMsg(wsc.ctx, "Submit");
        }
        input submitbtn = new input("submit", textbtn, "  " + text);
        submitbtn.setID(text);
        submitbtn.setClass("submitbtn");
        textbtn = "Close";
        if (wsc.ctx != null) {
            text = Msg.getMsg(wsc.ctx, "Close");
        }
        input closebtn = new input("submit", textbtn, "  " + text);
        closebtn.setID(text);
        closebtn.setClass("closebtn");
        closebtn.setOnClick("self.close();return false;");
        myTable.addElement((Element)new tr().addElement((Element)new td(null, "right", "middle", false, (Element)restbtn)).addElement((Element)new td(null, "center", "middle", false, (Element)submitbtn)).addElement((Element)new td(null, "left", "middle", false, (Element)closebtn)));
        myForm.addElement((Element)myTable);
        center.addElement((Element)myForm);
        return doc;
    }
}

