/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WWindowStatus;

public class WFieldUpdate
extends HttpServlet {
    private static final long serialVersionUID = -1576213475379404148L;
    private static CLogger log = CLogger.getCLogger(WFieldUpdate.class);
    private static final String FORM_NAME = "fieldUpdate";
    private static final String FIELD_FORM = "formName";
    private static final String FIELD_NAME = "fieldName";
    private static final String FIELD_VALUE = "fieldValue";
    private static final String LOCATION_VALUE = "location";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WFieldUpdate.init");
        }
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null || ws == null) {
            // empty if block
        }
        String formName = WebUtil.getParameter(request, FIELD_FORM);
        String fieldName = WebUtil.getParameter(request, FIELD_NAME);
        String fieldValue = WebUtil.getParameter(request, FIELD_VALUE);
        String locationValue = WebUtil.getParameter(request, LOCATION_VALUE);
        log.info("doPost - Form=" + formName + " - Field=" + fieldName + " - Value=" + fieldValue + " - Location=" + locationValue);
        WebDoc doc = WFieldUpdate.createPage(wsc, ws, formName, fieldName, fieldValue, locationValue);
        form fu = new form(request.getRequestURI());
        fu.setName(FORM_NAME);
        fu.addElement((Element)new input("hidden", FIELD_FORM, "y"));
        fu.addElement((Element)new input("hidden", FIELD_NAME, "y"));
        fu.addElement((Element)new input("hidden", FIELD_VALUE, "y"));
        fu.addElement((Element)new input("hidden", LOCATION_VALUE, locationValue));
        doc.getBody().addElement((Element)fu);
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private static WebDoc createPage(WebSessionCtx wsc, WWindowStatus ws, String formName, String fieldName, String fieldValue, String locationValue) {
        WebDoc doc = WebDoc.create(true);
        body body2 = doc.getBody();
        log.info("Location-createpage: " + locationValue);
        StringBuffer sb = new StringBuffer("FieldUpdate - ").append(FIELD_FORM).append("=").append(formName).append(", ").append(FIELD_NAME).append("=").append(fieldName).append(", ").append(FIELD_VALUE).append("=").append(fieldValue).append(LOCATION_VALUE).append("=").append(locationValue);
        body2.addElement((Element)new p().addElement(sb.toString()));
        if (formName != null && fieldName != null) {
            if (formName.equals("Login2") && fieldName.equals("AD_Role_ID")) {
                WFieldUpdate.reply_Login2_Role(body2, wsc, formName, fieldValue, locationValue);
            } else if (formName.equals("Login2") && fieldName.equals("AD_Client_ID")) {
                WFieldUpdate.reply_Login2_Client(body2, wsc, formName, fieldValue, locationValue);
            } else if (formName.equals("Login2") && fieldName.equals("AD_Org_ID")) {
                WFieldUpdate.reply_Login2_Org(body2, wsc, ws, formName, fieldValue, locationValue);
            }
        }
        return doc;
    }

    private static void reply_Login2_Role(body body2, WebSessionCtx wsc, String formName, String fieldValue, String locationValue) {
        String form2 = null;
        log.info("Location-Role: " + locationValue);
        form2 = locationValue + "WWindow" + ".document.forms." + formName + ".";
        Login login = new Login(wsc.ctx);
        KeyNamePair[] clients = login.getClients(new KeyNamePair(Integer.parseInt(fieldValue), fieldValue));
        StringBuffer script2 = new StringBuffer();
        script2.append("var A=").append(form2).append("AD_Client_ID").append(".options; ");
        script2.append("A.length=0; ");
        for (int i = 0; i < clients.length; ++i) {
            KeyNamePair p2 = clients[i];
            script2.append("A[").append(i).append("]=new Option('");
            script2.append(p2.getName());
            script2.append("','");
            script2.append(p2.getKey());
            script2.append("'); ");
        }
        script2.append("\n");
        if (clients.length > 0) {
            script2.append("var B=").append(form2).append("AD_Org_ID").append(".options; ");
            script2.append("B.length=0; ");
            KeyNamePair[] orgs = login.getOrgs(clients[0]);
            for (int i = 0; i < orgs.length; ++i) {
                KeyNamePair p3 = orgs[i];
                script2.append("B[").append(i).append("]=new Option('");
                script2.append(p3.getName());
                script2.append("','");
                script2.append(p3.getKey());
                script2.append("'); ");
            }
            script2.append("\n");
            if (orgs.length > 0) {
                script2.append("var C=").append(form2).append("M_Warehouse_ID").append(".options; ");
                script2.append("C.length=0; ");
                KeyNamePair[] whs = login.getWarehouses(orgs[0]);
                if (whs != null) {
                    for (int i = 0; i < whs.length; ++i) {
                        KeyNamePair p4 = whs[i];
                        script2.append("C[").append(i).append("]=new Option('");
                        script2.append(p4.getName());
                        script2.append("','");
                        script2.append(p4.getKey());
                        script2.append("'); ");
                    }
                }
            }
        }
        body2.addElement((Element)new p().addElement("AD_Client_ID="));
        body2.addElement((Element)new script(script2.toString()));
    }

    private static void reply_Login2_Client(body body2, WebSessionCtx wsc, String formName, String fieldValue, String locationValue) {
        log.info("Location-Client: " + locationValue);
        String form2 = null;
        form2 = locationValue + "WWindow" + ".document." + formName + ".";
        StringBuffer script2 = new StringBuffer();
        script2.append("var B=").append(form2).append("AD_Org_ID").append(".options; ");
        script2.append("B.length=0; ");
        KeyNamePair client = new KeyNamePair(Integer.parseInt(fieldValue), fieldValue);
        Login login = new Login(wsc.ctx);
        KeyNamePair[] orgs = login.getOrgs(client);
        for (int i = 0; i < orgs.length; ++i) {
            KeyNamePair p2 = orgs[i];
            script2.append("B[").append(i).append("]=new Option('");
            script2.append(p2.getName());
            script2.append("','");
            script2.append(p2.getKey());
            script2.append("'); ");
        }
        script2.append("\n");
        script2.append("var C=").append(form2).append("M_Warehouse_ID").append(".options; ");
        script2.append("C.length=0; ");
        KeyNamePair[] whs = login.getWarehouses(orgs[0]);
        if (whs != null) {
            for (int i = 0; i < whs.length; ++i) {
                KeyNamePair p3 = whs[i];
                script2.append("C[").append(i).append("]=new Option('");
                script2.append(p3.getName());
                script2.append("','");
                script2.append(p3.getKey());
                script2.append("'); ");
            }
        }
        body2.addElement((Element)new p().addElement("M_Warehouse_ID="));
        body2.addElement((Element)new script(script2.toString()));
    }

    private static void reply_Login2_Org(body body2, WebSessionCtx wsc, WWindowStatus ws, String formName, String fieldValue, String locationValue) {
        String form2 = null;
        log.info("Location-Org: " + locationValue);
        form2 = locationValue + "WWindow" + ".document." + formName + ".";
        StringBuffer script2 = new StringBuffer();
        script2.append("var C=").append(form2).append("M_Warehouse_ID").append(".options; ");
        script2.append("C.length=0; ");
        KeyNamePair org = new KeyNamePair(Integer.parseInt(fieldValue), fieldValue);
        Login login = new Login(wsc.ctx);
        String error = login.validateLogin(org);
        if (error != null && error.length() > 0) {
            log.severe(error);
            ws.mWindow = null;
            wsc.ctx = new Properties();
            return;
        }
        KeyNamePair[] whs = login.getWarehouses(org);
        if (whs != null) {
            for (int i = 0; i < whs.length; ++i) {
                KeyNamePair p2 = whs[i];
                script2.append("C[").append(i).append("]=new Option('");
                script2.append(p2.getName());
                script2.append("','");
                script2.append(p2.getKey());
                script2.append("'); ");
            }
        }
        body2.addElement((Element)new p().addElement("M_Warehouse_ID="));
        body2.addElement((Element)new script(script2.toString()));
    }
}

