/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

public final class WFilter
implements Filter {
    private FilterConfig m_filterConfig = null;
    private boolean m_timing = false;
    private static CLogger log = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_filterConfig = filterConfig;
        WebEnv.initWeb(filterConfig.getServletContext());
        if (log == null) {
            log = CLogger.getCLogger(WFilter.class);
        }
        log.info(filterConfig.getFilterName());
        Enumeration en = filterConfig.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            String value = filterConfig.getInitParameter(name);
            log.config(name + "=" + value);
            if (!name.equals("Timing") || !value.equals("Y")) continue;
            this.m_timing = true;
        }
    }

    public void destroy() {
        this.m_filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        WebSessionCtx wctx = WebSessionCtx.get((HttpServletRequest)request);
        String sessionID = wctx.ctx.getProperty("#AD_Session_ID");
        if (sessionID == null) {
            // empty if block
        }
        String uri = "";
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            uri = req.getRequestURI();
        }
        boolean pass = true;
        boolean check = true;
        if (sessionID == null) {
            if (!(uri.endsWith("index.html") || uri.endsWith("cmd.html") || uri.endsWith("menu.html") || uri.endsWith("menu.js") || uri.endsWith("window.html") || uri.endsWith("Logo.gif") || uri.endsWith("standard.js") || uri.endsWith("standard.css") || uri.endsWith("calendar-blue.css") || uri.endsWith("table.css") || uri.endsWith("table.js") || uri.endsWith("calendar.js") || uri.endsWith("calendar-en.js") || uri.endsWith("window.css") || uri.endsWith("window.js") || uri.endsWith("WLogin"))) {
                pass = false;
            }
        } else if (!uri.startsWith("/adempiere") || uri.endsWith(".gif") || uri.endsWith(".jpg") || uri.endsWith(".png") || uri.endsWith(".html") || uri.endsWith(".css") || uri.endsWith(".js")) {
            check = false;
        }
        StringBuffer sb = new StringBuffer("| Parameters");
        if (check) {
            try {
                String enc = request.getCharacterEncoding();
                if (enc == null) {
                    request.setCharacterEncoding("UTF-8");
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Set CharacterEndocung=UTF-8", e);
            }
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                sb.append(" - ").append(name).append("=").append(request.getParameter(name));
            }
            if (uri.endsWith("WWindowStatus")) {
                pass = false;
            }
        }
        if (pass && check) {
            log.info("Start " + uri + sb.toString());
        }
        long myTime = 0L;
        if (pass && check && this.m_timing) {
            myTime = System.currentTimeMillis();
        }
        if (pass) {
            chain.doFilter(request, response);
        } else {
            RequestDispatcher rd = request.getRequestDispatcher("/index.html");
            rd.forward(request, response);
        }
        if (check && pass) {
            if (this.m_timing) {
                myTime = System.currentTimeMillis() - myTime;
            }
            log.info("End   " + uri + "| " + (this.m_timing ? String.valueOf(myTime) : null));
        }
    }

    public String toString() {
        if (this.m_filterConfig == null) {
            return "WFilter[]";
        }
        StringBuffer sb = new StringBuffer("WFilter[");
        sb.append(this.m_filterConfig);
        sb.append("]");
        return sb.toString();
    }
}

