/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.h2;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WWindowStatus;

public class WFindAdv
extends HttpServlet {
    private static final long serialVersionUID = -763641668438890217L;
    public static final String EQUAL = "=";
    public static final String NOT_EQUAL = "!=";
    public static final String LIKE = "LIKE";
    public static final String NOT_LIKE = "NOT LIKE";
    public static final String GREATER = ">";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS = "<";
    public static final String LESS_EQUAL = "<=";
    public static final String BETWEEN = "BETWEEN";
    private static final String P_Tab = "PTab";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WFindAdv.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession sess = request.getSession(false);
        WWindowStatus ws = null;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (sess != null) {
            ws = WWindowStatus.get(request);
        }
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = this.preparePage();
        body body2 = doc.getBody();
        String pTab = request.getParameter(P_Tab);
        if (pTab != null && pTab.equals("FindAdv")) {
            body2.addElement((Element)this.createPageFindAdv(request, response, ws));
        } else {
            body2.addElement((Element)this.createPageFind(request, response, ws));
        }
        WebUtil.createResponse(request, response, this, null, doc, true);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession sess = request.getSession(false);
        WWindowStatus ws = null;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (sess != null) {
            ws = WWindowStatus.get(request);
        }
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String pTab = request.getParameter(P_Tab);
        WebDoc doc = this.preparePage();
        body body2 = doc.getBody();
        if (pTab != null && pTab.equals("FindAdv")) {
            body2.addElement((Element)this.createPageFindAdv(request, response, ws));
        } else {
            body2.addElement((Element)this.createPageFind(request, response, ws));
        }
        WebUtil.createResponse(request, response, this, null, doc, true);
    }

    private table createTabs(String selTab) {
        td tabbar = new td("windowCenter", "left", "middle", false);
        a tab = new a("#", (Element)new span("Find"));
        if (selTab.equals("Find")) {
            tab.setID("tabSelected");
        } else {
            tab.setID("tab");
            tab.setHref("/adempiere/WFindAdv?PTab=Find");
        }
        tab.setOnMouseOver("status='Find';return true;");
        tabbar.addElement((Element)tab);
        tab = new a("#", (Element)new span("FindAdv"));
        if (selTab.equals("FindAdv")) {
            tab.setID("tabSelected");
        } else {
            tab.setID("tab");
            tab.setHref("/adempiere/WFindAdv?PTab=FindAdv");
        }
        tab.setOnMouseOver("status='FindAdv';return true;");
        tabbar.addElement((Element)tab);
        table topTable = new table("0", "0", "0", "100%", null);
        topTable.setID("WFindAdv.topTable");
        topTable.addElement((Element)new tr((Element)tabbar));
        return topTable;
    }

    private form createPageFind(HttpServletRequest request, HttpServletResponse response, WWindowStatus ws) throws ServletException, IOException {
        boolean hasValue = false;
        boolean hasName = false;
        boolean hasDocNo = false;
        boolean hasDescription = false;
        int size = ws.curTab.getFieldCount();
        for (int i = 0; i < size; ++i) {
            GridField mField = ws.curTab.getField(i);
            String columnName = mField.getColumnName();
            if (!mField.isDisplayed()) continue;
            if (columnName.equals("Value")) {
                hasValue = true;
                continue;
            }
            if (columnName.equals("Name")) {
                hasName = true;
                continue;
            }
            if (columnName.equals("DocumentNo")) {
                hasDocNo = true;
                continue;
            }
            if (!columnName.equals("Description")) continue;
            hasDescription = true;
        }
        form myForm = new form("/adempiere/WWindow", "post", "application/x-www-form-urlencoded");
        myForm.setName("WForm");
        myForm.setOnSubmit("this.target=window.opener.name");
        myForm.addElement((Element)this.createTabs("Find"));
        table table2 = new table();
        tr line = null;
        if (hasValue) {
            line = new tr();
            line.addElement((Element)new td().addElement((Element)new label().addElement(Msg.translate(ws.ctx, "Value"))).setAlign("right"));
            line.addElement((Element)new td().addElement((Element)new input("text", "txtValue", "")));
            table2.addElement((Element)line);
        }
        if (hasDocNo) {
            line = new tr();
            line.addElement((Element)new td().addElement((Element)new label().addElement(Msg.translate(ws.ctx, "DocumentNo"))).setAlign("right"));
            line.addElement((Element)new td().addElement((Element)new input("text", "txtDocumentNo", "")));
            table2.addElement((Element)line);
        }
        if (hasName) {
            line = new tr();
            line.addElement((Element)new td().addElement((Element)new label().addElement(Msg.translate(ws.ctx, "Name"))).setAlign("right"));
            line.addElement((Element)new td().addElement((Element)new input("text", "txtName", "")));
            table2.addElement((Element)line);
        }
        if (hasDescription) {
            line = new tr();
            line.addElement((Element)new td().addElement((Element)new label().addElement(Msg.translate(ws.ctx, "Description"))).setAlign("right"));
            line.addElement((Element)new td().addElement((Element)new input("text", "txtDescription", "")));
            table2.addElement((Element)line);
        }
        if (!(hasDescription || hasDocNo || hasName || hasValue)) {
            line = new tr();
            line.addElement((Element)new td().addElement((Element)new h2("N/A!")));
            table2.addElement((Element)line);
        }
        myForm.addElement((Element)table2);
        myForm.addElement((Element)new input("hidden", "txtSQL", "FIND"));
        myForm.addElement((Element)new br());
        myForm.addElement((Element)new input("hidden", "PCommand", "FindAdv"));
        myForm.addElement("&nbsp;&nbsp;");
        myForm.addElement(new input("Reset", "", "  Reset").setClass("resetbtn"));
        myForm.addElement("&nbsp;");
        input cmd = new input("Submit", "", "  Submit");
        cmd.setClass("submitbtn");
        myForm.addElement((Element)cmd);
        myForm.addElement("&nbsp;");
        cmd = new input("button", "", "  Close");
        cmd.setClass("closebtn");
        cmd.setOnClick("window.close()");
        myForm.addElement((Element)cmd);
        return myForm;
    }

    private form createPageFindAdv(HttpServletRequest request, HttpServletResponse response, WWindowStatus ws) throws ServletException, IOException {
        form myForm = new form("/adempiere/WWindow", "post", "application/x-www-form-urlencoded");
        myForm.setName("WForm");
        myForm.setOnSubmit("this.target=window.opener.name");
        myForm.addElement((Element)this.createTabs("FindAdv"));
        table table2 = new table();
        tr line = new tr();
        line.addElement((Element)new td().addElement("Field"));
        line.addElement((Element)new td().addElement("Operator"));
        line.addElement((Element)new td().addElement("Value"));
        line.addElement((Element)new td().addElement("To Value"));
        table2.addElement((Element)line);
        select select2 = new select("cboField");
        int size = ws.curTab.getFieldCount();
        for (int i = 0; i < size; ++i) {
            GridField mField = ws.curTab.getField(i);
            if (!mField.isDisplayed()) continue;
            select2.addElement((Element)new option(mField.getColumnSQL(false)).addElement(mField.getColumnSQL(false)));
        }
        line = new tr();
        line.addElement((Element)new td().addElement((Element)select2));
        select2 = new select("cboOperator", new option[]{new option(LIKE).addElement(LIKE), new option(NOT_LIKE).addElement(NOT_LIKE), new option(EQUAL).addElement(EQUAL), new option(NOT_EQUAL).addElement(NOT_EQUAL), new option(GREATER).addElement(GREATER), new option(GREATER_EQUAL).addElement(GREATER_EQUAL), new option(LESS).addElement(LESS), new option(LESS_EQUAL).addElement(LESS_EQUAL), new option(BETWEEN).addElement(BETWEEN)});
        line.addElement((Element)new td().addElement((Element)select2));
        line.addElement((Element)new td().addElement((Element)new input("text", "txtValue", "%")));
        line.addElement((Element)new td().addElement((Element)new input("text", "txtToValue", "")));
        table2.addElement((Element)line);
        line = new tr();
        input cmd = new input("button", "cmdAdd", "Add Clause");
        cmd.setOnClick("txtSQL.value+=cboField.value + ' ' + cboOperator.value + ' \\'' + txtValue.value + '\\'\\n'");
        line.addElement((Element)new td().addElement((Element)cmd));
        cmd = new input("button", "cmdAnd", "AND");
        cmd.setOnClick("txtSQL.value+='AND' + '\\n'");
        line.addElement((Element)new td().addElement((Element)cmd));
        table2.addElement((Element)line);
        cmd = new input("button", "cmdOr", "OR");
        cmd.setOnClick("txtSQL.value+='OR' + '\\n'");
        line.addElement((Element)new td().addElement((Element)cmd));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement("SQL Clause"));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement(new textarea().setName("txtSQL").setStyle("width:100%")).setColSpan(4));
        table2.addElement((Element)line);
        myForm.addElement((Element)table2);
        myForm.addElement((Element)new br());
        myForm.addElement((Element)new input("hidden", "PCommand", "FindAdv"));
        myForm.addElement("&nbsp;&nbsp;");
        myForm.addElement(new input("Reset", "", "  Reset").setClass("resetbtn"));
        myForm.addElement("&nbsp;");
        cmd = new input("Submit", "", "  Submit");
        cmd.setClass("submitbtn");
        cmd.setOnClick("if (txtSQL.value.length==0) {alert('Input SQL clause before submit');return false}");
        myForm.addElement((Element)cmd);
        myForm.addElement("&nbsp;");
        cmd = new input("button", "", "  Close");
        cmd.setClass("closebtn");
        cmd.setOnClick("window.close()");
        myForm.addElement((Element)cmd);
        return myForm;
    }

    private WebDoc preparePage() {
        WebDoc doc = WebDoc.create("Find Advance");
        head header = doc.getHead();
        header.addElement((Element)new script("", WebEnv.getBaseDirectory("js/window.js")));
        header.addElement((Element)new script("", WebEnv.getBaseDirectory("/js/check.js")));
        header.addElement((Element)new link().setRel("stylesheet").setHref(WebEnv.getBaseDirectory("css/window.css")));
        return doc;
    }
}

