/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.font;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.strong;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MSession;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WLogin
extends HttpServlet {
    private static final long serialVersionUID = -407753489095758837L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String P_USERNAME = "User";
    private static final String P_PASSWORD = "Password";
    private static final String P_SUBMIT = "Submit";
    protected static final String P_ROLE = "AD_Role_ID";
    protected static final String P_CLIENT = "AD_Client_ID";
    protected static final String P_ORG = "AD_Org_ID";
    protected static final String P_DATE = "Date";
    protected static final String P_WAREHOUSE = "M_Warehouse_ID";
    protected static final String P_ERRORMSG = "ErrorMessage";
    protected static final String P_STORE = "SaveCookie";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WLogin.init");
        }
    }

    public String getServletInfo() {
        return "adempiere Web Login";
    }

    public void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("");
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("");
        HttpSession sess = request.getSession(true);
        sess.setMaxInactiveInterval(900);
        Properties cProp = WebUtil.getCookieProprties(request);
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WebDoc doc = null;
        if (!DB.isConnected()) {
            String msg = Msg.getMsg(wsc.ctx, "WLoginNoDB");
            if (msg.equals("WLoginNoDB")) {
                msg = "No Database Connection";
            }
            doc = WebDoc.createWindow(msg);
        } else {
            String usr = WebUtil.getParameter(request, P_USERNAME);
            String pwd = WebUtil.getParameter(request, P_PASSWORD);
            Principal userPrincipal = request.getUserPrincipal();
            this.log.info("Principal=" + userPrincipal + "; User=" + usr);
            if (userPrincipal == null && (usr == null || pwd == null)) {
                doc = this.createFirstPage(cProp, request, "");
            } else {
                NamePair[] roles = null;
                Login login = new Login(wsc.ctx);
                if (userPrincipal != null) {
                    roles = login.getRoles(userPrincipal);
                    usr = userPrincipal.getName();
                } else {
                    roles = login.getRoles(usr, pwd);
                }
                if (roles == null) {
                    doc = this.createFirstPage(cProp, request, Msg.getMsg(wsc.ctx, "UserPwdError"));
                } else {
                    doc = this.createSecondPage(request, WebUtil.convertToOption(roles, null), "");
                    MSession.get(wsc.ctx, request.getRemoteAddr(), request.getRemoteHost(), sess.getId());
                }
                if (WebUtil.getParameter(request, P_STORE) == null) {
                    cProp.clear();
                } else {
                    cProp.setProperty(P_USERNAME, usr);
                    cProp.setProperty(P_STORE, "Y");
                    cProp.setProperty(P_PASSWORD, pwd);
                }
            }
        }
        WebUtil.createResponse(request, response, this, cProp, doc, false);
    }

    private WebDoc createFirstPage(Properties cProp, HttpServletRequest request, String errorMessage) {
        this.log.info(" - " + errorMessage);
        String AD_Language = cProp.getProperty("#AD_Language", Language.getAD_Language(request.getLocale()));
        String windowTitle = Msg.getMsg(AD_Language, "Login");
        String usrText = Msg.getMsg(AD_Language, P_USERNAME);
        String pwdText = Msg.getMsg(AD_Language, P_PASSWORD);
        String lngText = Msg.translate(AD_Language, "AD_Language");
        String okText = Msg.getMsg(AD_Language, "OK");
        String cancelText = Msg.getMsg(AD_Language, "Cancel");
        String storeTxt = Msg.getMsg(AD_Language, P_STORE);
        String action = request.getRequestURI();
        form myForm = null;
        myForm = new form(action).setName("Login1");
        table table2 = new table().setAlign("center").setWidth("25%");
        tr line = new tr();
        line.addElement((Element)new td().addElement(" "));
        String userData = cProp.getProperty(P_USERNAME, "");
        line = new tr();
        label usrLabel = new label().setFor("UserF").addElement(usrText);
        usrLabel.setID("UserL");
        line.addElement((Element)new td().addElement((Element)usrLabel).setAlign("right"));
        input usr = new input("text", P_USERNAME, userData).setSize(20).setMaxlength(30);
        usr.setID("UserF");
        line.addElement((Element)new td().addElement((Element)usr).setAlign("left"));
        table2.addElement((Element)line);
        String pwdData = cProp.getProperty(P_PASSWORD, "");
        line = new tr();
        label pwdLabel = new label().setFor("PasswordF").addElement(pwdText);
        pwdLabel.setID("PasswordL");
        line.addElement((Element)new td().addElement((Element)pwdLabel).setAlign("right"));
        input pwd = new input("password", P_PASSWORD, pwdData).setSize(20).setMaxlength(30);
        pwd.setID("PasswordF");
        line.addElement((Element)new td().addElement((Element)pwd).setAlign("left"));
        table2.addElement((Element)line);
        String langData = cProp.getProperty(AD_Language);
        line = new tr();
        label langLabel = new label().setFor("#AD_LanguageF").addElement(lngText);
        langLabel.setID("#AD_LanguageL");
        line.addElement((Element)new td().addElement((Element)langLabel).setAlign("right"));
        option[] options = new option[Language.getLanguageCount()];
        for (int i = 0; i < Language.getLanguageCount(); ++i) {
            Language language = Language.getLanguage(i);
            options[i] = new option(language.getAD_Language()).addElement(Util.maskHTML(language.getName()));
            if (language.getAD_Language().equals(langData)) {
                options[i].setSelected(true);
                continue;
            }
            options[i].setSelected(false);
        }
        line.addElement((Element)new td().addElement(new select("#AD_Language", options).setID("#AD_LanguageF")));
        table2.addElement((Element)line);
        String storeData = cProp.getProperty(P_STORE, "N");
        line = new tr();
        line.addElement((Element)new td());
        input store = new input("checkbox", P_STORE, "Y").addElement(storeTxt).setChecked(storeData.equals("Y"));
        store.setID("SaveCookieF");
        line.addElement((Element)new td().addElement((Element)store).setAlign("left"));
        table2.addElement((Element)line);
        if (errorMessage != null && errorMessage.length() > 0) {
            line = new tr();
            line.addElement((Element)new td().setColSpan(2).addElement((Element)new font("#FF0000", 4).addElement((Element)new b(errorMessage))));
            table2.addElement((Element)line);
        }
        line = new tr();
        table tablebutton = new table().setAlign("center").setWidth("25%");
        input cancel = new input("reset", "Reset", "  Cancel");
        cancel.setClass("cancelbtn");
        line.addElement((Element)new td().addElement((Element)cancel).setWidth("50%")).setAlign("center");
        input submit = new input("submit", P_SUBMIT, "  OK");
        submit.setClass("loginbtn");
        line.addElement((Element)new td().addElement((Element)submit).setWidth("50%").setAlign("center"));
        tablebutton.addElement((Element)line);
        table2.addElement((Element)tablebutton);
        myForm.addElement((Element)table2);
        WebDoc doc = WebDoc.createWindow(windowTitle);
        img img2 = new img(WebEnv.getImageDirectory("Logo.gif"), "logo");
        doc.addWindowCenter(true).addElement((Element)img2).addElement((Element)new p()).addElement((Element)new p()).addElement((Element)myForm).addElement((Element)new p()).addElement((Element)new p());
        doc.getBody().addElement((Element)WebUtil.getClearFrame("WMenu")).setTitle(windowTitle);
        return doc;
    }

    private WebDoc createSecondPage(HttpServletRequest request, option[] roleOptions, String errorMessage) {
        this.log.info(" - " + errorMessage);
        WebSessionCtx wsc = WebSessionCtx.get(request);
        String windowTitle = Msg.getMsg(wsc.language, "LoginSuccess");
        String action = WebEnv.getBaseDirectory("WMenu");
        form myForm = null;
        myForm = new form(action).setName("Login2");
        myForm.setTarget("WMenu");
        table table2 = new table().setAlign("center");
        tr line = new tr();
        line.addElement((Element)new td().addElement(" "));
        table2.addElement((Element)line);
        line = new tr();
        label roleLabel = new label().setFor("AD_Role_IDF").addElement(Msg.translate(wsc.language, P_ROLE));
        roleLabel.setID("AD_Role_IDL");
        line.addElement((Element)new td().addElement((Element)roleLabel).setAlign("right"));
        select role = new select(P_ROLE, roleOptions);
        role.setID("AD_Role_IDF");
        role.setOnClick("fieldUpdate(this);");
        line.addElement((Element)new td().addElement((Element)role));
        table2.addElement((Element)line);
        line = new tr();
        label clientLabel = new label().setFor("AD_Client_IDF").addElement(Msg.translate(wsc.language, P_CLIENT));
        clientLabel.setID("AD_Client_IDL");
        line.addElement((Element)new td().addElement((Element)clientLabel).setAlign("right"));
        select client = new select(P_CLIENT);
        client.setID("AD_Client_IDF");
        client.setOnClick("fieldUpdate(this);");
        line.addElement((Element)new td().addElement((Element)client));
        table2.addElement((Element)line);
        line = new tr();
        label orgLabel = new label().setFor("AD_Org_IDF").addElement(Msg.translate(wsc.language, P_ORG));
        orgLabel.setID("AD_Org_IDL");
        line.addElement((Element)new td().addElement((Element)orgLabel).setAlign("right"));
        select org = new select(P_ORG);
        org.setID("AD_Org_IDF");
        org.setOnClick("fieldUpdate(this);");
        line.addElement((Element)new td().addElement((Element)org));
        table2.addElement((Element)line);
        line = new tr();
        label whLabel = new label().setFor("M_Warehouse_IDF").addElement(Msg.translate(wsc.language, P_WAREHOUSE));
        whLabel.setID("M_Warehouse_IDL");
        line.addElement((Element)new td().addElement((Element)whLabel).setAlign("right"));
        select wh = new select(P_WAREHOUSE);
        wh.setID("M_Warehouse_IDF");
        line.addElement((Element)new td().addElement((Element)wh));
        table2.addElement((Element)line);
        String dateData = wsc.dateFormat.format(new Date());
        line = new tr();
        label dateLabel = new label().setFor("DateF").addElement(Msg.getMsg(wsc.language, P_DATE));
        dateLabel.setID("DateL");
        line.addElement((Element)new td().addElement((Element)dateLabel).setAlign("right"));
        input date = new input("text", P_DATE, dateData).setSize(10).setMaxlength(10);
        date.setID("DateF");
        line.addElement((Element)new td().addElement((Element)date).setAlign("left"));
        table2.addElement((Element)line);
        if (errorMessage != null && errorMessage.length() > 0) {
            line = new tr();
            line.addElement((Element)new td().addElement((Element)new strong(errorMessage)).setColSpan(2).setAlign("center"));
            table2.addElement((Element)line);
        }
        table tablebutton = new table().setAlign("center").setWidth("25%");
        line = new tr();
        input cancel = new input("reset", "Reset", "  Cancel");
        cancel.setOnClick("window.top.location.replace('/adempiere/index.html');");
        cancel.setClass("cancelbtn");
        line.addElement((Element)new td().addElement((Element)cancel).setWidth("50%").setAlign("center"));
        input submit = new input("submit", P_SUBMIT, "  OK");
        submit.setOnClick("showLoadingMenu('" + WebEnv.getBaseDirectory("") + "');");
        submit.setClass("loginbtn");
        line.addElement((Element)new td().addElement((Element)submit).setWidth("50%").setAlign("center"));
        tablebutton.addElement((Element)line);
        table2.addElement((Element)tablebutton);
        myForm.addElement((Element)table2);
        WebDoc doc = WebDoc.createWindow(windowTitle);
        img img2 = new img(WebEnv.getImageDirectory("Logo.gif"), "logo");
        doc.addWindowCenter(true).addElement((Element)img2).addElement((Element)new p()).addElement((Element)myForm).addElement((Element)new p()).addElement((Element)new p());
        String script2 = "fieldUpdate(document.Login2.AD_Role_ID);";
        doc.getBody().addElement((Element)new script(script2));
        doc.addWindowFooter().addElement((Element)new p(Msg.getMsg(wsc.language, "WLoginBrowserNote"), "center"));
        return doc;
    }
}

