/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.X_AD_Process_Para;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WWindowStatus;

public class WLookup
extends HttpServlet {
    private static final long serialVersionUID = 4835226093865297019L;
    protected static CLogger log = CLogger.getCLogger(WLookup.class);
    protected volatile ArrayList<Object> p_data = new ArrayList();
    private static final int MAX_LINES = 99999;
    private int m_recordCount;
    private int m_colCount;
    private StringBuffer m_HeaderSelect = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WLookup.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebEnv.dump(request);
        WebEnv.dump(request.getSession());
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String columnName = WebUtil.getParameter(request, "ColumnName");
        int AD_Process_ID = WebUtil.getParameterAsInt(request, "AD_Process_ID");
        int page = WebUtil.getParameterAsInt(request, "page");
        log.info("This is the page on original call" + page);
        if (AD_Process_ID > 0) {
            if (AD_Process_ID < 1 || columnName == null || columnName.equals("")) {
                WebUtil.createErrorPage(request, response, this, Msg.getMsg(wsc.ctx, "ParameterMissing"));
                return;
            }
            String targetBase = "'" + columnName;
            MProcess process = MProcess.get(wsc.ctx, AD_Process_ID);
            X_AD_Process_Para para = null;
            MProcessPara[] parameter = process.getParameters();
            for (int i = 0; i < parameter.length; ++i) {
                para = parameter[i];
                if (!para.getColumnName().equals(columnName)) continue;
                i = parameter.length;
            }
            WebDoc doc = WebDoc.createPopup(para.getColumnName());
            div panel = new div();
            panel.setStyle("height: 330px;overflow: scroll;overflow: auto;");
            panel.addElement((Element)this.fillTable(wsc, para.getColumnName(), para.getAD_Reference_Value_ID(), request.getRequestURI(), targetBase, false, page));
            String text = "Reset";
            input resetbtn = new input("button", text, "  " + text);
            resetbtn.setID(text);
            resetbtn.setClass("resetbtn");
            String script2 = targetBase + "F.value='';" + targetBase + "D.value='';closePopup();";
            resetbtn.setOnClick(script2);
            text = "First";
            input firstpgbtn = new input("button", text, "  " + text);
            firstpgbtn.setOnClick("startLookup('" + columnName + "', " + AD_Process_ID + ", 1);return false;");
            firstpgbtn.setID(text);
            firstpgbtn.setClass("firstpgbtn");
            text = "Prior";
            input prevpgbtn = new input("button", text, "  " + text);
            int prevpage = page == 1 ? 1 : page - 1;
            prevpgbtn.setOnClick("startLookup('" + columnName + "', " + AD_Process_ID + ", " + prevpage + ");return false;");
            prevpgbtn.setID(text);
            prevpgbtn.setClass("prevpgbtn");
            text = "Next";
            input nextpgbtn = new input("button", text, "  " + text);
            int nextpage = page + 1;
            nextpgbtn.setOnClick("startLookup('" + columnName + "', " + AD_Process_ID + ", " + nextpage + ");return false;");
            nextpgbtn.setID(text);
            nextpgbtn.setClass("nextpgbtn");
            text = "Next";
            input lastpgbtn = new input("button", text, "  " + text);
            int lastpage = this.m_recordCount / 99999 + 1;
            lastpgbtn.setOnClick("startLookup('" + columnName + "', " + AD_Process_ID + ", " + lastpage + ");return false;");
            lastpgbtn.setID(text);
            lastpgbtn.setClass("lastpgbtn");
            int index1 = (page - 1) * 99999 + 1;
            int index2 = page * 99999 < this.m_recordCount ? page * 99999 : this.m_recordCount;
            doc.getTable().addElement((Element)new tr((Element)new td((Element)panel).setColSpan(2)));
            doc.addPopupClose(ws.ctx)[0].addElement("&nbsp;#&nbsp;" + index1 + "-" + index2 + " / " + this.m_recordCount).addElement((Element)resetbtn).addElement((Element)firstpgbtn).addElement((Element)prevpgbtn).addElement((Element)nextpgbtn).addElement((Element)lastpgbtn);
            WebUtil.createResponse(request, response, this, null, doc, false);
        } else {
            if (ws == null) {
                WebUtil.createTimeoutPage(request, response, this, null);
                return;
            }
            GridField mField = ws.curTab.getField(columnName);
            log.config("ColumnName=" + columnName + ", MField=" + mField);
            if (mField == null || columnName == null || columnName.equals("")) {
                WebUtil.createErrorPage(request, response, this, Msg.getMsg(ws.ctx, "ParameterMissing"));
                return;
            }
            String targetBase = "'" + columnName;
            WebDoc doc = WebDoc.createPopup(mField.getHeader());
            boolean hasDependents = ws.curTab.hasDependants(columnName);
            boolean hasCallout = mField.getCallout().length() > 0;
            div panel = new div();
            panel.setStyle("height: 330px;overflow: scroll;overflow: auto;");
            panel.addElement((Element)this.fillTable(wsc, mField.getColumnName(), mField.getAD_Reference_Value_ID(), request.getRequestURI(), targetBase, hasDependents || hasCallout, page));
            String text = "Reset";
            input resetbtn = new input("reset", text, "  " + text);
            resetbtn.setID(text);
            resetbtn.setClass("resetbtn");
            String script3 = targetBase + "F.value='';" + targetBase + "D.value='';self.close();";
            if (hasDependents || hasCallout) {
                script3 = script3 + "startUpdate(" + targetBase + "F);";
            }
            resetbtn.setOnClick(script3);
            text = "First";
            input firstpgbtn = new input("button", text, "  " + text);
            firstpgbtn.setOnClick("startLookup('" + columnName + "', " + AD_Process_ID + ", 1);return false;");
            firstpgbtn.setID(text);
            firstpgbtn.setClass("firstpgbtn");
            text = "Prior";
            input prevpgbtn = new input("button", text, "  " + text);
            int prevpage = page == 1 ? 1 : page - 1;
            prevpgbtn.setOnClick("startLookup('" + columnName + "', " + AD_Process_ID + ", " + prevpage + ");return false;");
            prevpgbtn.setID(text);
            prevpgbtn.setClass("prevpgbtn");
            text = "Next";
            input nextpgbtn = new input("button", text, "  " + text);
            int nextpage = page + 1;
            nextpgbtn.setOnClick("startLookup('" + columnName + "', " + AD_Process_ID + ", " + nextpage + ");return false;");
            nextpgbtn.setID(text);
            nextpgbtn.setClass("nextpgbtn");
            text = "Last";
            input lastpgbtn = new input("button", text, "  " + text);
            int lastpage = this.m_recordCount / 99999 + 1;
            lastpgbtn.setOnClick("startLookup('" + columnName + "', " + AD_Process_ID + ", " + lastpage + ");return false;");
            lastpgbtn.setID(text);
            lastpgbtn.setClass("lastpgbtn");
            int index1 = (page - 1) * 99999 + 1;
            int index2 = page * 99999 < this.m_recordCount ? page * 99999 : this.m_recordCount;
            doc.getTable().addElement((Element)new tr((Element)new td((Element)panel).setColSpan(2)));
            doc.addPopupClose(ws.ctx)[0].addElement("&nbsp;#&nbsp;" + index1 + "-" + index2 + " / " + this.m_recordCount).addElement((Element)resetbtn).addElement((Element)firstpgbtn).addElement((Element)prevpgbtn).addElement((Element)nextpgbtn).addElement((Element)lastpgbtn);
            WebUtil.createResponse(request, response, this, null, doc, false);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.config("");
        this.doGet(request, response);
    }

    private table fillTable(WebSessionCtx wsc, String columnName, int fieldRefId, String action, String targetBase, boolean addStart, int page) {
        table table2 = new table("1");
        table2.setID("WLookup");
        table2.setClass("MultiRow table-autofilter table-filterable table-autosort table-autostripe table-stripeclass:alternate");
        table2.addElement("<thead>");
        tr line = new tr();
        line = this.fillTable_Lookup_Headers(columnName, fieldRefId, line, targetBase, true, true, true, false, true);
        tr line2 = new tr();
        line2 = this.fillTable_Lookup_Headers(columnName, fieldRefId, line2, targetBase, true, true, true, false, false);
        table2.addElement((Element)line2);
        table2.addElement((Element)line);
        table2.addElement("</thead>");
        table2.addElement("<tbody>");
        table2 = this.fillTable_Lookup_Rows(wsc, columnName, fieldRefId, table2, targetBase, true, true, true, false, page);
        table2.addElement("</tbody>");
        return table2;
    }

    private table fillTable_Lookup_Rows(WebSessionCtx wsc, String columnName, int fieldRefId, table table1, String targetBase, boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary, int page) {
        StringBuffer sqlSelect = null;
        StringBuffer sqlCount = null;
        String sql = null;
        String colKey = null;
        String colDisplay = null;
        if (fieldRefId > 0) {
            sql = "SELECT AD_Table_ID, AD_Key, AD_Display, WhereClause, OrderByClause FROM AD_Ref_Table WHERE AD_Reference_ID = " + fieldRefId;
            int tableID = 0;
            String whereClause = null;
            String orderBy = null;
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    tableID = rs.getInt(1);
                    whereClause = rs.getString(4);
                    orderBy = rs.getString(5);
                    sql = "Select ColumnName FROM AD_Column Where AD_Column_ID = ? AND AD_Table_ID = ?";
                    colKey = DB.getSQLValueString(null, sql, rs.getInt(2), tableID);
                    colDisplay = DB.getSQLValueString(null, sql, rs.getInt(3), tableID);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql.toString(), e);
            }
            sql = "Select TableName FROM AD_Table Where AD_Table_ID = ?";
            String tableName = DB.getSQLValueString(null, sql, tableID);
            sqlSelect = new StringBuffer("SELECT " + this.m_HeaderSelect + " FROM " + tableName + " WHERE AD_Client_ID=?");
            sqlCount = new StringBuffer("SELECT count(*) FROM " + tableName + " WHERE AD_Client_ID=?");
            if (whereClause != null) {
                sqlSelect.append(" AND " + whereClause);
                sqlCount.append(" AND " + whereClause);
            }
            if (orderBy != null) {
                sqlSelect.append(" ORDER BY " + orderBy);
            }
        } else {
            sqlSelect = new StringBuffer("SELECT " + this.m_HeaderSelect + " FROM " + columnName.replace("_ID", "") + " WHERE AD_Client_ID=?");
            sqlCount = new StringBuffer("SELECT count(*) FROM " + columnName.replace("_ID", "") + " WHERE AD_Client_ID=?");
            colKey = columnName;
            colDisplay = this.m_HeaderSelect.toString().contains("Name") ? "Name" : "Description";
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sqlSelect.toString(), 1004, 1007, null);
            pstmt.setInt(1, Env.getAD_Client_ID(wsc.ctx));
            ResultSet rs = pstmt.executeQuery();
            log.info("This is the page number " + page);
            log.info("This is the MAX_LINES 99999");
            while (rs.next()) {
                button button2 = new button();
                button2.addElement("&gt;");
                StringBuffer script2 = new StringBuffer();
                script2.append("startLookUpdate(").append(targetBase).append("F',").append(targetBase).append("D','").append(rs.getString(colKey)).append("',").append(targetBase).append("F','").append(rs.getString(colDisplay)).append("');startUpdate(").append(targetBase).append("');return false;");
                button2.setOnClick(script2.toString());
                tr line = new tr();
                line.addElement((Element)new td((Element)button2));
                for (int i = 1; i <= this.m_colCount; ++i) {
                    line.addElement((Element)new td(rs.getString(i)));
                }
                table1.addElement((Element)line);
            }
            this.m_recordCount = DB.getSQLValue(null, sqlCount.toString(), Env.getAD_Client_ID(wsc.ctx));
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        return table1;
    }

    private tr fillTable_Lookup_Headers(String columnName, int fieldRefId, tr line, String targetBase, boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary, boolean firstHeaderLine) {
        String sqlSelect = null;
        input filter = null;
        sqlSelect = fieldRefId > 0 ? "SELECT ColumnName, Name FROM AD_Column WHERE AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Ref_Table WHERE AD_Reference_ID = " + fieldRefId + ") ORDER BY SEQNO" : "SELECT ColumnName, Name FROM AD_Column WHERE AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Table WHERE TableName = '" + columnName.replace("_ID", "") + "') ORDER BY SEQNO";
        if (firstHeaderLine) {
            line.addElement((Element)new th());
            this.m_HeaderSelect = new StringBuffer(columnName);
            line.addElement(new th(columnName).setClass("table-filterable table-filtered table-sortable:default"));
            this.m_colCount = 1;
        } else {
            line.addElement((Element)new th("Find"));
            filter = new input("text", columnName + "filter", "");
            filter.setOnKeyUp("Table.filter(this,this)");
            line.addElement((Element)new th().addElement((Element)filter));
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sqlSelect.toString(), null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String col = rs.getString(1);
                if (!col.equals("Value") && !col.equals("DocumentNo") && !col.equals("Name") && !col.equals("Description")) continue;
                if (firstHeaderLine) {
                    line.addElement(new th(rs.getString(2)).setClass("table-filterable table-filtered table-sortable:default"));
                    this.m_HeaderSelect.append(",").append(col);
                    ++this.m_colCount;
                    continue;
                }
                filter = new input("text", rs.getString(2) + "filter", "");
                filter.setOnKeyUp("Table.filter(this,this)");
                line.addElement((Element)new th().addElement((Element)filter));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sqlSelect.toString(), e);
        }
        return line;
    }
}

