/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.i;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridTab;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBankStatement;
import org.compiere.model.MInOut;
import org.compiere.model.MInventory;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPayment;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.wf.MWFActivity;
import org.compiere.www.WProcessCtl;
import org.compiere.www.WWindowStatus;
import org.compiere.www.WebField;

public class WProcess
extends HttpServlet {
    private static final long serialVersionUID = 3937980012432969521L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private String errorMessage = null;
    private static String[] s_value = null;
    private static String[] s_name;
    private static String[] s_description;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WProcess.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = null;
        int AD_Menu_ID = WebUtil.getParameterAsInt(request, "AD_Menu_ID");
        String fileName = WebUtil.getParameter(request, "File");
        if (AD_Menu_ID > 0) {
            doc = this.createParameterPage(wsc, AD_Menu_ID, 0, 0, 0, 0, null, null);
        } else {
            int AD_Process_ID = WebUtil.getParameterAsInt(request, "AD_Process_ID");
            int AD_Window_ID = WebUtil.getParameterAsInt(request, "AD_Window_ID");
            int AD_Table_ID = WebUtil.getParameterAsInt(request, "AD_Table_ID");
            int AD_Record_ID = WebUtil.getParameterAsInt(request, "AD_Record_ID");
            String columnName = WebUtil.getParameter(request, "columnName");
            int AD_Tab_ID = WebUtil.getParameterAsInt(request, "AD_Tab_ID");
            if (AD_Process_ID == 0) {
                WebUtil.createErrorPage(request, response, this, "No Process");
                return;
            }
            doc = this.createParameterPage(wsc, AD_Process_ID, AD_Window_ID, AD_Table_ID, AD_Record_ID, 1, columnName, ws.curTab);
        }
        if (doc == null) {
            doc = WebDoc.createWindow("Process Not Found");
        }
        WebUtil.createResponse(request, response, this, null, doc, true);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int AD_Process_ID = WebUtil.getParameterAsInt(request, "AD_Process_ID");
        int AD_Window_ID = WebUtil.getParameterAsInt(request, "AD_Window_ID");
        int AD_Table_ID = WebUtil.getParameterAsInt(request, "AD_Table_ID");
        int AD_Record_ID = WebUtil.getParameterAsInt(request, "AD_Record_ID");
        if (AD_Process_ID == 0) {
            WebUtil.createErrorPage(request, response, this, "No Process");
            return;
        }
        this.createProcessPage(request, response, AD_Process_ID, AD_Window_ID);
    }

    private WebDoc createParameterPage(WebSessionCtx wsc, int processId, int windowID, int tableID, int recordID, int Type2, String columnName, GridTab mTab) {
        MProcess process = null;
        process = Type2 == 0 ? MProcess.getFromMenu(wsc.ctx, processId) : MProcess.get(wsc.ctx, processId);
        if (process == null) {
            WebDoc doc = WebDoc.createWindow("Process Not Found");
            return doc;
        }
        WebDoc doc = WebDoc.createWindow(process.getName());
        if (process.isWorkflow()) {
            if (mTab == null) {
                doc = WebDoc.createWindow("No Tab found");
                return doc;
            }
            if (columnName.toString().equals("DocAction")) {
                this.readReference();
                option[] Options = this.dynInit(windowID, tableID, recordID, columnName, mTab);
                td center = doc.addWindowCenter(false);
                WebField wField = new WebField(wsc, columnName, columnName, columnName, 17, 22, 22, false, false, false, false, false, false, processId, 0, 0, 0, 0, null, null, null, null, null);
                if (process.getDescription() != null) {
                    center.addElement((Element)new p((Element)new i(process.getDescription())));
                }
                if (process.getHelp() != null) {
                    center.addElement((Element)new p(process.getHelp(), "left"));
                }
                form myForm = new form("WProcess").setName("process" + process.getAD_Process_ID());
                myForm.setTarget("WPopup");
                myForm.addElement((Element)new input("hidden", "AD_Process_ID", process.getAD_Process_ID()));
                myForm.addElement((Element)new input("hidden", "AD_Window_ID", windowID));
                myForm.addElement((Element)new input("hidden", "AD_Table_ID", tableID));
                myForm.addElement((Element)new input("hidden", "AD_Record_ID", recordID));
                table myTable = new table("0", "0", "5", "100%", null);
                myTable.setID("WProcessParameter");
                myTable.addElement((Element)new tr().addElement((Element)wField.getLabel()).addElement((Element)this.createSelectField(columnName, Options)));
                String text = "Reset";
                if (wsc.ctx != null) {
                    text = Msg.getMsg(wsc.ctx, "Reset");
                }
                input restbtn = new input("reset", text, "  " + text);
                restbtn.setID(text);
                restbtn.setClass("resetbtn");
                text = "Submit";
                if (wsc.ctx != null) {
                    text = Msg.getMsg(wsc.ctx, "Submit");
                }
                input submitbtn = new input("submit", text, "  " + text);
                submitbtn.setID(text);
                submitbtn.setClass("submitbtn");
                myTable.addElement((Element)new tr().addElement((Element)new td(null, "right", "middle", false, (Element)restbtn)).addElement((Element)new td(null, "left", "middle", false, (Element)submitbtn)).addElement((Element)new td(null, "right", "middle", false, null)));
                myForm.addElement((Element)myTable);
                center.addElement((Element)myForm);
            }
        } else {
            td center = doc.addWindowCenter(false);
            if (process.getDescription() != null) {
                center.addElement((Element)new p((Element)new i(process.getDescription())));
            }
            if (process.getHelp() != null) {
                center.addElement((Element)new p(process.getHelp(), "left"));
            }
            form myForm = new form("WProcess").setName("process" + process.getAD_Process_ID());
            myForm.setTarget("WPopup");
            myForm.addElement((Element)new input("hidden", "AD_Process_ID", process.getAD_Process_ID()));
            myForm.addElement((Element)new input("hidden", "AD_Window_ID", windowID));
            myForm.addElement((Element)new input("hidden", "AD_Table_ID", tableID));
            myForm.addElement((Element)new input("hidden", "AD_Record_ID", recordID));
            table myTable = new table("0", "0", "5", "100%", null);
            myTable.setID("WProcessParameter");
            MProcessPara[] parameter = process.getParameters();
            for (int i2 = 0; i2 < parameter.length; ++i2) {
                MProcessPara para = parameter[i2];
                WebField wField = new WebField(wsc, para.getColumnName(), para.getName(), para.getDescription(), para.getAD_Reference_ID(), para.getFieldLength(), para.getFieldLength(), false, false, para.isMandatory(), false, false, false, para.getAD_Process_ID(), 0, 0, 0, i2, null, null, null, null, null);
                WebField wFieldforRange = null;
                if (para.isRange()) {
                    wFieldforRange = new WebField(wsc, para.getColumnName(), para.getName(), para.getDescription(), para.getAD_Reference_ID(), para.getFieldLength(), para.getFieldLength(), false, false, para.isMandatory(), false, false, false, para.getAD_Process_ID(), 0, 0, 0, i2 + 1, null, null, null, null, null);
                }
                td toField = para.isRange() ? wFieldforRange.getField(para.getLookup(), para.getDefaultValue2()) : new td(WebEnv.NBSP);
                myTable.addElement((Element)new tr().addElement((Element)wField.getLabel()).addElement((Element)wField.getField(para.getLookup(), para.getDefaultValue())).addElement((Element)toField));
            }
            String text = "Reset";
            if (wsc.ctx != null) {
                text = Msg.getMsg(wsc.ctx, "Reset");
            }
            input restbtn = new input("reset", text, "  " + text);
            restbtn.setID(text);
            restbtn.setClass("resetbtn");
            text = "Submit";
            if (wsc.ctx != null) {
                text = Msg.getMsg(wsc.ctx, "Submit");
            }
            input submitbtn = new input("submit", text, "  " + text);
            submitbtn.setID(text);
            submitbtn.setClass("submitbtn");
            submitbtn.setOnClick("popUp('WProcess','WPopup')");
            myTable.addElement((Element)new tr().addElement((Element)new td(null, "right", "middle", false, (Element)restbtn)).addElement((Element)new td(null, "left", "middle", false, (Element)submitbtn)).addElement((Element)new td(null, "right", "middle", false, null)));
            myForm.addElement((Element)myTable);
            center.addElement((Element)myForm);
        }
        return doc;
    }

    public void createProcessPage(HttpServletRequest request, HttpServletResponse response, int AD_Process_ID, int AD_Window_ID) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MProcess process = MProcess.get(wsc.ctx, AD_Process_ID);
        this.log.info("PI table id " + process.get_Table_ID());
        this.log.info("PI table name id " + process.get_TableName());
        this.log.info("PI table client id " + process.getAD_Client_ID());
        this.log.info("PI table process id " + process.getAD_Process_ID());
        this.log.info("PI  process class name " + process.getClassname());
        WebDoc doc = null;
        if (process == null) {
            doc = WebDoc.createWindow("Process Not Found");
        } else {
            doc = WebDoc.createWindow(process.getName());
            td center = doc.addWindowCenter(false);
            if (process.getDescription() != null) {
                center.addElement((Element)new p((Element)new i(process.getDescription())));
            }
            if (process.getHelp() != null) {
                center.addElement((Element)new p(process.getHelp(), "left"));
            }
            MPInstance pInstance = this.fillParameter(request, process);
            int AD_Table_ID = WebUtil.getParameterAsInt(request, "AD_Table_ID");
            int AD_Record_ID = WebUtil.getParameterAsInt(request, "AD_Record_ID");
            ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), AD_Table_ID, AD_Record_ID);
            pi.setAD_User_ID(Env.getAD_User_ID(wsc.ctx));
            pi.setAD_Client_ID(Env.getAD_Client_ID(wsc.ctx));
            pi.setClassName(process.getClassname());
            this.log.info("PI client id " + pi.getAD_Client_ID());
            pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
            p p2 = new p();
            p2.addElement(Msg.translate(wsc.ctx, "AD_PInstance_ID") + ": " + pInstance.getAD_PInstance_ID());
            center.addElement((Element)p2);
            boolean processOK = false;
            if (process.isWorkflow()) {
                Trx trx = Trx.get(Trx.createTrxName("WebPrc"), true);
                try {
                    WProcessCtl.process((Object)this, AD_Window_ID, pi, trx, request);
                    trx.commit();
                    trx.close();
                }
                catch (Throwable t) {
                    trx.rollback();
                    trx.close();
                }
                if (pi.isError()) {
                    center.addElement(new p("Error:" + pi.getSummary(), "left").setClass("Cerror"));
                    processOK = false;
                } else {
                    center.addElement((Element)new p("OK: Workflow Started", "left"));
                    processOK = true;
                }
                center.addElement((Element)new p().addElement(pi.getSummary()));
                center.addElement(pi.getLogInfo(true));
            }
            String jasper = process.getJasperReport();
            if (process.isJavaProcess()) {
                if (jasper != null) {
                    pi.setPrintPreview(false);
                    pi.setIsBatch(true);
                }
                Trx trx = Trx.get(Trx.createTrxName("WebPrc"), true);
                try {
                    processOK = process.processIt(pi, trx);
                    trx.commit();
                    trx.close();
                }
                catch (Throwable t) {
                    trx.rollback();
                    trx.close();
                }
                if (!processOK || pi.isError()) {
                    center.addElement(new p("Error:" + pi.getSummary(), "left").setClass("Cerror"));
                    processOK = false;
                } else if (jasper != null) {
                    String error = WebUtil.streamFile(response, pi.getPDFReport());
                    if (error == null) {
                        return;
                    }
                    doc = WebDoc.create(error);
                    wsc.ctx.put("AD_PInstance_ID=" + pInstance.getAD_PInstance_ID(), "ok");
                } else {
                    center.addElement((Element)new p().addElement(pi.getSummary()));
                    center.addElement(pi.getLogInfo(true));
                }
            }
            if (process.isReport() && jasper == null) {
                this.log.info(response.toString());
                ReportEngine re = ReportEngine.get(wsc.ctx, pi);
                if (re == null) {
                    center.addElement(new p("Could not start ReportEngine", "left").setClass("Cerror"));
                } else {
                    try {
                        File file = File.createTempFile("WProcess", ".pdf");
                        boolean ok = re.createPDF(file);
                        if (ok) {
                            String error = WebUtil.streamFile(response, file);
                            if (error == null) {
                                return;
                            }
                            doc = WebDoc.create(error);
                            wsc.ctx.put("AD_PInstance_ID=" + pInstance.getAD_PInstance_ID(), "ok");
                        } else {
                            center.addElement(new p("Could not create Report", "left").setClass("Cerror"));
                        }
                    }
                    catch (Exception e) {
                        center.addElement(new p("Could not create Report:", "left").setClass("Cerror"));
                        center.addElement(e.toString());
                    }
                }
            }
        }
        doc.addPopupClose(wsc.ctx);
        try {
            WebUtil.createResponse(request, response, this, null, doc, false);
        }
        catch (IOException e) {
            this.log.info(e.toString());
        }
    }

    private ASyncProcess ASyncProcess(WProcess process) {
        return null;
    }

    private MPInstance fillParameter(HttpServletRequest request, MProcess process) {
        MPInstance pInstance = new MPInstance(process, 0);
        MPInstancePara[] iParams = pInstance.getParameters();
        for (int pi = 0; pi < iParams.length; ++pi) {
            MPInstancePara iPara = iParams[pi];
            String key = iPara.getParameterName();
            MProcessPara pPara = process.getParameter(key);
            if (pPara == null) {
                this.log.log(Level.SEVERE, "Parameter not found: " + key);
                continue;
            }
            String valueString = WebUtil.getParameter(request, key);
            this.log.fine("fillParameter - " + key + " = " + valueString);
            String value = valueString;
            if (valueString != null && valueString.length() == 0) {
                value = null;
            }
            if (value == null) continue;
            try {
                if (DisplayType.isNumeric(pPara.getAD_Reference_ID()) || DisplayType.isID(pPara.getAD_Reference_ID())) {
                    BigDecimal bd = null;
                    bd = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                    iPara.setP_Number(bd);
                    this.log.fine("fillParameter - " + key + " = " + valueString + " (=" + bd + "=)");
                } else if (DisplayType.isDate(pPara.getAD_Reference_ID())) {
                    Timestamp ts = null;
                    ts = value instanceof Timestamp ? (Timestamp)((Object)value) : Timestamp.valueOf(value.toString());
                    iPara.setP_Date(ts);
                    this.log.fine("fillParameter - " + key + " = " + valueString + " (=" + ts + "=)");
                } else {
                    iPara.setP_String(value.toString());
                }
                iPara.save();
                continue;
            }
            catch (Exception e) {
                this.log.warning("fillParameter - " + key + " = " + valueString + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
            }
        }
        return pInstance;
    }

    private String streamResult(HttpServletRequest request, HttpServletResponse response, int AD_PInstance_ID, File file) {
        if (AD_PInstance_ID == 0) {
            return "Your process not found";
        }
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Object value = wsc.ctx.get("AD_PInstance_ID=" + AD_PInstance_ID);
        if (value == null || !value.equals("ok")) {
            return "Process Instance not found";
        }
        if (file == null || file.length() == 0L) {
            return "No Process Result";
        }
        if (!file.exists()) {
            return "Process Result not found: " + file;
        }
        return WebUtil.streamFile(response, file);
    }

    private option[] dynInit(int m_WindowNo, int m_AD_Table_ID, int Record_ID, String columnName, GridTab m_mTab) {
        String DocStatus = (String)m_mTab.getValue("DocStatus");
        String DocAction2 = (String)m_mTab.getValue("DocAction");
        Object Processing = m_mTab.getValue("Processing");
        String OrderType = Env.getContext(Env.getCtx(), m_WindowNo, "OrderType");
        String IsSOTrx = Env.getContext(Env.getCtx(), m_WindowNo, "IsSOTrx");
        option[] optionsret = new option[]{};
        String[] list = new String[s_value.length];
        if (DocStatus == null) {
            this.errorMessage = "Document Status is Null";
            return optionsret;
        }
        this.log.fine("DocStatus=" + DocStatus + ", DocAction=" + DocAction2 + ", OrderType=" + OrderType + ", IsSOTrx=" + IsSOTrx + ", Processing=" + Processing + ", AD_Table_ID=" + m_AD_Table_ID + ", Record_ID=" + Record_ID);
        int index = 0;
        String wfStatus = MWFActivity.getActiveInfo(Env.getCtx(), m_AD_Table_ID, Record_ID);
        if (wfStatus != null) {
            this.errorMessage = wfStatus;
            return optionsret;
        }
        if (!this.checkStatus(m_mTab.getTableName(), Record_ID, DocStatus)) {
            this.errorMessage = "DocumentStatusChanged";
            return optionsret;
        }
        if (Processing != null) {
            boolean locked = "Y".equals(Processing);
            if (!locked && Processing instanceof Boolean) {
                locked = (Boolean)Processing;
            }
            if (locked) {
                list[index++] = "XL";
            }
        }
        if (DocStatus.equals("NA")) {
            list[index++] = "PR";
            list[index++] = "VO";
        } else if (DocStatus.equals("DR") || DocStatus.equals("IN")) {
            list[index++] = "CO";
            list[index++] = "VO";
        } else if (DocStatus.equals("IP") || DocStatus.equals("AP")) {
            list[index++] = "CO";
            list[index++] = "VO";
        } else if (DocStatus.equals("CO")) {
            list[index++] = "CL";
        } else if (DocStatus.equals("WP") || DocStatus.equals("WC")) {
            list[index++] = "VO";
            list[index++] = "PR";
        } else if (DocStatus.equals("CL") || DocStatus.equals("VO") || DocStatus.equals("RE")) {
            return optionsret;
        }
        if (m_AD_Table_ID == MOrder.Table_ID) {
            if (DocStatus.equals("DR") || DocStatus.equals("IP") || DocStatus.equals("IN")) {
                list[index++] = "PR";
                list[index++] = "CL";
                if ("Y".equals(IsSOTrx) && ("OB".equals(OrderType) || "ON".equals(OrderType))) {
                    DocAction2 = "PR";
                }
            } else if (DocStatus.equals("CO")) {
                list[index++] = "VO";
                list[index++] = "RE";
            } else if (DocStatus.equals("WP")) {
                list[index++] = "RE";
                list[index++] = "CL";
            }
        } else if (m_AD_Table_ID == MInOut.Table_ID) {
            if (DocStatus.equals("CO")) {
                list[index++] = "VO";
                list[index++] = "RC";
            }
        } else if (m_AD_Table_ID == MInvoice.Table_ID) {
            if (DocStatus.equals("CO")) {
                list[index++] = "VO";
                list[index++] = "RC";
            }
        } else if (m_AD_Table_ID == MPayment.Table_ID) {
            if (DocStatus.equals("CO")) {
                list[index++] = "VO";
                list[index++] = "RC";
            }
        } else if (m_AD_Table_ID == MJournal.Table_ID || m_AD_Table_ID == MJournalBatch.Table_ID) {
            if (DocStatus.equals("CO")) {
                list[index++] = "RC";
                list[index++] = "RA";
            }
        } else if (m_AD_Table_ID == MAllocationHdr.Table_ID) {
            if (DocStatus.equals("CO")) {
                list[index++] = "VO";
                list[index++] = "RC";
            }
        } else if (m_AD_Table_ID == MBankStatement.Table_ID) {
            if (DocStatus.equals("CO")) {
                list[index++] = "VO";
            }
        } else if ((m_AD_Table_ID == MMovement.Table_ID || m_AD_Table_ID == MInventory.Table_ID) && DocStatus.equals("CO")) {
            list[index++] = "VO";
            list[index++] = "RC";
        }
        option[] options = new option[index];
        for (int i2 = 0; i2 < index; ++i2) {
            boolean added = false;
            for (int j = 0; j < s_value.length && !added; ++j) {
                if (!list[i2].equals(s_value[j])) continue;
                options[i2] = new option(list[i2]).addElement(s_name[j]);
                added = true;
                if (!DocAction2.equals(s_value[i2])) continue;
                options[i2].setSelected(true);
            }
        }
        return options;
    }

    private void readReference() {
        String sql = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT Value, Name, Description FROM AD_Ref_List WHERE AD_Reference_ID=135 ORDER BY Name" : "SELECT l.Value, t.Name, t.Description FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "'" + " AND l.AD_Reference_ID=135 ORDER BY t.Name";
        ArrayList<String> v_value = new ArrayList<String>();
        ArrayList<String> v_name = new ArrayList<String>();
        ArrayList<String> v_description = new ArrayList<String>();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String value = rs.getString(1);
                String name = rs.getString(2);
                String description = rs.getString(3);
                if (description == null) {
                    description = "";
                }
                v_value.add(value);
                v_name.add(name);
                v_description.add(description);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        int size = v_value.size();
        s_value = new String[size];
        s_name = new String[size];
        s_description = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            WProcess.s_value[i2] = (String)v_value.get(i2);
            WProcess.s_name[i2] = (String)v_name.get(i2);
            WProcess.s_description[i2] = (String)v_description.get(i2);
        }
    }

    private boolean checkStatus(String TableName, int Record_ID, String DocStatus) {
        String sql = "SELECT 2 FROM " + TableName + " WHERE " + TableName + "_ID=" + Record_ID + " AND DocStatus='" + DocStatus + "'";
        int result = DB.getSQLValue(null, sql);
        return result == 2;
    }

    private td createSelectField(String m_columnName, option[] options) {
        select sel = new select(m_columnName, options);
        sel.setID(m_columnName);
        sel.setDisabled(false);
        sel.setClass("Cmandatory");
        return this.createTD((Element)sel);
    }

    private td createTD(Element element) {
        td td2 = new td().addElement(element).setAlign("left").setVAlign("top");
        return td2;
    }
}

