/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Trx;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WProcessCtl;
import org.compiere.www.WWindowStatus;

public class WReport
extends HttpServlet {
    private static final long serialVersionUID = -6281182537210181407L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private GridTab m_curTab;
    private ArrayList<KeyNamePair> m_list = new ArrayList();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WReport.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.fine("doGet");
        this.log.info(response.toString());
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        this.m_curTab = ws.curTab;
        WebDoc doc = null;
        File file = null;
        if (ws == null) {
            doc = WebDoc.createPopup("No Context");
            doc.addPopupClose(wsc.ctx);
        } else {
            String error;
            this.log.info("");
            if (!MRole.getDefault().isCanReport(ws.curTab.getAD_Table_ID())) {
                doc = WebDoc.createPopup("Access Cannot Report");
                doc.addPopupClose(wsc.ctx);
            }
            MQuery query = new MQuery(this.m_curTab.getTableName());
            String queryColumn = this.m_curTab.getLinkColumnName();
            if (queryColumn.length() == 0) {
                queryColumn = this.m_curTab.getKeyColumnName();
            }
            String infoName = null;
            String infoDisplay = null;
            for (int i2 = 0; i2 < this.m_curTab.getFieldCount(); ++i2) {
                GridField field = this.m_curTab.getField(i2);
                if (field.isKey()) {
                    infoName = field.getHeader();
                }
                if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                    infoDisplay = field.getValue().toString();
                }
                if (infoName != null && infoDisplay != null) break;
            }
            if (queryColumn.length() != 0) {
                if (queryColumn.endsWith("_ID")) {
                    query.addRestriction(queryColumn, "=", new Integer(Env.getContextAsInt(wsc.ctx, this.m_curTab.getWindowNo(), queryColumn)), infoName, infoDisplay);
                } else {
                    query.addRestriction(queryColumn, "=", Env.getContext(wsc.ctx, this.m_curTab.getWindowNo(), queryColumn), infoName, infoDisplay);
                }
            }
            if ((error = WebUtil.streamFile(response, file = this.getPrintFormats(this.m_curTab.getAD_Table_ID(), request, this.m_curTab, query))) == null) {
                return;
            }
            doc = WebDoc.createWindow(error);
        }
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebDoc doc = WebDoc.createPopup("Report - Post - Not Implemented");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private File getPrintFormats(int AD_Table_ID, HttpServletRequest request, GridTab m_curTab, MQuery m_query) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int AD_Client_ID = Env.getAD_Client_ID(wsc.ctx);
        File file = null;
        this.m_list = new ArrayList();
        String sql = MRole.getDefault().addAccessSQL("SELECT AD_PrintFormat_ID, Name, AD_Client_ID FROM AD_PrintFormat WHERE AD_Table_ID=? AND IsTableBased='Y' ORDER BY AD_Client_ID DESC, IsDefault DESC, Name", "AD_PrintFormat", false, false);
        KeyNamePair pp = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                if (rs.getInt(3) != AD_Client_ID) continue;
                this.m_list.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        file = this.m_list.size() == 0 ? (pp == null ? this.createNewFormat(AD_Table_ID, request, m_curTab, m_query) : this.copyFormat(pp.getKey(), AD_Client_ID, request, m_curTab, m_query)) : this.launchReport(this.m_list.get(0), request, m_curTab, m_query);
        return file;
    }

    private File createNewFormat(int AD_Table_ID, HttpServletRequest request, GridTab m_curTab, MQuery m_query) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MPrintFormat pf = MPrintFormat.createFromTable(wsc.ctx, AD_Table_ID);
        File file = this.launchReport(pf, request, m_curTab, m_query);
        return file;
    }

    private File copyFormat(int AD_PrintFormat_ID, int To_Client_ID, HttpServletRequest request, GridTab m_curTab, MQuery m_query) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MPrintFormat pf = MPrintFormat.copyToClient(wsc.ctx, AD_PrintFormat_ID, To_Client_ID);
        File file = this.launchReport(pf, request, m_curTab, m_query);
        return file;
    }

    private File launchReport(KeyNamePair pp, HttpServletRequest request, GridTab m_curTab, MQuery m_query) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MPrintFormat pf = MPrintFormat.get(wsc.ctx, pp.getKey(), false);
        File file = this.launchReport(pf, request, m_curTab, m_query);
        return file;
    }

    private File launchReport(MPrintFormat pf, HttpServletRequest request, GridTab m_curTab, MQuery m_query) {
        int Record_ID = 0;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        File fileName = null;
        if (m_query.getRestrictionCount() == 1 && m_query.getCode(0) instanceof Integer) {
            Record_ID = (Integer)m_query.getCode(0);
        }
        PrintInfo info = new PrintInfo(pf.getName(), pf.getAD_Table_ID(), Record_ID);
        info.setDescription(m_query.getInfo());
        if (pf != null && pf.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", pf.getJasperProcess_ID());
            Trx trx = Trx.get(Trx.createTrxName("WebPrc"), true);
            WProcessCtl.process((Object)this, m_curTab.getAD_Window_ID(), pi, trx, request);
        } else {
            ReportEngine re = new ReportEngine(wsc.ctx, pf, m_query, info);
            if (re == null) {
                this.log.info("Could not start ReportEngine");
            } else {
                try {
                    File file = File.createTempFile("WProcess", ".pdf");
                    boolean ok = re.createPDF(file);
                    if (ok) {
                        fileName = file;
                    } else {
                        this.log.info("Could not create Report");
                    }
                }
                catch (Exception e) {
                    this.log.info(e.toString());
                }
            }
        }
        return fileName;
    }

    public static int getAD_Table_ID(String TableName) {
        int AD_Table_ID = 0;
        String sql = "SELECT AD_Table_ID FROM AD_Table WHERE TableName=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, TableName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                AD_Table_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return AD_Table_ID;
    }
}

